/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.firmware;

import org.eclipse.smarthome.core.events.AbstractEvent;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.firmware.FirmwareUpdateResult;
import org.eclipse.smarthome.core.thing.firmware.FirmwareUpdateResultInfo;

public final class FirmwareUpdateResultInfoEvent
extends AbstractEvent {
    public static final String TYPE = FirmwareUpdateResultInfoEvent.class.getSimpleName();
    private final FirmwareUpdateResultInfo firmwareUpdateResultInfo;
    private final ThingUID thingUID;

    protected FirmwareUpdateResultInfoEvent(String topic, String payload, FirmwareUpdateResultInfo firmwareUpdateResultInfo, ThingUID thingUID) {
        super(topic, payload, null);
        this.firmwareUpdateResultInfo = firmwareUpdateResultInfo;
        this.thingUID = thingUID;
    }

    public FirmwareUpdateResultInfo getFirmwareUpdateResultInfo() {
        return this.firmwareUpdateResultInfo;
    }

    public ThingUID getThingUID() {
        return this.thingUID;
    }

    public String getType() {
        return TYPE;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.firmwareUpdateResultInfo == null ? 0 : this.firmwareUpdateResultInfo.hashCode());
        result = 31 * result + (this.thingUID == null ? 0 : this.thingUID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        FirmwareUpdateResultInfoEvent other = (FirmwareUpdateResultInfoEvent)((Object)obj);
        if (this.firmwareUpdateResultInfo == null ? other.firmwareUpdateResultInfo != null : !this.firmwareUpdateResultInfo.equals(other.firmwareUpdateResultInfo)) {
            return false;
        }
        return !(this.thingUID == null ? other.thingUID != null : !this.thingUID.equals(other.thingUID));
    }

    public String toString() {
        FirmwareUpdateResult result = this.firmwareUpdateResultInfo.getResult();
        StringBuilder sb = new StringBuilder(String.format("The result of the firmware update for thing %s is %s.", this.thingUID, result.name()));
        if (result == FirmwareUpdateResult.ERROR) {
            sb.append(String.format(" The error message is %s.", this.firmwareUpdateResultInfo.getErrorMessage()));
        }
        return sb.toString();
    }
}

