/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.firmware;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.i18n.I18nProvider;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.firmware.FirmwareUID;
import org.eclipse.smarthome.core.thing.binding.firmware.FirmwareUpdateHandler;
import org.eclipse.smarthome.core.thing.binding.firmware.ProgressCallback;
import org.eclipse.smarthome.core.thing.binding.firmware.ProgressStep;
import org.eclipse.smarthome.core.thing.firmware.FirmwareEventFactory;
import org.eclipse.smarthome.core.thing.firmware.FirmwareUpdateProgressInfo;
import org.eclipse.smarthome.core.thing.firmware.FirmwareUpdateResult;
import org.eclipse.smarthome.core.thing.firmware.FirmwareUpdateResultInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

final class ProgressCallbackImpl
implements ProgressCallback {
    private final FirmwareUpdateHandler firmwareUpdateHandler;
    private final EventPublisher eventPublisher;
    private final I18nProvider i18nProvider;
    private final ThingUID thingUID;
    private final FirmwareUID firmwareUID;
    private final Locale locale;
    private Collection<ProgressStep> sequence;
    private Iterator<ProgressStep> progressIterator;

    ProgressCallbackImpl(FirmwareUpdateHandler firmwareUpdateHandler, EventPublisher eventPublisher, I18nProvider i18nProvider, ThingUID thingUID, FirmwareUID firmwareUID, Locale locale) {
        this.firmwareUpdateHandler = firmwareUpdateHandler;
        this.eventPublisher = eventPublisher;
        this.i18nProvider = i18nProvider;
        this.thingUID = thingUID;
        this.firmwareUID = firmwareUID;
        this.locale = locale;
    }

    @Override
    public void defineSequence(ProgressStep ... sequence) {
        Preconditions.checkArgument((sequence != null && sequence.length > 0 ? 1 : 0) != 0, (Object)"Sequence must not be null or empty.");
        this.sequence = Collections.unmodifiableCollection(Arrays.asList(sequence));
        this.progressIterator = this.sequence.iterator();
    }

    @Override
    public void next() {
        Preconditions.checkState((this.sequence != null ? 1 : 0) != 0, (Object)"No sequence defined.");
        if (!this.progressIterator.hasNext()) {
            throw new IllegalStateException("There is no further progress step to be executed.");
        }
        ProgressStep next = this.progressIterator.next();
        this.post((Event)FirmwareEventFactory.createFirmwareUpdateProgressInfoEvent(new FirmwareUpdateProgressInfo(this.firmwareUID, next, this.sequence), this.thingUID));
    }

    @Override
    public void failed(String errorMessageKey, Object ... arguments) {
        Preconditions.checkArgument((errorMessageKey != null && !errorMessageKey.isEmpty() ? 1 : 0) != 0, (Object)"The error message key must not be null or empty.");
        String errorMessage = this.getErrorMessage(FrameworkUtil.getBundle(this.firmwareUpdateHandler.getClass()), errorMessageKey, arguments);
        this.postError(errorMessage);
    }

    @Override
    public void success() {
        this.post((Event)FirmwareEventFactory.createFirmwareUpdateResultInfoEvent(new FirmwareUpdateResultInfo(FirmwareUpdateResult.SUCCESS, null), this.thingUID));
    }

    void failedInternal(String errorMessageKey) {
        String errorMessage = this.getErrorMessage(FrameworkUtil.getBundle(ProgressCallbackImpl.class), errorMessageKey, new Object[0]);
        this.postError(errorMessage);
    }

    private String getErrorMessage(Bundle bundle, String errorMessageKey, Object ... arguments) {
        String errorMessage = this.i18nProvider.getText(bundle, errorMessageKey, null, this.locale, arguments);
        return errorMessage;
    }

    private void postError(String errorMessage) {
        this.post((Event)FirmwareEventFactory.createFirmwareUpdateResultInfoEvent(new FirmwareUpdateResultInfo(FirmwareUpdateResult.ERROR, errorMessage), this.thingUID));
    }

    private void post(Event event) {
        this.eventPublisher.post(event);
    }
}

