/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.internal;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.config.core.ConfigDescriptionRegistry;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.ThingFactory;
import org.eclipse.smarthome.core.thing.binding.builder.ChannelBuilder;
import org.eclipse.smarthome.core.thing.type.ChannelDefinition;
import org.eclipse.smarthome.core.thing.type.ChannelGroupDefinition;
import org.eclipse.smarthome.core.thing.type.ChannelGroupType;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.type.ThingType;
import org.eclipse.smarthome.core.thing.type.TypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThingFactoryHelper {
    private static Logger logger = LoggerFactory.getLogger(ThingFactory.class);

    public static List<Channel> createChannels(ThingType thingType, ThingUID thingUID, ConfigDescriptionRegistry configDescriptionRegistry) {
        ArrayList channels = Lists.newArrayList();
        List<ChannelDefinition> channelDefinitions = thingType.getChannelDefinitions();
        for (ChannelDefinition channelDefinition : channelDefinitions) {
            Channel channel = ThingFactoryHelper.createChannel(channelDefinition, thingUID, null, configDescriptionRegistry);
            if (channel == null) continue;
            channels.add(channel);
        }
        List<ChannelGroupDefinition> channelGroupDefinitions = thingType.getChannelGroupDefinitions();
        for (ChannelGroupDefinition channelGroupDefinition : channelGroupDefinitions) {
            ChannelGroupType channelGroupType = TypeResolver.resolve(channelGroupDefinition.getTypeUID());
            if (channelGroupType != null) {
                List<ChannelDefinition> channelGroupChannelDefinitions = channelGroupType.getChannelDefinitions();
                for (ChannelDefinition channelDefinition : channelGroupChannelDefinitions) {
                    Channel channel = ThingFactoryHelper.createChannel(channelDefinition, thingUID, channelGroupDefinition.getId(), configDescriptionRegistry);
                    if (channel == null) continue;
                    channels.add(channel);
                }
                continue;
            }
            logger.warn("Could not create channels for channel group '{}' for thing type '{}', because channel group type '{}' could not be found.", new Object[]{channelGroupDefinition.getId(), thingUID, channelGroupDefinition.getTypeUID()});
        }
        return channels;
    }

    private static Channel createChannel(ChannelDefinition channelDefinition, ThingUID thingUID, String groupId, ConfigDescriptionRegistry configDescriptionRegistry) {
        ConfigDescription cd;
        ChannelType type = TypeResolver.resolve(channelDefinition.getChannelTypeUID());
        if (type == null) {
            logger.warn("Could not create channel '{}' for thing type '{}', because channel type '{}' could not be found.", new Object[]{channelDefinition.getId(), thingUID, channelDefinition.getChannelTypeUID()});
            return null;
        }
        ChannelBuilder channelBuilder = ChannelBuilder.create(new ChannelUID(thingUID, groupId, channelDefinition.getId()), type.getItemType()).withType(type.getUID()).withDefaultTags(type.getTags());
        if (channelDefinition.getLabel() != null) {
            channelBuilder = channelBuilder.withLabel(channelDefinition.getLabel());
        }
        if (channelDefinition.getDescription() != null) {
            channelBuilder = channelBuilder.withDescription(channelDefinition.getDescription());
        }
        URI channelConfigDescriptionURI = type.getConfigDescriptionURI();
        if (configDescriptionRegistry != null && channelConfigDescriptionURI != null && (cd = configDescriptionRegistry.getConfigDescription(channelConfigDescriptionURI)) != null) {
            Configuration config = new Configuration();
            for (ConfigDescriptionParameter param : cd.getParameters()) {
                Object value;
                String defaultValue = param.getDefault();
                if (defaultValue == null || (value = ThingFactoryHelper.getDefaultValueAsCorrectType(param.getType(), defaultValue)) == null) continue;
                config.put(param.getName(), value);
            }
            channelBuilder = channelBuilder.withConfiguration(config);
        }
        channelBuilder = channelBuilder.withProperties(channelDefinition.getProperties());
        Channel channel = channelBuilder.build();
        return channel;
    }

    public static Object getDefaultValueAsCorrectType(ConfigDescriptionParameter.Type parameterType, String defaultValue) {
        try {
            switch (parameterType) {
                case TEXT: {
                    return defaultValue;
                }
                case BOOLEAN: {
                    return Boolean.parseBoolean(defaultValue);
                }
                case INTEGER: {
                    return new BigDecimal(defaultValue);
                }
                case DECIMAL: {
                    return new BigDecimal(defaultValue);
                }
            }
            return null;
        }
        catch (NumberFormatException ex) {
            LoggerFactory.getLogger(ThingFactory.class).warn("Could not parse default value '" + defaultValue + "' as type '" + parameterType + "': " + ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static void applyDefaultConfiguration(Configuration configuration, ThingType thingType, ConfigDescriptionRegistry configDescriptionRegistry) {
        ConfigDescription thingConfigDescription;
        if (configDescriptionRegistry != null && configuration != null && thingType.hasConfigDescriptionURI() && (thingConfigDescription = configDescriptionRegistry.getConfigDescription(thingType.getConfigDescriptionURI())) != null) {
            for (ConfigDescriptionParameter parameter : thingConfigDescription.getParameters()) {
                Object value;
                String defaultValue = parameter.getDefault();
                if (defaultValue == null || configuration.get(parameter.getName()) != null || (value = ThingFactoryHelper.getDefaultValueAsCorrectType(parameter.getType(), defaultValue)) == null) continue;
                configuration.put(parameter.getName(), value);
            }
        }
    }
}

