/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.internal;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.config.core.ConfigDescriptionRegistry;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.common.SafeMethodCaller;
import org.eclipse.smarthome.core.common.ThreadPoolManager;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.items.events.AbstractItemEventSubscriber;
import org.eclipse.smarthome.core.items.events.ItemCommandEvent;
import org.eclipse.smarthome.core.items.events.ItemEventFactory;
import org.eclipse.smarthome.core.items.events.ItemStateEvent;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.BundleProcessor;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.ManagedThingProvider;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.ThingStatusInfo;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerCallback;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerFactory;
import org.eclipse.smarthome.core.thing.binding.builder.ThingStatusInfoBuilder;
import org.eclipse.smarthome.core.thing.events.ThingEventFactory;
import org.eclipse.smarthome.core.thing.internal.ThingFactoryHelper;
import org.eclipse.smarthome.core.thing.internal.ThingImpl;
import org.eclipse.smarthome.core.thing.internal.ThingRegistryImpl;
import org.eclipse.smarthome.core.thing.internal.ThingTracker;
import org.eclipse.smarthome.core.thing.link.ItemChannelLinkRegistry;
import org.eclipse.smarthome.core.thing.type.ThingType;
import org.eclipse.smarthome.core.thing.type.ThingTypeRegistry;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThingManager
extends AbstractItemEventSubscriber
implements ThingTracker,
BundleProcessor.BundleProcessorListener {
    private static final String FORCEREMOVE_THREADPOOL_NAME = "forceRemove";
    private static final String THING_MANAGER_THREADPOOL_NAME = "thingManager";
    private final Multimap<Bundle, Object> initializerVetoes = Multimaps.synchronizedListMultimap((ListMultimap)LinkedListMultimap.create());
    private final Multimap<String, ThingHandler> initializerQueue = Multimaps.synchronizedListMultimap((ListMultimap)LinkedListMultimap.create());
    private Logger logger = LoggerFactory.getLogger(ThingManager.class);
    private final ScheduledExecutorService scheduler = ThreadPoolManager.getScheduledPool((String)"thingManager");
    private BundleContext bundleContext;
    private EventPublisher eventPublisher;
    private ItemChannelLinkRegistry itemChannelLinkRegistry;
    private List<ThingHandlerFactory> thingHandlerFactories = new CopyOnWriteArrayList<ThingHandlerFactory>();
    private Map<ThingUID, ThingHandler> thingHandlers = new ConcurrentHashMap<ThingUID, ThingHandler>();
    private ThingHandlerTracker thingHandlerTracker;
    private ThingTypeRegistry thingTypeRegistry;
    private ThingHandlerCallback thingHandlerCallback = new ThingHandlerCallback(){

        @Override
        public void stateUpdated(ChannelUID channelUID, State state) {
            Set<String> items = ThingManager.this.itemChannelLinkRegistry.getLinkedItems(channelUID);
            for (String item : items) {
                ThingManager.this.eventPublisher.post((Event)ItemEventFactory.createStateEvent((String)item, (State)state, (String)channelUID.toString()));
            }
        }

        @Override
        public void postCommand(ChannelUID channelUID, Command command) {
            Set<String> items = ThingManager.this.itemChannelLinkRegistry.getLinkedItems(channelUID);
            for (String item : items) {
                ThingManager.this.eventPublisher.post((Event)ItemEventFactory.createCommandEvent((String)item, (Command)command, (String)channelUID.toString()));
            }
        }

        @Override
        public void statusUpdated(Thing thing, ThingStatusInfo thingStatus) {
            if (ThingStatus.REMOVING.equals((Object)thing.getStatus()) && !ThingStatus.REMOVED.equals((Object)thingStatus.getStatus())) {
                return;
            }
            ThingStatusInfo oldStatusInfo = thing.getStatusInfo();
            ThingManager.this.setThingStatus(thing, thingStatus);
            if (thing instanceof Bridge) {
                Bridge bridge = (Bridge)thing;
                if (oldStatusInfo.getStatus() == ThingStatus.INITIALIZING && ThingManager.this.isInitialized(thing)) {
                    ThingManager.this.notifyThingsAboutBridgeInitialization(bridge);
                }
                ThingManager.this.updateThingStatus(thingStatus, bridge);
                if (!oldStatusInfo.equals(thingStatus)) {
                    ThingManager.this.notifyThingsAboutBridgeStatusChange(thingStatus, bridge);
                }
            }
            if (thing.getBridgeUID() != null && oldStatusInfo.getStatus() == ThingStatus.INITIALIZING && ThingManager.this.isInitialized(thing)) {
                ThingManager.this.notifyThingAboutBridgeInitialization(thing);
            }
            if (ThingStatus.REMOVING.equals((Object)thing.getStatus())) {
                ThingManager.this.notifyThingAboutRemoval(thing);
            } else if (ThingStatus.REMOVED.equals((Object)thing.getStatus())) {
                ThingManager.this.notifyRegistryAboutForceRemove(thing);
            }
        }

        @Override
        public void thingUpdated(final Thing thing) {
            ThingManager.this.thingUpdatedLock.add(thing.getUID());
            Thing ret = AccessController.doPrivileged(new PrivilegedAction<Thing>(){

                @Override
                public Thing run() {
                    return (Thing)ThingManager.this.managedThingProvider.update(thing);
                }
            });
            ThingManager.this.thingUpdatedLock.remove(thing.getUID());
            if (ret == null) {
                throw new IllegalStateException(MessageFormat.format("Could not update thing {0}. Most likely because it is read-only.", thing.getUID().getAsString()));
            }
        }

        @Override
        public void configurationUpdated(Thing thing) {
            ThingManager.this.initializeHandler(thing);
        }

        @Override
        public void changeThingType(final Thing thing, final ThingTypeUID thingTypeUID, final Configuration configuration) {
            ThingManager.this.scheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    ThingUID thingUID = thing.getUID();
                    this.waitForRunningHandlerRegistrations(thingUID);
                    ThingType thingType = ThingManager.this.thingTypeRegistry.getThingType(thingTypeUID);
                    ThingHandlerFactory oldThingHandlerFactory = ThingManager.this.findThingHandlerFactory(thing.getThingTypeUID());
                    if (oldThingHandlerFactory != null) {
                        ThingManager.this.unregisterHandler(thing, oldThingHandlerFactory);
                    }
                    List<Channel> channels = ThingFactoryHelper.createChannels(thingType, thingUID, ThingManager.this.configDescriptionRegistry);
                    ((ThingImpl)thing).setChannels(channels);
                    ThingFactoryHelper.applyDefaultConfiguration(configuration, thingType, ThingManager.this.configDescriptionRegistry);
                    ((ThingImpl)thing).setConfiguration(configuration);
                    ((ThingImpl)thing).setThingTypeUID(thingTypeUID);
                    ThingManager.this.thingRegistry.update(thing);
                    ThingManager.this.logger.debug("Changed ThingType of Thing {} to {}. New ThingHandler is {}.", new Object[]{thing.getUID().toString(), thing.getThingTypeUID(), thing.getHandler().toString()});
                }

                private void waitForRunningHandlerRegistrations(ThingUID thingUID) {
                    int i = 0;
                    while (i < 100) {
                        if (!ThingManager.this.registerHandlerLock.contains(thingUID)) {
                            return;
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                        ++i;
                    }
                    throw new RuntimeException(MessageFormat.format("Thing type migration failed for {0}. Could not obtain lock for hander registration.", thingUID.getAsString()));
                }
            }, 0L, TimeUnit.MILLISECONDS);
        }
    };
    private ThingRegistryImpl thingRegistry;
    private ConfigDescriptionRegistry configDescriptionRegistry;
    private ManagedThingProvider managedThingProvider;
    private Set<Thing> things = new CopyOnWriteArraySet<Thing>();
    private Set<ThingUID> registerHandlerLock = new HashSet<ThingUID>();
    private Set<ThingUID> thingUpdatedLock = new HashSet<ThingUID>();
    private Set<BundleProcessor> bundleProcessors = new HashSet<BundleProcessor>();

    public void handlerAdded(Thing thing, ThingHandler thingHandler) {
        this.logger.debug("Assigning handler for thing '{}'.", (Object)thing.getUID());
        thingHandler.setCallback(this.thingHandlerCallback);
        thing.setHandler(thingHandler);
        this.initializeHandler(thing);
    }

    public void handlerRemoved(Thing thing, ThingHandler thingHandler) {
        this.logger.debug("Unassigning handler for thing '{}' and setting status to UNINITIALIZED.", (Object)thing.getUID());
        thing.setHandler(null);
        ThingStatusInfo statusInfo = this.buildStatusInfo(ThingStatus.UNINITIALIZED, ThingStatusDetail.HANDLER_MISSING_ERROR);
        this.setThingStatus(thing, statusInfo);
        thingHandler.setCallback(null);
        this.disposeHandler(thing, thingHandler);
        if (thing instanceof Bridge) {
            this.notifyThingsAboutBridgeDisposal((Bridge)thing);
        }
    }

    protected void receiveCommand(ItemCommandEvent commandEvent) {
        String itemName = commandEvent.getItemName();
        final Command command = commandEvent.getItemCommand();
        Set<ChannelUID> boundChannels = this.itemChannelLinkRegistry.getBoundChannels(itemName);
        for (final ChannelUID channelUID : boundChannels) {
            if (channelUID.toString().equals(commandEvent.getSource())) continue;
            Thing thing = this.getThing(channelUID.getThingUID());
            if (thing != null) {
                final ThingHandler handler = thing.getHandler();
                if (handler != null) {
                    if (this.isInitialized(thing)) {
                        this.logger.debug("Delegating command '{}' for item '{}' to handler for channel '{}'", new Object[]{command, itemName, channelUID});
                        try {
                            SafeMethodCaller.call((SafeMethodCaller.ActionWithException)new SafeMethodCaller.ActionWithException<Void>(){

                                public Void call() throws Exception {
                                    handler.handleCommand(channelUID, command);
                                    return null;
                                }
                            });
                        }
                        catch (TimeoutException timeoutException) {
                            this.logger.warn("Handler for thing '{}' takes more than {}ms for processing event", (Object)handler.getThing().getUID(), (Object)SafeMethodCaller.DEFAULT_TIMEOUT);
                        }
                        catch (Exception ex) {
                            this.logger.error("Exception occured while calling handler: " + ex.getMessage(), (Throwable)ex);
                        }
                        continue;
                    }
                    this.logger.info("Not delegating command '{}' for item '{}' to handler for channel '{}', because thing is not initialized (must be in status ONLINE or OFFLINE).", new Object[]{command, itemName, channelUID});
                    continue;
                }
                this.logger.warn("Cannot delegate command '{}' for item '{}' to handler for channel '{}', because no handler is assigned. Maybe the binding is not installed or not propertly initialized.", new Object[]{command, itemName, channelUID});
                continue;
            }
            this.logger.warn("Cannot delegate command '{}' for item '{}' to handler for channel '{}', because no thing with the UID '{}' could be found.", new Object[]{command, itemName, channelUID, channelUID.getThingUID()});
        }
    }

    protected void receiveUpdate(ItemStateEvent updateEvent) {
        String itemName = updateEvent.getItemName();
        final State newState = updateEvent.getItemState();
        Set<ChannelUID> boundChannels = this.itemChannelLinkRegistry.getBoundChannels(itemName);
        for (final ChannelUID channelUID : boundChannels) {
            if (channelUID.toString().equals(updateEvent.getSource())) continue;
            Thing thing = this.getThing(channelUID.getThingUID());
            if (thing != null) {
                final ThingHandler handler = thing.getHandler();
                if (handler != null) {
                    if (this.isInitialized(thing)) {
                        this.logger.debug("Delegating update '{}' for item '{}' to handler for channel '{}'", new Object[]{newState, itemName, channelUID});
                        try {
                            SafeMethodCaller.call((SafeMethodCaller.ActionWithException)new SafeMethodCaller.ActionWithException<Void>(){

                                public Void call() throws Exception {
                                    handler.handleUpdate(channelUID, newState);
                                    return null;
                                }
                            });
                        }
                        catch (TimeoutException timeoutException) {
                            this.logger.warn("Handler for thing {} takes more than {}ms for processing event", (Object)handler.getThing().getUID(), (Object)SafeMethodCaller.DEFAULT_TIMEOUT);
                        }
                        catch (Exception ex) {
                            this.logger.error("Exception occured while calling handler: " + ex.getMessage(), (Throwable)ex);
                        }
                        continue;
                    }
                    this.logger.info("Not delegating update '{}' for item '{}' to handler for channel '{}', because thing is not initialized (must be in status ONLINE or OFFLINE).", new Object[]{newState, itemName, channelUID});
                    continue;
                }
                this.logger.warn("Cannot delegate update '{}' for item '{}' to handler for channel '{}', because no handler is assigned. Maybe the binding is not installed or not propertly initialized.", new Object[]{newState, itemName, channelUID});
                continue;
            }
            this.logger.warn("Cannot delegate update '{}' for item '{}' to handler for channel '{}', because no thing with the UID '{}' could be found.", new Object[]{newState, itemName, channelUID, channelUID.getThingUID()});
        }
    }

    @Override
    public void thingAdded(Thing thing, ThingTracker.ThingTrackerEvent thingTrackerEvent) {
        this.things.add(thing);
        this.logger.debug("Thing '{}' is tracked by ThingManager.", (Object)thing.getUID());
        ThingHandler thingHandler = this.thingHandlers.get(thing.getUID());
        if (thingHandler == null) {
            this.registerHandler(thing);
        } else {
            this.logger.debug("Handler for thing '{}' already exists.", (Object)thing.getUID());
            this.handlerAdded(thing, thingHandler);
        }
    }

    @Override
    public void thingRemoving(Thing thing, ThingTracker.ThingTrackerEvent thingTrackerEvent) {
        this.thingHandlerCallback.statusUpdated(thing, ThingStatusInfoBuilder.create(ThingStatus.REMOVING).build());
    }

    @Override
    public void thingRemoved(final Thing thing, ThingTracker.ThingTrackerEvent thingTrackerEvent) {
        ThingUID thingId = thing.getUID();
        ThingHandler thingHandler = this.thingHandlers.get(thingId);
        if (thingHandler != null) {
            final ThingHandlerFactory thingHandlerFactory = this.findThingHandlerFactory(thing.getThingTypeUID());
            if (thingHandlerFactory != null) {
                this.unregisterHandler(thing, thingHandlerFactory);
                if (thingTrackerEvent == ThingTracker.ThingTrackerEvent.THING_REMOVED) {
                    SafeMethodCaller.call((SafeMethodCaller.Action)new SafeMethodCaller.Action<Void>(){

                        public Void call() throws Exception {
                            thingHandlerFactory.removeThing(thing.getUID());
                            return null;
                        }
                    });
                }
            } else {
                this.logger.warn("Cannot unregister handler. No handler factory for thing '{}' found.", (Object)thing.getUID());
            }
        }
        this.logger.debug("Thing '{}' is no longer tracked by ThingManager.", (Object)thing.getUID());
        this.things.remove(thing);
    }

    @Override
    public void thingUpdated(final Thing thing, ThingTracker.ThingTrackerEvent thingTrackerEvent) {
        ThingHandler thingHandler;
        ThingUID thingUID = thing.getUID();
        Thing oldThing = this.getThing(thingUID);
        if (oldThing != thing) {
            this.things.remove(oldThing);
            this.things.add(thing);
        }
        if ((thingHandler = this.thingHandlers.get(thingUID)) != null) {
            if (oldThing != thing) {
                thing.setHandler(thingHandler);
            }
            if (this.isInitialized(thing)) {
                try {
                    if (!this.thingUpdatedLock.contains(thingUID)) {
                        SafeMethodCaller.call((SafeMethodCaller.ActionWithException)new SafeMethodCaller.ActionWithException<Void>(){

                            public Void call() throws Exception {
                                thingHandler.thingUpdated(thing);
                                return null;
                            }
                        });
                    }
                }
                catch (Exception ex) {
                    this.logger.error("Exception occured while calling thing updated at ThingHandler '" + thingHandler + ": " + ex.getMessage(), (Throwable)ex);
                }
            } else {
                this.logger.debug("Cannot notify handler about updated thing {}, because thing is not initialized (must be in status ONLINE or OFFLINE).", (Object)thing.getThingTypeUID());
            }
        } else {
            this.registerHandler(thing);
        }
        if (oldThing != thing) {
            oldThing.setHandler(null);
        }
    }

    private void registerHandler(Thing thing) {
        ThingUID thingUID = thing.getUID();
        if (!this.registerHandlerLock.contains(thingUID)) {
            this.registerHandlerLock.add(thingUID);
            ThingHandlerFactory thingHandlerFactory = this.findThingHandlerFactory(thing.getThingTypeUID());
            if (thingHandlerFactory != null) {
                this.registerHandler(thing, thingHandlerFactory);
            } else {
                this.logger.debug("Not registering a handler at this point since no handler factory for thing '{}' found.", (Object)thingUID);
            }
            this.registerHandlerLock.remove(thingUID);
        } else {
            this.logger.warn("Attempt to register a handler twice for thing {} at the same time will be ignored.", (Object)thingUID);
        }
    }

    private ThingHandlerFactory findThingHandlerFactory(ThingTypeUID thingTypeUID) {
        for (ThingHandlerFactory factory : this.thingHandlerFactories) {
            if (!factory.supportsThingType(thingTypeUID)) continue;
            return factory;
        }
        return null;
    }

    private Thing getThing(ThingUID id) {
        for (Thing thing : this.things) {
            if (!thing.getUID().equals(id)) continue;
            return thing;
        }
        return null;
    }

    private void registerHandler(final Thing thing, final ThingHandlerFactory thingHandlerFactory) {
        this.logger.debug("Calling registerHandler handler for thing '{}' at '{}'.", (Object)thing.getUID(), (Object)thingHandlerFactory);
        try {
            SafeMethodCaller.call((SafeMethodCaller.ActionWithException)new SafeMethodCaller.ActionWithException<Void>(){

                public Void call() throws Exception {
                    thingHandlerFactory.registerHandler(thing, ThingManager.this.thingHandlerCallback);
                    return null;
                }
            });
        }
        catch (TimeoutException timeoutException) {
            this.logger.warn("Registering handler for thing '{}' takes more than {}ms.", (Object)thing.getUID(), (Object)SafeMethodCaller.DEFAULT_TIMEOUT);
        }
        catch (Exception ex) {
            ThingStatusInfo statusInfo = this.buildStatusInfo(ThingStatus.UNINITIALIZED, ThingStatusDetail.HANDLER_REGISTERING_ERROR, ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage());
            this.setThingStatus(thing, statusInfo);
            this.logger.error("Exception occured while calling thing handler factory '" + thingHandlerFactory + "': " + ex.getMessage(), (Throwable)ex);
        }
    }

    private void initializeHandler(Thing thing) {
        ThingType thingType = this.thingTypeRegistry.getThingType(thing.getThingTypeUID());
        if (thingType != null) {
            ThingFactoryHelper.applyDefaultConfiguration(thing.getConfiguration(), thingType, this.configDescriptionRegistry);
        }
        if (this.isInitializable(thing, thingType)) {
            ThingStatusInfo statusInfo = this.buildStatusInfo(ThingStatus.INITIALIZING, ThingStatusDetail.NONE);
            this.setThingStatus(thing, statusInfo);
            this.initializeHandler(thing.getHandler());
        } else {
            this.logger.debug("Thing '{}' not initializable, check required configuration parameters.", (Object)thing.getUID());
            ThingStatusInfo statusInfo = this.buildStatusInfo(ThingStatus.UNINITIALIZED, ThingStatusDetail.HANDLER_CONFIGURATION_PENDING);
            this.setThingStatus(thing, statusInfo);
        }
    }

    private boolean isInitializable(Thing thing, ThingType thingType) {
        if (thingType == null) {
            return true;
        }
        ConfigDescription description = this.resolve(thingType.getConfigDescriptionURI(), null);
        if (description == null) {
            return true;
        }
        List<String> requiredParameters = this.getRequiredParameters(description);
        Map properties = thing.getConfiguration().getProperties();
        return properties.keySet().containsAll(requiredParameters);
    }

    private ConfigDescription resolve(URI configDescriptionURI, Locale locale) {
        if (configDescriptionURI == null) {
            return null;
        }
        return this.configDescriptionRegistry != null ? this.configDescriptionRegistry.getConfigDescription(configDescriptionURI, locale) : null;
    }

    private List<String> getRequiredParameters(ConfigDescription description) {
        ArrayList<String> requiredParameters = new ArrayList<String>();
        for (ConfigDescriptionParameter param : description.getParameters()) {
            if (!param.isRequired()) continue;
            requiredParameters.add(param.getName());
        }
        return requiredParameters;
    }

    private void initializeHandler(final ThingHandler thingHandler) {
        Bundle bundle = null;
        for (BundleProcessor proc : this.bundleProcessors) {
            bundle = proc.isFinishedLoading(thingHandler);
            if (bundle == null) continue;
            this.logger.trace("Marking '{}' vetoed by '{}'", (Object)bundle.getSymbolicName(), (Object)proc);
            this.initializerVetoes.put((Object)bundle, (Object)proc);
            if (this.initializerQueue.containsEntry((Object)bundle, (Object)thingHandler)) continue;
            this.logger.trace("Queueing '{}' in bundle '{}'", (Object)thingHandler, (Object)bundle.getSymbolicName());
            this.initializerQueue.put((Object)bundle.getSymbolicName(), (Object)thingHandler);
        }
        if (bundle != null) {
            this.logger.debug("Meta-data of bundle '{}' is not fully loaded ({}), deferring handler initialization for thing '{}'", new Object[]{bundle.getSymbolicName(), this.initializerVetoes.get((Object)bundle), thingHandler.getThing().getUID()});
            return;
        }
        this.logger.debug("All data has been loaded, going to initialize '{}'.", (Object)thingHandler.getThing().getUID());
        this.scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                ThingManager.this.logger.debug("Calling initialize handler for thing '{}' at '{}'.", (Object)thingHandler.getThing().getUID(), (Object)thingHandler);
                try {
                    SafeMethodCaller.call((SafeMethodCaller.ActionWithException)new SafeMethodCaller.ActionWithException<Void>(){

                        public Void call() throws Exception {
                            thingHandler.initialize();
                            return null;
                        }
                    });
                }
                catch (TimeoutException timeoutException) {
                    ThingManager.this.logger.warn("Initializing handler for thing '{}' takes more than {}ms.", (Object)thingHandler.getThing().getUID(), (Object)SafeMethodCaller.DEFAULT_TIMEOUT);
                }
                catch (Exception ex) {
                    ThingStatusInfo statusInfo = ThingManager.this.buildStatusInfo(ThingStatus.UNINITIALIZED, ThingStatusDetail.HANDLER_INITIALIZING_ERROR, ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage());
                    ThingManager.this.setThingStatus(thingHandler.getThing(), statusInfo);
                    ThingManager.this.logger.error("Exception occured while initializing handler of thing '" + thingHandler.getThing().getUID() + "': " + ex.getMessage(), (Throwable)ex);
                }
            }
        }, 0L, TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bundleFinished(BundleProcessor context, Bundle bundle) {
        this.logger.debug("'{}' finished loading meta-data of bundle '{}'", (Object)context, (Object)bundle.getSymbolicName());
        this.initializerVetoes.remove((Object)bundle, (Object)context);
        this.logger.trace("'{}' still vetoed by '{}'", (Object)bundle.getSymbolicName(), (Object)this.initializerVetoes.get((Object)bundle));
        this.logger.trace("'{}' queued '{}'", (Object)bundle.getSymbolicName(), (Object)this.initializerQueue.get((Object)bundle.getSymbolicName()));
        if (this.initializerVetoes.get((Object)bundle).isEmpty()) {
            Multimap<String, ThingHandler> multimap = this.initializerQueue;
            synchronized (multimap) {
                for (ThingHandler thingHandler : this.initializerQueue.removeAll((Object)bundle.getSymbolicName())) {
                    this.logger.trace("Going to initialize '{}'", (Object)thingHandler.getThing().getUID());
                    this.initializeHandler(thingHandler);
                }
            }
        }
    }

    private boolean isInitialized(Thing thing) {
        return thing.getStatus() == ThingStatus.ONLINE || thing.getStatus() == ThingStatus.OFFLINE;
    }

    private void notifyThingsAboutBridgeInitialization(Bridge bridge) {
        for (Thing child : bridge.getThings()) {
            this.notifyThingAboutBridgeInitialization(bridge, child);
        }
    }

    private void notifyThingAboutBridgeInitialization(Thing thing) {
        Thing bridge;
        if (thing.getBridgeUID() != null && (bridge = this.thingRegistry.get(thing.getBridgeUID())) instanceof Bridge) {
            this.notifyThingAboutBridgeInitialization((Bridge)bridge, thing);
        }
    }

    private void notifyThingAboutBridgeInitialization(final Bridge bridge, final Thing childThing) {
        if (childThing.getHandler() == null) {
            return;
        }
        ThreadPoolManager.getPool((String)THING_MANAGER_THREADPOOL_NAME).execute(new Runnable(){

            @Override
            public void run() {
                try {
                    childThing.getHandler().bridgeHandlerInitialized(bridge.getHandler(), bridge);
                }
                catch (Exception ex) {
                    ThingManager.this.logger.error("Exception occured during notification of thing '" + childThing.getUID() + "' about bridge initialization at '" + childThing.getHandler() + "': " + ex.getMessage(), (Throwable)ex);
                }
            }
        });
    }

    private void unregisterHandler(final Thing thing, final ThingHandlerFactory thingHandlerFactory) {
        this.logger.debug("Calling unregisterHandler handler for thing '{}' at '{}'.", (Object)thing.getUID(), (Object)thingHandlerFactory);
        try {
            SafeMethodCaller.call((SafeMethodCaller.ActionWithException)new SafeMethodCaller.ActionWithException<Void>(){

                public Void call() throws Exception {
                    thingHandlerFactory.unregisterHandler(thing);
                    return null;
                }
            });
        }
        catch (Exception ex) {
            this.logger.error("Exception occured while calling thing handler factory '" + thingHandlerFactory + "': " + ex.getMessage(), (Throwable)ex);
        }
    }

    private void disposeHandler(Thing thing, final ThingHandler thingHandler) {
        this.logger.debug("Calling dispose handler for thing '{}' at '{}'.", (Object)thing.getUID(), (Object)thingHandler);
        try {
            SafeMethodCaller.call((SafeMethodCaller.ActionWithException)new SafeMethodCaller.ActionWithException<Void>(){

                public Void call() throws Exception {
                    thingHandler.dispose();
                    return null;
                }
            });
        }
        catch (TimeoutException timeoutException) {
            this.logger.warn("Disposing handler for thing '{}' takes more than {}ms.", (Object)thing.getUID(), (Object)SafeMethodCaller.DEFAULT_TIMEOUT);
        }
        catch (Exception ex) {
            this.logger.error("Exception occured while disposing handler of thing '" + thing.getUID() + "': " + ex.getMessage(), (Throwable)ex);
        }
    }

    private void notifyThingsAboutBridgeDisposal(Bridge bridge) {
        for (Thing childThing : bridge.getThings()) {
            this.notifyThingAboutBridgeDisposal(bridge, childThing);
        }
    }

    private void notifyThingAboutBridgeDisposal(final Bridge bridge, final Thing childThing) {
        if (childThing.getHandler() == null) {
            return;
        }
        ThreadPoolManager.getPool((String)THING_MANAGER_THREADPOOL_NAME).execute(new Runnable(){

            @Override
            public void run() {
                try {
                    childThing.getHandler().bridgeHandlerDisposed(bridge.getHandler(), bridge);
                }
                catch (Exception ex) {
                    ThingManager.this.logger.error("Exception occured during notification of thing '" + childThing.getUID() + "' about bridge disposal at '" + childThing.getHandler() + "': " + ex.getMessage(), (Throwable)ex);
                }
            }
        });
    }

    private void updateThingStatus(final ThingStatusInfo thingStatus, Bridge bridge) {
        for (final Thing bridgeChildThing : bridge.getThings()) {
            final ThingStatusInfo bridgeChildThingStatus = bridgeChildThing.getStatusInfo();
            if (bridgeChildThingStatus.getStatus() != ThingStatus.ONLINE && bridgeChildThingStatus.getStatus() != ThingStatus.OFFLINE) continue;
            ThreadPoolManager.getPool((String)THING_MANAGER_THREADPOOL_NAME).execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (thingStatus.getStatus() == ThingStatus.ONLINE && bridgeChildThingStatus.getStatusDetail() == ThingStatusDetail.BRIDGE_OFFLINE) {
                            ThingStatusInfo statusInfo = ThingStatusInfoBuilder.create(ThingStatus.OFFLINE, ThingStatusDetail.NONE).build();
                            ThingManager.this.setThingStatus(bridgeChildThing, statusInfo);
                        } else if (thingStatus.getStatus() == ThingStatus.OFFLINE) {
                            ThingStatusInfo statusInfo = ThingStatusInfoBuilder.create(ThingStatus.OFFLINE, ThingStatusDetail.BRIDGE_OFFLINE).build();
                            ThingManager.this.setThingStatus(bridgeChildThing, statusInfo);
                        }
                    }
                    catch (Exception ex) {
                        ThingManager.this.logger.error("Exception occured during status update of thing '" + bridgeChildThing.getUID() + "': " + ex.getMessage(), (Throwable)ex);
                    }
                }
            });
        }
    }

    private void notifyThingsAboutBridgeStatusChange(final ThingStatusInfo bridgeStatus, Bridge bridge) {
        if (bridgeStatus.getStatus() == ThingStatus.ONLINE || bridgeStatus.getStatus() == ThingStatus.OFFLINE) {
            for (final Thing bridgeChildThing : bridge.getThings()) {
                ThreadPoolManager.getPool((String)THING_MANAGER_THREADPOOL_NAME).execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ThingHandler handler = bridgeChildThing.getHandler();
                            if (handler != null) {
                                handler.bridgeStatusChanged(bridgeStatus);
                            }
                        }
                        catch (Exception ex) {
                            ThingManager.this.logger.error("Exception occured during notification about bridge status change on thing '" + bridgeChildThing.getUID() + "': " + ex.getMessage(), (Throwable)ex);
                        }
                    }
                });
            }
        }
    }

    private void notifyThingAboutRemoval(final Thing thing) {
        this.logger.trace("Asking handler of thing '{}' to handle its removal.", (Object)thing.getUID());
        ThreadPoolManager.getPool((String)THING_MANAGER_THREADPOOL_NAME).execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ThingHandler handler = thing.getHandler();
                    if (handler != null) {
                        handler.handleRemoval();
                        ThingManager.this.logger.trace("Handler of thing '{}' returned from handling its removal.", (Object)thing.getUID());
                    } else {
                        ThingManager.this.logger.trace("No handler of thing '{}' available, so deferring the removal call.", (Object)thing.getUID());
                    }
                }
                catch (Exception ex) {
                    ThingManager.this.logger.error("The ThingHandler caused an exception while handling the removal of its thing", (Throwable)ex);
                }
            }
        });
    }

    private void notifyRegistryAboutForceRemove(final Thing thing) {
        this.logger.debug("Removal handling of thing '{}' completed. Going to remove it now.", (Object)thing.getUID());
        ThreadPoolManager.getPool((String)FORCEREMOVE_THREADPOOL_NAME).execute(new Runnable(){

            @Override
            public void run() {
                try {
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            ThingManager.this.thingRegistry.forceRemove(thing.getUID());
                            return null;
                        }
                    });
                }
                catch (IllegalStateException ex) {
                    ThingManager.this.logger.debug("Could not remove thing {}. Most likely because it is not managed.", (Object)thing.getUID(), (Object)ex);
                }
                catch (Exception ex) {
                    ThingManager.this.logger.error("Could not remove thing {}, because an unknwon Exception occured. Most likely because it is not managed.", (Object)thing.getUID(), (Object)ex);
                }
            }
        });
    }

    protected void activate(ComponentContext componentContext) {
        this.thingRegistry.addThingTracker(this);
        this.bundleContext = componentContext.getBundleContext();
        this.thingHandlerTracker = new ThingHandlerTracker(this.bundleContext);
        this.thingHandlerTracker.open();
    }

    protected void addThingHandlerFactory(ThingHandlerFactory thingHandlerFactory) {
        this.logger.debug("Thing handler factory '{}' added", (Object)thingHandlerFactory.getClass().getSimpleName());
        this.thingHandlerFactories.add(thingHandlerFactory);
        for (Thing thing : this.things) {
            if (!thingHandlerFactory.supportsThingType(thing.getThingTypeUID())) continue;
            ThingUID thingId = thing.getUID();
            ThingHandler thingHandler = this.thingHandlers.get(thingId);
            if (thingHandler == null) {
                this.registerHandler(thing, thingHandlerFactory);
                continue;
            }
            this.logger.warn("Thing handler for thing '{}' already exists.", (Object)thingId);
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        this.thingRegistry.removeThingTracker(this);
        this.thingHandlerTracker.close();
    }

    protected void removeThingHandlerFactory(ThingHandlerFactory thingHandlerFactory) {
        this.logger.debug("Thing handler factory '{}' removed", (Object)thingHandlerFactory.getClass().getSimpleName());
        this.thingHandlerFactories.remove(thingHandlerFactory);
    }

    protected void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    protected void setItemChannelLinkRegistry(ItemChannelLinkRegistry itemChannelLinkRegistry) {
        this.itemChannelLinkRegistry = itemChannelLinkRegistry;
    }

    protected void setThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = (ThingRegistryImpl)thingRegistry;
    }

    protected void unsetEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = null;
    }

    protected void unsetItemChannelLinkRegistry(ItemChannelLinkRegistry itemChannelLinkRegistry) {
        this.itemChannelLinkRegistry = null;
    }

    protected void unsetThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = null;
    }

    protected void setManagedThingProvider(ManagedThingProvider managedThingProvider) {
        this.managedThingProvider = managedThingProvider;
    }

    protected void unsetManagedThingProvider(ManagedThingProvider managedThingProvider) {
        this.managedThingProvider = null;
    }

    protected void setConfigDescriptionRegistry(ConfigDescriptionRegistry configDescriptionRegistry) {
        this.configDescriptionRegistry = configDescriptionRegistry;
    }

    protected void unsetConfigDescriptionRegistry(ConfigDescriptionRegistry configDescriptionRegistry) {
        this.configDescriptionRegistry = null;
    }

    private ThingStatusInfo buildStatusInfo(ThingStatus thingStatus, ThingStatusDetail thingStatusDetail, String description) {
        ThingStatusInfoBuilder statusInfoBuilder = ThingStatusInfoBuilder.create(thingStatus, thingStatusDetail);
        statusInfoBuilder.withDescription(description);
        return statusInfoBuilder.build();
    }

    private ThingStatusInfo buildStatusInfo(ThingStatus thingStatus, ThingStatusDetail thingStatusDetail) {
        return this.buildStatusInfo(thingStatus, thingStatusDetail, null);
    }

    private void setThingStatus(Thing thing, ThingStatusInfo thingStatusInfo) {
        ThingStatusInfo oldStatusInfo = thing.getStatusInfo();
        thing.setStatusInfo(thingStatusInfo);
        try {
            this.eventPublisher.post((Event)ThingEventFactory.createStatusInfoEvent(thing.getUID(), thingStatusInfo));
            if (!oldStatusInfo.equals(thingStatusInfo)) {
                this.eventPublisher.post((Event)ThingEventFactory.createStatusInfoChangedEvent(thing.getUID(), thingStatusInfo, oldStatusInfo));
            }
        }
        catch (Exception ex) {
            this.logger.error("Could not post 'ThingStatusInfoEvent' event: " + ex.getMessage(), (Throwable)ex);
        }
    }

    protected void setThingTypeRegistry(ThingTypeRegistry thingTypeRegistry) {
        this.thingTypeRegistry = thingTypeRegistry;
    }

    protected void unsetThingTypeRegistry(ThingTypeRegistry thingTypeRegistry) {
        this.thingTypeRegistry = null;
    }

    protected void setBundleProcessor(BundleProcessor bundleProcessor) {
        this.bundleProcessors.add(bundleProcessor);
        bundleProcessor.registerListener(this);
    }

    protected void unsetBundleProcessor(BundleProcessor bundleProcessor) {
        bundleProcessor.unregisterListener(this);
        this.bundleProcessors.remove(bundleProcessor);
    }

    private final class ThingHandlerTracker
    extends ServiceTracker<ThingHandler, ThingHandler> {
        public ThingHandlerTracker(BundleContext context) {
            super(context, ThingHandler.class.getName(), null);
        }

        public ThingHandler addingService(ServiceReference<ThingHandler> reference) {
            ThingUID thingId = this.getThingUID(reference);
            ThingManager.this.logger.debug("Thing handler for thing '{}' added.", (Object)thingId);
            ThingHandler thingHandler = (ThingHandler)ThingManager.this.bundleContext.getService(reference);
            Thing thing = ThingManager.this.getThing(thingId);
            if (thing != null) {
                ThingManager.this.handlerAdded(thing, thingHandler);
            } else {
                ThingManager.this.logger.warn("Found handler for non-existing thing '{}'.", (Object)thingId);
            }
            ThingManager.this.thingHandlers.put(thingId, thingHandler);
            return thingHandler;
        }

        public void removedService(ServiceReference<ThingHandler> reference, ThingHandler service) {
            ThingUID thingUID = this.getThingUID(reference);
            ThingManager.this.logger.debug("Thing handler for thing '{}' removed.", (Object)thingUID);
            Thing thing = ThingManager.this.getThing(thingUID);
            if (thing != null) {
                ThingManager.this.handlerRemoved(thing, service);
            }
            ThingManager.this.thingHandlers.remove(thingUID);
        }

        private ThingUID getThingUID(ServiceReference<ThingHandler> reference) {
            return (ThingUID)reference.getProperty("thing.id");
        }
    }
}

