/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.internal.console;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.firmware.Firmware;
import org.eclipse.smarthome.core.thing.binding.firmware.FirmwareUID;
import org.eclipse.smarthome.core.thing.firmware.FirmwareRegistry;
import org.eclipse.smarthome.core.thing.firmware.FirmwareStatusInfo;
import org.eclipse.smarthome.core.thing.firmware.FirmwareUpdateService;
import org.eclipse.smarthome.io.console.Console;
import org.eclipse.smarthome.io.console.extensions.AbstractConsoleCommandExtension;

public final class FirmwareUpdateConsoleCommandExtension
extends AbstractConsoleCommandExtension {
    private static final String SUBCMD_LIST = "list";
    private static final String SUBCMD_STATUS = "status";
    private static final String SUBCMD_UPDATE = "update";
    private FirmwareUpdateService firmwareUpdateService;
    private FirmwareRegistry firmwareRegistry;
    private ThingRegistry thingRegistry;

    public FirmwareUpdateConsoleCommandExtension() {
        super("firmware", "Manage your things' firmwares.");
    }

    public void execute(String[] args, Console console) {
        String subCommand;
        int numberOfArguments = args.length;
        if (numberOfArguments < 1) {
            console.println("No firmare subcommand given.");
            this.printUsage(console);
            return;
        }
        switch (subCommand = args[0]) {
            case "list": {
                this.listFirmwares(console, args);
                break;
            }
            case "status": {
                this.listFirmwareStatus(console, args);
                break;
            }
            case "update": {
                this.updateFirmware(console, args);
                break;
            }
            default: {
                console.println(String.format("Unkown firmware sub command '%s'.", subCommand));
                this.printUsage(console);
            }
        }
    }

    private void listFirmwares(Console console, String[] args) {
        if (args.length != 2) {
            console.println("Specify the thing type id to get its available firmwares: firmware list <thingTypeUID>");
            return;
        }
        ThingTypeUID thingTypeUID = new ThingTypeUID(args[1]);
        Collection<Firmware> firmwares = this.firmwareRegistry.getFirmwares(thingTypeUID);
        if (firmwares.isEmpty()) {
            console.println("No firmwares found.");
        }
        for (Firmware firmware : firmwares) {
            console.println(firmware.toString());
        }
    }

    private void listFirmwareStatus(Console console, String[] args) {
        if (args.length != 2) {
            console.println("Specify the thing id to get its firmware status: firmware status <thingUID>");
            return;
        }
        ThingUID thingUID = new ThingUID(args[1]);
        FirmwareStatusInfo firmwareStatusInfo = this.firmwareUpdateService.getFirmwareStatusInfo(thingUID);
        if (firmwareStatusInfo != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(String.format("Firmware status for thing with UID %s is %s.", new Object[]{thingUID, firmwareStatusInfo.getFirmwareStatus()}));
            if (firmwareStatusInfo.getUpdatableFirmwareUID() != null) {
                sb.append(String.format(" The latest updatable firmware version is %s.", firmwareStatusInfo.getUpdatableFirmwareUID().getFirmwareVersion()));
            }
            console.println(sb.toString());
        }
    }

    private void updateFirmware(Console console, String[] args) {
        if (args.length != 3) {
            console.println("Specify the thing id and the firmware version to update the firmware: firmware update <thingUID> <firmware version>");
            return;
        }
        ThingUID thingUID = new ThingUID(args[1]);
        Thing thing = this.thingRegistry.get(thingUID);
        FirmwareUID firmwareUID = new FirmwareUID(thing.getThingTypeUID(), args[2]);
        this.firmwareUpdateService.updateFirmware(thingUID, firmwareUID, null);
        console.println("Firmware update started.");
    }

    public List<String> getUsages() {
        return Arrays.asList(this.buildCommandUsage("list <thingTypeUID>", "lists the available firmwares for a thing type"), this.buildCommandUsage("status <thingUID>", "lists the firmware status for a thing"), this.buildCommandUsage("update <thingUID> <firmware version>", "updates the firmware for a thing"));
    }

    protected void setFirmwareUpdateService(FirmwareUpdateService firmwareUpdateService) {
        this.firmwareUpdateService = firmwareUpdateService;
    }

    protected void unsetFirmwareUpdateService(FirmwareUpdateService firmwareUpdateService) {
        this.firmwareUpdateService = null;
    }

    protected void setFirmwareRegistry(FirmwareRegistry firmwareRegistry) {
        this.firmwareRegistry = firmwareRegistry;
    }

    protected void unsetFirmwareRegistry(FirmwareRegistry firmwareRegistry) {
        this.firmwareRegistry = null;
    }

    protected void setThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = thingRegistry;
    }

    protected void unsetThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = null;
    }
}

