/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.internal.console;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.ManagedThingProvider;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.core.thing.ThingStatusInfo;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.io.console.Console;
import org.eclipse.smarthome.io.console.extensions.AbstractConsoleCommandExtension;

public class ThingConsoleCommandExtension
extends AbstractConsoleCommandExtension {
    private static final String SUBCMD_LIST = "list";
    private static final String SUBCMD_CLEAR = "clear";
    private static final String SUBCMD_REMOVE = "remove";
    private ManagedThingProvider managedThingProvider;
    private ThingRegistry thingRegistry;

    public ThingConsoleCommandExtension() {
        super("things", "Access your thing registry.");
    }

    public void execute(String[] args, Console console) {
        block17: {
            Collection things;
            block15: {
                String subCommand;
                things = this.thingRegistry.getAll();
                if (args.length <= 0) break block15;
                switch (subCommand = args[0]) {
                    case "list": {
                        this.printThings(console, things);
                        return;
                    }
                    case "clear": {
                        this.removeAllThings(console, things);
                        return;
                    }
                    case "remove": {
                        if (args.length > 1) {
                            ThingUID thingUID = new ThingUID(args[1]);
                            this.removeThing(console, things, thingUID);
                        } else {
                            console.println("Specify thing id to remove: things remove <thingUID> (e.g. \"hue:light:1\")");
                        }
                        return;
                    }
                }
                break block17;
            }
            this.printThings(console, things);
        }
    }

    private void removeThing(Console console, Collection<Thing> things, ThingUID thingUID) {
        Thing removedThing = (Thing)this.managedThingProvider.remove(thingUID);
        if (removedThing != null) {
            console.println("Thing '" + thingUID + "' successfully removed.");
        } else {
            console.println("Could not delete thing " + thingUID + ".");
        }
    }

    private void removeAllThings(Console console, Collection<Thing> things) {
        int numberOfThings = things.size();
        for (Thing thing : things) {
            this.managedThingProvider.remove(thing.getUID());
        }
        console.println(String.valueOf(numberOfThings) + " things successfully removed.");
    }

    public List<String> getUsages() {
        return Arrays.asList(this.buildCommandUsage(SUBCMD_LIST, "lists all things"), this.buildCommandUsage(SUBCMD_CLEAR, "removes all managed things"), this.buildCommandUsage("remove <thingUID>", "removes a thing"));
    }

    private void printThings(Console console, Collection<Thing> things) {
        if (things.isEmpty()) {
            console.println("No things found.");
        }
        for (Thing thing : things) {
            String id = thing.getUID().toString();
            String thingType = thing instanceof Bridge ? "Bridge" : "Thing";
            ThingStatusInfo status = thing.getStatusInfo();
            ThingUID bridgeUID = thing.getBridgeUID();
            String label = thing.getLabel();
            console.println(String.format("%s (Type=%s, Status=%s, Label=%s, Bridge=%s)", id, thingType, status, label, bridgeUID));
        }
    }

    protected void setManagedThingProvider(ManagedThingProvider managedThingProvider) {
        this.managedThingProvider = managedThingProvider;
    }

    protected void setThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = thingRegistry;
    }

    protected void unsetManagedThingProvider(ManagedThingProvider managedThingProvider) {
        this.managedThingProvider = null;
    }

    protected void unsetThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = null;
    }
}

