/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.link;

import org.eclipse.smarthome.core.items.ItemUtil;
import org.eclipse.smarthome.core.thing.UID;

public abstract class AbstractLink {
    private final String itemName;

    public static String getIDFor(String itemName, UID uid) {
        return String.valueOf(itemName) + " -> " + uid.toString();
    }

    public AbstractLink(String itemName) {
        ItemUtil.assertValidItemName((String)itemName);
        this.itemName = itemName;
    }

    AbstractLink() {
        this.itemName = null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractLink) {
            AbstractLink link = (AbstractLink)obj;
            return this.getID().equals(link.getID());
        }
        return false;
    }

    public String getID() {
        return AbstractLink.getIDFor(this.getItemName(), this.getUID());
    }

    public String getItemName() {
        return this.itemName;
    }

    public abstract UID getUID();

    public int hashCode() {
        return this.itemName.hashCode() * this.getUID().hashCode();
    }

    public String toString() {
        return this.getID();
    }
}

