/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.setup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.common.registry.Provider;
import org.eclipse.smarthome.core.common.registry.ProviderChangeListener;
import org.eclipse.smarthome.core.items.ActiveItem;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemFactory;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.ManagedThingProvider;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.UID;
import org.eclipse.smarthome.core.thing.binding.ThingFactory;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerFactory;
import org.eclipse.smarthome.core.thing.link.ItemChannelLink;
import org.eclipse.smarthome.core.thing.link.ItemChannelLinkRegistry;
import org.eclipse.smarthome.core.thing.type.ChannelGroupDefinition;
import org.eclipse.smarthome.core.thing.type.ChannelGroupType;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.type.ChannelTypeRegistry;
import org.eclipse.smarthome.core.thing.type.ThingType;
import org.eclipse.smarthome.core.thing.type.ThingTypeRegistry;
import org.eclipse.smarthome.core.thing.type.TypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ThingSetupManager
implements ProviderChangeListener<Thing> {
    public static final String TAG_CHANNEL_GROUP = "channel-group";
    public static final String TAG_HOME_GROUP = "home-group";
    public static final String TAG_THING = "thing";
    private ChannelTypeRegistry channelTypeRegistry;
    private ItemChannelLinkRegistry itemChannelLinkRegistry;
    private List<ItemFactory> itemFactories = new CopyOnWriteArrayList<ItemFactory>();
    private ItemRegistry itemRegistry;
    private final Logger logger = LoggerFactory.getLogger(ThingSetupManager.class);
    private List<ThingHandlerFactory> thingHandlerFactories = new CopyOnWriteArrayList<ThingHandlerFactory>();
    private ThingRegistry thingRegistry;
    private ThingTypeRegistry thingTypeRegistry;

    public GroupItem addHomeGroup(String itemName, String label) {
        GroupItem groupItem = new GroupItem(itemName);
        groupItem.setLabel(label);
        groupItem.addTag(TAG_HOME_GROUP);
        this.addItemSafely((Item)groupItem);
        return groupItem;
    }

    @Deprecated
    public Thing addThing(ThingUID thingUID, Configuration configuration, ThingUID bridgeUID) {
        return this.addThing(thingUID, configuration, bridgeUID, null);
    }

    @Deprecated
    public Thing addThing(ThingUID thingUID, Configuration configuration, ThingUID bridgeUID, String label) {
        return this.addThing(thingUID, configuration, bridgeUID, label, new ArrayList<String>());
    }

    @Deprecated
    public Thing addThing(ThingUID thingUID, Configuration configuration, ThingUID bridgeUID, String label, List<String> groupNames) {
        return this.addThing(thingUID, configuration, bridgeUID, label, groupNames, true);
    }

    @Deprecated
    public Thing addThing(ThingUID thingUID, Configuration configuration, ThingUID bridgeUID, String label, List<String> groupNames, boolean enableChannels) {
        return this.addThing(thingUID, configuration, bridgeUID, label, groupNames, enableChannels, null);
    }

    @Deprecated
    public Thing addThing(ThingUID thingUID, Configuration configuration, ThingUID bridgeUID, String label, List<String> groupNames, boolean enableChannels, Locale locale) {
        if (thingUID == null) {
            throw new IllegalArgumentException("Thing UID must not be null");
        }
        ThingTypeUID thingTypeUID = thingUID.getThingTypeUID();
        return this.addThing(thingTypeUID, thingUID, configuration, bridgeUID, label, groupNames, enableChannels, null, locale);
    }

    @Deprecated
    public Thing addThing(ThingTypeUID thingTypeUID, Configuration configuration, ThingUID bridgeUID, String label, List<String> groupNames, boolean enableChannels) {
        return this.addThing(thingTypeUID, null, configuration, bridgeUID, label, groupNames, enableChannels);
    }

    @Deprecated
    public void addToHomeGroup(String itemName, String groupItemName) {
        ActiveItem item = (ActiveItem)this.itemRegistry.get((Object)itemName);
        if (item != null) {
            item.addGroupName(groupItemName);
            this.itemRegistry.update((Object)item);
        } else {
            this.logger.warn("Could not add item '{}' to group '{}', because thing is not linked.", (Object)itemName, (Object)groupItemName);
        }
    }

    public void addToHomeGroup(ThingUID thingUID, String groupItemName) {
        String linkedItem = this.getFirstLinkedItem(thingUID);
        if (linkedItem != null) {
            this.addToHomeGroup(linkedItem, groupItemName);
        } else {
            this.logger.warn("Could not add thing '{}' to group '{}', because thing is not linked.", (Object)thingUID, (Object)groupItemName);
        }
    }

    public void disableChannel(ChannelUID channelUID) {
        Collection itemChannelLinks = this.itemChannelLinkRegistry.getAll();
        for (ItemChannelLink itemChannelLink : itemChannelLinks) {
            if (!itemChannelLink.getUID().equals(channelUID)) continue;
            String itemName = itemChannelLink.getItemName();
            this.itemRegistry.remove((Object)itemName);
            this.itemChannelLinkRegistry.remove(itemChannelLink.getID());
        }
    }

    public void enableChannel(ChannelUID channelUID, Locale locale) {
        Thing thing = this.getThing(channelUID.getThingUID());
        if (thing == null) {
            this.logger.warn("Could not enable channel '{}', because no thing was found.", (Object)channelUID);
            return;
        }
        Channel channel = thing.getChannel(channelUID.getId());
        if (channel == null) {
            this.logger.warn("Could not enable channel '{}', because no channel was found.", (Object)channelUID);
            return;
        }
        ChannelType channelType = this.thingTypeRegistry.getChannelType(channel, locale);
        if (channelType != null) {
            String itemName;
            GenericItem item;
            String itemType = channelType.getItemType();
            ItemFactory itemFactory = this.getItemFactoryForItemType(itemType);
            if (itemFactory != null && (item = itemFactory.createItem(itemType, itemName = this.toItemName(channelUID))) != null) {
                item.addTags(channelType.getTags());
                item.setCategory(channelType.getCategory());
                if (channel.getLabel() != null) {
                    item.setLabel(channel.getLabel());
                } else {
                    item.setLabel(channelType.getLabel());
                }
                this.addItemSafely((Item)item);
            }
        } else {
            this.logger.warn("Could not enable channel '{}', because no channel type was found.", (Object)channelUID);
        }
    }

    public Collection<GroupItem> getHomeGroups() {
        ArrayList<GroupItem> homeGroupItems = new ArrayList<GroupItem>();
        for (Item item : this.itemRegistry.getAll()) {
            if (!(item instanceof GroupItem) || !((GroupItem)item).hasTag(TAG_HOME_GROUP)) continue;
            homeGroupItems.add((GroupItem)item);
        }
        return homeGroupItems;
    }

    public Thing getThing(ThingUID thingUID) {
        return this.thingRegistry.get(thingUID);
    }

    public Collection<Thing> getThings() {
        return this.thingRegistry.getAll();
    }

    public void removeFromHomeGroup(String itemName, String groupItemName) {
        ActiveItem item = (ActiveItem)this.itemRegistry.get((Object)itemName);
        item.removeGroupName(groupItemName);
        this.itemRegistry.update((Object)item);
    }

    public void removeFromHomeGroup(ThingUID thingUID, String groupItemName) {
        String linkedItem = this.getFirstLinkedItem(thingUID);
        if (linkedItem != null) {
            this.removeFromHomeGroup(linkedItem, groupItemName);
        }
    }

    public void removeHomeGroup(String itemName) {
        this.itemRegistry.remove((Object)itemName);
    }

    public void removeThing(ThingUID thingUID) {
        this.removeThing(thingUID, false);
    }

    public void removeThing(ThingUID thingUID, boolean force) {
        Thing thing = this.thingRegistry.get(thingUID);
        if (thing == null) {
            return;
        }
        if (thing instanceof Bridge) {
            Bridge bridge = (Bridge)thing;
            for (Thing bridgeThing : bridge.getThings()) {
                ThingUID bridgeThingUID = bridgeThing.getUID();
                this.removeThing(bridgeThingUID, force);
            }
        }
        if (force) {
            this.thingRegistry.forceRemove(thingUID);
        } else {
            this.thingRegistry.remove(thingUID);
        }
    }

    public void setLabel(ThingUID thingUID, String label) {
        Thing thing = this.thingRegistry.get(thingUID);
        if (label != null && !label.equals(thing.getLabel())) {
            thing.setLabel(label);
            this.thingRegistry.update(thing);
        }
    }

    public void setHomeGroupLabel(String itemName, String label) {
        GroupItem groupItem = (GroupItem)this.itemRegistry.get((Object)itemName);
        if (groupItem == null) {
            throw new IllegalArgumentException("No group item found with item name " + itemName);
        }
        groupItem.setLabel(label);
        this.itemRegistry.update((Object)groupItem);
    }

    public void updateItem(Item item) {
        this.itemRegistry.update((Object)item);
    }

    public void updateThing(Thing thing) {
        this.thingRegistry.update(thing);
    }

    protected void addItemFactory(ItemFactory itemFactory) {
        this.itemFactories.add(itemFactory);
    }

    protected void removeItemFactory(ItemFactory itemFactory) {
        this.itemFactories.remove(itemFactory);
    }

    protected void addThingHandlerFactory(ThingHandlerFactory thingHandlerFactory) {
        this.thingHandlerFactories.add(thingHandlerFactory);
    }

    protected void removeThingHandlerFactory(ThingHandlerFactory thingHandlerFactory) {
        this.thingHandlerFactories.remove(thingHandlerFactory);
    }

    protected void setChannelTypeRegistry(ChannelTypeRegistry channelTypeRegistry) {
        this.channelTypeRegistry = channelTypeRegistry;
    }

    protected void setItemChannelLinkRegistry(ItemChannelLinkRegistry itemChannelLinkRegistry) {
        this.itemChannelLinkRegistry = itemChannelLinkRegistry;
    }

    protected void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    protected void setThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = thingRegistry;
    }

    protected void setThingTypeRegistry(ThingTypeRegistry thingTypeRegistry) {
        this.thingTypeRegistry = thingTypeRegistry;
    }

    protected void unsetChannelTypeRegistry(ChannelTypeRegistry channelTypeRegistry) {
        this.channelTypeRegistry = null;
    }

    protected void unsetItemChannelLinkRegistry(ItemChannelLinkRegistry itemChannelLinkRegistry) {
        this.itemChannelLinkRegistry = null;
    }

    protected void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = null;
    }

    protected void unsetThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = null;
    }

    protected void unsetThingTypeRegistry(ThingTypeRegistry thingTypeRegistry) {
        this.thingTypeRegistry = null;
    }

    private Thing addThing(ThingTypeUID thingTypeUID, ThingUID thingUID, Configuration configuration, ThingUID bridgeUID, String label, List<String> groupNames, boolean enableChannels) {
        return this.addThing(thingTypeUID, thingUID, configuration, bridgeUID, label, groupNames, enableChannels, null, null);
    }

    private Thing addThing(ThingTypeUID thingTypeUID, ThingUID thingUID, Configuration configuration, ThingUID bridgeUID, String label, List<String> groupNames, boolean enableChannels, Map<String, String> properties, Locale locale) {
        Thing thing = ThingFactory.createThing(thingUID, configuration, properties, bridgeUID, thingTypeUID, this.thingHandlerFactories);
        if (thing == null) {
            this.logger.warn("Cannot create thing. No binding found that supports creating a thing of type {}.", (Object)thingTypeUID);
            return null;
        }
        thing.setLabel(label);
        if (properties != null) {
            for (String key : properties.keySet()) {
                thing.setProperty(key, properties.get(key));
            }
        }
        this.addThingSafely(thing);
        this.createGroupItems(label, groupNames, thing, thingTypeUID, locale);
        if (enableChannels) {
            this.enableChannels(thing, thingTypeUID, locale);
        }
        return thing;
    }

    private void addThingSafely(Thing thing) {
        ThingUID thingUID = thing.getUID();
        if (this.thingRegistry.get(thingUID) != null) {
            this.thingRegistry.remove(thingUID);
        }
        this.thingRegistry.add(thing);
    }

    private void addItemSafely(Item item) {
        String itemName = item.getName();
        if (this.itemRegistry.get((Object)itemName) != null) {
            this.itemRegistry.remove((Object)itemName);
        }
        this.itemRegistry.add((Object)item);
    }

    private String getChannelGroupItemName(String itemName, String channelGroupId) {
        return String.valueOf(itemName) + "_" + this.toItemName(channelGroupId);
    }

    private ItemFactory getItemFactoryForItemType(String itemType) {
        for (ItemFactory itemFactory : this.itemFactories) {
            String[] supportedItemTypes = itemFactory.getSupportedItemTypes();
            int i = 0;
            while (i < supportedItemTypes.length) {
                String supportedItemType = supportedItemTypes[i];
                if (supportedItemType.equals(itemType)) {
                    return itemFactory;
                }
                ++i;
            }
        }
        return null;
    }

    private String toItemName(UID uid) {
        return this.toItemName(uid.getAsString());
    }

    private String toItemName(String uid) {
        String itemName = uid.replaceAll("[^a-zA-Z0-9_]", "_");
        return itemName;
    }

    private String getFirstLinkedItem(UID uid) {
        return null;
    }

    public void enableChannels(Thing thing, ThingTypeUID thingTypeUID, Locale locale) {
        ThingType thingType = this.thingTypeRegistry.getThingType(thingTypeUID);
        if (thingType != null) {
            List<Channel> channels = thing.getChannels();
            for (Channel channel : channels) {
                ChannelType channelType = TypeResolver.resolve(thingType.getChannelTypeUID(channel.getUID()));
                if (channelType != null && !channelType.isAdvanced()) {
                    this.enableChannel(channel.getUID(), locale);
                    continue;
                }
                if (channelType != null) continue;
                this.logger.warn("Could not enable channel '{}', because no channel type was found.", (Object)channel.getUID());
            }
        }
    }

    public void createGroupItems(String label, List<String> groupNames, Thing thing, ThingTypeUID typeUID, Locale locale) {
        ThingType thingType = this.thingTypeRegistry.getThingType(typeUID);
        String itemName = this.toItemName(thing.getUID());
        GroupItem groupItem = new GroupItem(itemName);
        groupItem.addTag(TAG_THING);
        groupItem.setLabel(label);
        groupItem.addGroupNames(groupNames);
        this.addItemSafely((Item)groupItem);
        if (thingType != null) {
            List<ChannelGroupDefinition> channelGroupDefinitions = thingType.getChannelGroupDefinitions();
            for (ChannelGroupDefinition channelGroupDefinition : channelGroupDefinitions) {
                ChannelGroupType channelGroupType = this.channelTypeRegistry.getChannelGroupType(channelGroupDefinition.getTypeUID(), locale);
                GroupItem channelGroupItem = new GroupItem(this.getChannelGroupItemName(itemName, channelGroupDefinition.getId()));
                channelGroupItem.addTag(TAG_CHANNEL_GROUP);
                channelGroupItem.addGroupName(itemName);
                channelGroupItem.setLabel(channelGroupType.getLabel());
                this.addItemSafely((Item)channelGroupItem);
            }
        }
    }

    protected void addManagedThingProvider(ManagedThingProvider managedThingProvider) {
        managedThingProvider.addProviderChangeListener(this);
    }

    protected void removeManagedThingProvider(ManagedThingProvider managedThingProvider) {
        managedThingProvider.removeProviderChangeListener(this);
    }

    public void added(Provider<Thing> provider, Thing thing) {
    }

    public void removed(Provider<Thing> provider, Thing thing) {
        ThingUID thingUID = thing.getUID();
        String itemName = this.toItemName(thingUID);
        if (this.itemRegistry.get((Object)itemName) != null) {
            try {
                this.itemRegistry.remove(itemName, true);
                this.itemChannelLinkRegistry.removeLinksForThing(thingUID);
            }
            catch (Exception ex) {
                this.logger.error("Coud not remove items and links for removed thing: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public void updated(Provider<Thing> provider, Thing oldThing, Thing thing) {
    }
}

