/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.type;

import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.smarthome.core.thing.type.AbstractDescriptionType;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;
import org.eclipse.smarthome.core.types.StateDescription;

public class ChannelType
extends AbstractDescriptionType {
    private final boolean advanced;
    private final String itemType;
    private final Set<String> tags;
    private final String category;
    private final StateDescription state;
    private final URI configDescriptionURI;

    public ChannelType(ChannelTypeUID uid, boolean advanced, String itemType, String label, String description, String category, Set<String> tags, StateDescription state, URI configDescriptionURI) throws IllegalArgumentException {
        super(uid, label, description);
        if (itemType == null || itemType.isEmpty()) {
            throw new IllegalArgumentException("The item type must neither be null nor empty!");
        }
        this.itemType = itemType;
        this.configDescriptionURI = configDescriptionURI;
        this.tags = tags != null ? Collections.unmodifiableSet(new HashSet<String>(tags)) : Collections.unmodifiableSet(new HashSet(0));
        this.advanced = advanced;
        this.category = category;
        this.state = state;
    }

    @Override
    public ChannelTypeUID getUID() {
        return (ChannelTypeUID)super.getUID();
    }

    public String getItemType() {
        return this.itemType;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public String toString() {
        return super.getUID().toString();
    }

    public boolean hasConfigDescriptionURI() {
        return this.configDescriptionURI != null;
    }

    public URI getConfigDescriptionURI() {
        return this.configDescriptionURI;
    }

    public StateDescription getState() {
        return this.state;
    }

    public boolean isAdvanced() {
        return this.advanced;
    }

    public String getCategory() {
        return this.category;
    }
}

