/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.common;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.smarthome.core.common.ThreadPoolManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SafeMethodCaller {
    public static int DEFAULT_TIMEOUT = 5000;

    public static <V> V call(ActionWithException<V> action) throws TimeoutException, ExecutionException {
        return SafeMethodCaller.call(action, DEFAULT_TIMEOUT);
    }

    public static <V> V call(ActionWithException<V> action, int timeout) throws TimeoutException, ExecutionException {
        try {
            return SafeMethodCaller.callAsynchronous(action, timeout);
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException("Thread was interrupted.", ex);
        }
    }

    public static <V> V call(Action<V> action) {
        return SafeMethodCaller.call(action, DEFAULT_TIMEOUT);
    }

    public static <V> V call(Action<V> action, int timeout) {
        try {
            return SafeMethodCaller.callAsynchronous(action, timeout);
        }
        catch (ExecutionException ex) {
            StackTraceElement stackTraceElement = SafeMethodCaller.findCalledMethod(ex, action.getClass());
            if (stackTraceElement != null) {
                String className = stackTraceElement.getClassName();
                String methodName = stackTraceElement.getMethodName();
                SafeMethodCaller.getLogger().error("Exception occured while calling '" + methodName + "' at '" + className + "'", (Throwable)ex);
            } else {
                SafeMethodCaller.getLogger().error("Exception occured while calling action", (Throwable)ex);
            }
            return null;
        }
        catch (TimeoutException ex) {
            SafeMethodCaller.getLogger().error("Timeout occured while calling method. Execution took longer than " + timeout + " milliseconds.", (Throwable)ex);
            return null;
        }
        catch (Throwable throwable) {
            SafeMethodCaller.getLogger().error("Unkown Exception or Error occured while calling action", throwable);
            return null;
        }
    }

    private static StackTraceElement findCalledMethod(ExecutionException eex, Class<?> actionClass) {
        if (eex.getCause() == null) {
            return null;
        }
        StackTraceElement[] stackTrace = eex.getCause().getStackTrace();
        if (stackTrace == null) {
            return null;
        }
        int i = 0;
        while (i < stackTrace.length) {
            StackTraceElement stackTraceElement = stackTrace[i];
            if (stackTraceElement.getClassName().equals(actionClass.getName())) {
                return stackTrace[i - 1];
            }
            ++i;
        }
        return null;
    }

    private static <V> V callAsynchronous(Callable<V> callable, int timeout) throws InterruptedException, ExecutionException, TimeoutException {
        CallableWrapper<V> wrapper = new CallableWrapper<V>(callable);
        try {
            Future<V> future = ThreadPoolManager.getPool("safeCall").submit(wrapper);
            return future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            if (wrapper.getThread() != null) {
                Thread thread = wrapper.getThread();
                StackTraceElement element = thread.getStackTrace()[0];
                SafeMethodCaller.getLogger().debug("Timeout of {}ms exceeded, thread {} ({}) in state {} is at {}.{}({}:{}).", new Object[]{timeout, thread.getName(), thread.getId(), thread.getState().toString(), element.getClassName(), element.getMethodName(), element.getFileName(), element.getLineNumber()});
            } else {
                SafeMethodCaller.getLogger().debug("Timeout of {}ms exceeded with no thread info available.", (Object)timeout);
            }
            throw e;
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(SafeMethodCaller.class);
    }

    public static interface Action<V>
    extends Callable<V> {
    }

    public static interface ActionWithException<V>
    extends Callable<V> {
    }

    private static class CallableWrapper<V>
    implements Callable<V> {
        private final Callable<V> callable;
        private Thread thread;

        public CallableWrapper(Callable<V> callable) {
            this.callable = callable;
        }

        public Thread getThread() {
            return this.thread;
        }

        @Override
        public V call() throws Exception {
            this.thread = Thread.currentThread();
            return this.callable.call();
        }
    }
}

