/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.common.osgi;

import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import org.osgi.framework.Bundle;

public class ResourceBundleClassLoader
extends ClassLoader {
    private Bundle bundle;
    private String path;
    private String filePattern;

    public ResourceBundleClassLoader(Bundle bundle, String path, String filePattern) throws IllegalArgumentException {
        if (bundle == null) {
            throw new IllegalArgumentException("The bundle must not be null!");
        }
        this.bundle = bundle;
        this.path = path != null ? path : "/";
        this.filePattern = filePattern != null ? filePattern : "*";
    }

    @Override
    public URL getResource(String name) {
        Enumeration resourceFiles = this.bundle.findEntries(this.path, this.filePattern, true);
        if (resourceFiles != null) {
            while (resourceFiles.hasMoreElements()) {
                URL resourceURL = (URL)resourceFiles.nextElement();
                String resourcePath = resourceURL.getFile();
                File resourceFile = new File(resourcePath);
                String resourceFileName = resourceFile.getName();
                if (!resourceFileName.equals(name)) continue;
                return resourceURL;
            }
        }
        return null;
    }
}

