/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.common.registry;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.smarthome.core.common.registry.ManagedProvider;
import org.eclipse.smarthome.core.common.registry.Provider;
import org.eclipse.smarthome.core.common.registry.ProviderChangeListener;
import org.eclipse.smarthome.core.common.registry.Registry;
import org.eclipse.smarthome.core.common.registry.RegistryChangeListener;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRegistry<E, K>
implements ProviderChangeListener<E>,
Registry<E, K> {
    private final Logger logger = LoggerFactory.getLogger(AbstractRegistry.class);
    protected Map<Provider<E>, Collection<E>> elementMap = new ConcurrentHashMap<Provider<E>, Collection<E>>();
    protected Collection<RegistryChangeListener<E>> listeners = new CopyOnWriteArraySet<RegistryChangeListener<E>>();
    protected ManagedProvider<E, K> managedProvider;
    protected EventPublisher eventPublisher;

    @Override
    public void added(Provider<E> provider, E element) {
        Collection<E> elements = this.elementMap.get(provider);
        if (elements != null) {
            try {
                this.onAddElement(element);
                elements.add(element);
                this.notifyListenersAboutAddedElement(element);
            }
            catch (Exception ex) {
                this.logger.warn("Could not add element: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Override
    public void addRegistryChangeListener(RegistryChangeListener<E> listener) {
        this.listeners.add(listener);
    }

    @Override
    public Collection<E> getAll() {
        return ImmutableList.copyOf((Iterable)Iterables.concat(this.elementMap.values()));
    }

    @Override
    public void removed(Provider<E> provider, E element) {
        Collection<E> elements = this.elementMap.get(provider);
        if (elements != null) {
            try {
                this.onRemoveElement(element);
                elements.remove(element);
                this.notifyListenersAboutRemovedElement(element);
            }
            catch (Exception ex) {
                this.logger.warn("Could not remove element: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Override
    public void removeRegistryChangeListener(RegistryChangeListener<E> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void updated(Provider<E> provider, E oldElement, E element) {
        Collection<E> elements = this.elementMap.get(provider);
        if (elements != null) {
            try {
                this.onUpdateElement(oldElement, element);
                elements.remove(oldElement);
                elements.add(element);
                this.notifyListenersAboutUpdatedElement(oldElement, element);
            }
            catch (Exception ex) {
                this.logger.warn("Could not update element: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Override
    public E add(E element) {
        if (this.managedProvider != null) {
            this.managedProvider.add(element);
            return element;
        }
        throw new IllegalStateException("ManagedProvider is not available");
    }

    @Override
    public E update(E element) {
        if (this.managedProvider != null) {
            return this.managedProvider.update(element);
        }
        throw new IllegalStateException("ManagedProvider is not available");
    }

    @Override
    public E remove(K key) {
        if (this.managedProvider != null) {
            return this.managedProvider.remove(key);
        }
        throw new IllegalStateException("ManagedProvider is not available");
    }

    protected void notifyListeners(E oldElement, E element, EventType eventType) {
        for (RegistryChangeListener<E> listener : this.listeners) {
            try {
                switch (eventType) {
                    case ADDED: {
                        listener.added(element);
                        break;
                    }
                    case REMOVED: {
                        listener.removed(element);
                        break;
                    }
                    case UPDATED: {
                        listener.updated(oldElement, element);
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                this.logger.error("Could not inform the listener '" + listener + "' about the '" + eventType.name() + "' event!: " + throwable.getMessage(), throwable);
            }
        }
    }

    protected void notifyListeners(E element, EventType eventType) {
        this.notifyListeners(null, element, eventType);
    }

    protected void notifyListenersAboutAddedElement(E element) {
        this.notifyListeners(element, EventType.ADDED);
    }

    protected void notifyListenersAboutRemovedElement(E element) {
        this.notifyListeners(element, EventType.REMOVED);
    }

    protected void notifyListenersAboutUpdatedElement(E oldElement, E element) {
        this.notifyListeners(oldElement, element, EventType.UPDATED);
    }

    protected void addProvider(Provider<E> provider) {
        if (!this.elementMap.containsKey(provider)) {
            Collection<E> elementsOfProvider = provider.getAll();
            CopyOnWriteArraySet<E> elements = new CopyOnWriteArraySet<E>();
            provider.addProviderChangeListener(this);
            this.elementMap.put(provider, elements);
            for (E element : elementsOfProvider) {
                try {
                    this.onAddElement(element);
                    elements.add(element);
                    this.notifyListenersAboutAddedElement(element);
                }
                catch (Exception ex) {
                    this.logger.warn("Could not add element: " + ex.getMessage(), (Throwable)ex);
                }
            }
            this.logger.debug("Provider '{}' has been added.", (Object)provider.getClass().getName());
        }
    }

    protected void setManagedProvider(ManagedProvider<E, K> provider) {
        this.managedProvider = provider;
    }

    protected void onAddElement(E element) throws IllegalArgumentException {
    }

    protected void onRemoveElement(E element) {
    }

    protected void onUpdateElement(E oldElement, E element) throws IllegalArgumentException {
    }

    protected void removeProvider(Provider<E> provider) {
        if (this.elementMap.containsKey(provider)) {
            for (E element : this.elementMap.get(provider)) {
                try {
                    this.onRemoveElement(element);
                    this.notifyListenersAboutRemovedElement(element);
                }
                catch (Exception ex) {
                    this.logger.warn("Could not remove element: " + ex.getMessage(), (Throwable)ex);
                }
            }
            this.elementMap.remove(provider);
            provider.removeProviderChangeListener(this);
            this.logger.debug("Provider '{}' has been removed.", (Object)provider.getClass().getSimpleName());
        }
    }

    protected void removeManagedProvider(ManagedProvider<E, K> managedProvider) {
        this.managedProvider = null;
    }

    protected void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    protected void unsetEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = null;
    }

    protected void postEvent(Event event) {
        if (this.eventPublisher != null) {
            try {
                this.eventPublisher.post(event);
            }
            catch (Exception ex) {
                this.logger.error("Could not post event of type '" + event.getType() + "'.", (Throwable)ex);
            }
        }
    }

    private static enum EventType {
        ADDED,
        REMOVED,
        UPDATED;

    }
}

