/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.internal.events;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import org.eclipse.smarthome.core.common.SafeMethodCaller;
import org.eclipse.smarthome.core.events.EventFactory;
import org.eclipse.smarthome.core.events.EventFilter;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.events.EventSubscriber;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSGiEventManager
implements EventHandler,
EventPublisher {
    private Logger logger = LoggerFactory.getLogger(OSGiEventManager.class);
    private EventAdmin osgiEventAdmin;
    private final Map<String, EventFactory> typedEventFactories = new ConcurrentHashMap<String, EventFactory>();
    private final SetMultimap<String, EventSubscriber> typedEventSubscribers = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    private EventSubscriberServiceTracker eventSubscriberServiceTracker;

    protected void activate(ComponentContext componentContext) {
        this.eventSubscriberServiceTracker = new EventSubscriberServiceTracker(componentContext.getBundleContext());
        this.eventSubscriberServiceTracker.open();
    }

    protected void deactivate(ComponentContext componentContext) {
        if (this.eventSubscriberServiceTracker != null) {
            this.eventSubscriberServiceTracker.close();
        }
    }

    protected void setEventAdmin(EventAdmin eventAdmin) {
        this.osgiEventAdmin = eventAdmin;
    }

    protected void unsetEventAdmin(EventAdmin eventAdmin) {
        this.osgiEventAdmin = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addEventFactory(EventFactory eventFactory) {
        Set<String> supportedEventTypes = eventFactory.getSupportedEventTypes();
        for (String supportedEventType : supportedEventTypes) {
            OSGiEventManager oSGiEventManager = this;
            synchronized (oSGiEventManager) {
                if (!this.typedEventFactories.containsKey(supportedEventType)) {
                    this.typedEventFactories.put(supportedEventType, eventFactory);
                }
            }
        }
    }

    protected void removeEventFactory(EventFactory eventFactory) {
        Set<String> supportedEventTypes = eventFactory.getSupportedEventTypes();
        for (String supportedEventType : supportedEventTypes) {
            this.typedEventFactories.remove(supportedEventType);
        }
    }

    public void handleEvent(Event osgiEvent) {
        Object typeObj = osgiEvent.getProperty("type");
        Object payloadObj = osgiEvent.getProperty("payload");
        Object topicObj = osgiEvent.getProperty("topic");
        Object sourceObj = osgiEvent.getProperty("source");
        if (typeObj instanceof String && payloadObj instanceof String && topicObj instanceof String) {
            String sourceStr;
            String typeStr = (String)typeObj;
            String payloadStr = (String)payloadObj;
            String topicStr = (String)topicObj;
            String string = sourceStr = sourceObj instanceof String ? (String)sourceObj : null;
            if (!(typeStr.isEmpty() || payloadStr.isEmpty() || topicStr.isEmpty())) {
                this.handleEvent(typeStr, payloadStr, topicStr, sourceStr);
            }
        } else {
            this.logger.error("The handled OSGi event is invalid. Expect properties as string named 'type', 'payload' and 'topic'. Received event properties are: " + osgiEvent.getPropertyNames());
        }
    }

    private void handleEvent(String type, String payload, String topic, String source) {
        EventFactory eventFactory = this.typedEventFactories.get(type);
        if (eventFactory != null) {
            org.eclipse.smarthome.core.events.Event eshEvent;
            Set<EventSubscriber> eventSubscribers = this.getEventSubscribers(type);
            if (!eventSubscribers.isEmpty() && (eshEvent = this.createESHEvent(eventFactory, type, payload, topic, source)) != null) {
                this.dispatchESHEvent(eventSubscribers, eshEvent);
            }
        } else {
            this.logger.warn("Could not find an Event Factory for the event type '" + type + "'.");
        }
    }

    private org.eclipse.smarthome.core.events.Event createESHEvent(EventFactory eventFactory, String type, String payload, String topic, String source) {
        org.eclipse.smarthome.core.events.Event eshEvent = null;
        try {
            eshEvent = eventFactory.createEvent(type, topic, payload, source);
        }
        catch (Exception e) {
            this.logger.error("Creation of ESH-Event failed, because one of the registered event factories has thrown an exception: " + e.getMessage(), (Throwable)e);
        }
        return eshEvent;
    }

    private void dispatchESHEvent(Set<EventSubscriber> eventSubscribers, final org.eclipse.smarthome.core.events.Event event) {
        for (final EventSubscriber eventSubscriber : eventSubscribers) {
            try {
                EventFilter filter = eventSubscriber.getEventFilter();
                if (filter != null && !filter.apply(event)) continue;
                SafeMethodCaller.call(new SafeMethodCaller.ActionWithException<Void>(){

                    @Override
                    public Void call() throws Exception {
                        eventSubscriber.receive(event);
                        return null;
                    }
                });
            }
            catch (TimeoutException timeoutException) {
                this.logger.warn("Dispatching event to subscriber '{}' takes more than {}ms.", (Object)eventSubscriber.toString(), (Object)SafeMethodCaller.DEFAULT_TIMEOUT);
            }
            catch (Throwable t) {
                this.logger.error("Dispatching/filtering event for subscriber '" + EventSubscriber.class.getName() + "' failed: " + t.getMessage(), t);
            }
        }
    }

    private Set<EventSubscriber> getEventSubscribers(String eventType) {
        Set eventTypeSubscribers = this.typedEventSubscribers.get((Object)eventType);
        Set allEventTypeSubscribers = this.typedEventSubscribers.get((Object)"ALL");
        HashSet<EventSubscriber> subscribers = new HashSet<EventSubscriber>();
        if (eventTypeSubscribers != null) {
            subscribers.addAll(eventTypeSubscribers);
        }
        if (allEventTypeSubscribers != null) {
            subscribers.addAll(allEventTypeSubscribers);
        }
        return subscribers;
    }

    @Override
    public void post(org.eclipse.smarthome.core.events.Event event) throws IllegalArgumentException, IllegalStateException {
        EventAdmin eventAdmin = this.osgiEventAdmin;
        this.assertValidArgument(event);
        this.assertValidState(eventAdmin);
        this.postAsOSGiEvent(eventAdmin, event);
    }

    private void postAsOSGiEvent(final EventAdmin eventAdmin, final org.eclipse.smarthome.core.events.Event event) throws IllegalStateException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    Hashtable<String, String> properties = new Hashtable<String, String>(3);
                    ((Dictionary)properties).put("type", event.getType());
                    ((Dictionary)properties).put("payload", event.getPayload());
                    ((Dictionary)properties).put("topic", event.getTopic());
                    if (event.getSource() != null) {
                        ((Dictionary)properties).put("source", event.getSource());
                    }
                    eventAdmin.postEvent(new Event("smarthome", properties));
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            throw new IllegalStateException("Cannot post the event via the event bus. Error message: " + e.getMessage(), e);
        }
    }

    private void assertValidArgument(org.eclipse.smarthome.core.events.Event event) throws IllegalArgumentException {
        String errorMsg = "The %s of the 'event' argument must not be null or empty.";
        Preconditions.checkArgument((event != null ? 1 : 0) != 0, (Object)"Argument 'event' must not be null.");
        Preconditions.checkArgument((event.getType() != null && !event.getType().isEmpty() ? 1 : 0) != 0, (Object)String.format(errorMsg, "type"));
        Preconditions.checkArgument((event.getPayload() != null && !event.getPayload().isEmpty() ? 1 : 0) != 0, (Object)String.format(errorMsg, "payload"));
        Preconditions.checkArgument((event.getTopic() != null && !event.getTopic().isEmpty() ? 1 : 0) != 0, (Object)String.format(errorMsg, "topic"));
    }

    private void assertValidState(EventAdmin eventAdmin) throws IllegalStateException {
        Preconditions.checkArgument((eventAdmin != null ? 1 : 0) != 0, (Object)"The event bus module is not available!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEventSubscriber(EventSubscriber eventSubscriber) {
        Set<String> subscribedEventTypes = eventSubscriber.getSubscribedEventTypes();
        for (String subscribedEventType : subscribedEventTypes) {
            OSGiEventManager oSGiEventManager = this;
            synchronized (oSGiEventManager) {
                if (!this.typedEventSubscribers.containsEntry((Object)subscribedEventType, (Object)eventSubscriber)) {
                    this.typedEventSubscribers.put((Object)subscribedEventType, (Object)eventSubscriber);
                }
            }
        }
    }

    private void removeEventSubscriber(EventSubscriber eventSubscriber) {
        Set<String> subscribedEventTypes = eventSubscriber.getSubscribedEventTypes();
        for (String subscribedEventType : subscribedEventTypes) {
            this.typedEventSubscribers.remove((Object)subscribedEventType, (Object)eventSubscriber);
        }
    }

    private class EventSubscriberServiceTracker
    extends ServiceTracker {
        public EventSubscriberServiceTracker(BundleContext context) {
            super(context, EventSubscriber.class.getName(), null);
        }

        public Object addingService(ServiceReference reference) {
            EventSubscriber eventSubscriber = (EventSubscriber)this.context.getService(reference);
            if (eventSubscriber != null) {
                OSGiEventManager.this.addEventSubscriber(eventSubscriber);
                return eventSubscriber;
            }
            return null;
        }

        public void removedService(ServiceReference reference, Object service) {
            OSGiEventManager.this.removeEventSubscriber((EventSubscriber)service);
        }
    }
}

