/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.items.events;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.LinkedList;
import org.eclipse.smarthome.core.events.AbstractEventFactory;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.dto.ItemDTO;
import org.eclipse.smarthome.core.items.dto.ItemDTOMapper;
import org.eclipse.smarthome.core.items.events.GroupItemStateChangedEvent;
import org.eclipse.smarthome.core.items.events.ItemAddedEvent;
import org.eclipse.smarthome.core.items.events.ItemCommandEvent;
import org.eclipse.smarthome.core.items.events.ItemRemovedEvent;
import org.eclipse.smarthome.core.items.events.ItemStateChangedEvent;
import org.eclipse.smarthome.core.items.events.ItemStateEvent;
import org.eclipse.smarthome.core.items.events.ItemUpdatedEvent;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.RefreshType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.Type;
import org.eclipse.smarthome.core.types.UnDefType;

public class ItemEventFactory
extends AbstractEventFactory {
    private static final String CORE_LIBRARY_PACKAGE = "org.eclipse.smarthome.core.library.types.";
    private static final String ITEM_COMAND_EVENT_TOPIC = "smarthome/items/{itemName}/command";
    private static final String ITEM_STATE_EVENT_TOPIC = "smarthome/items/{itemName}/state";
    private static final String ITEM_STATE_CHANGED_EVENT_TOPIC = "smarthome/items/{itemName}/statechanged";
    private static final String GROUPITEM_STATE_CHANGED_EVENT_TOPIC = "smarthome/items/{itemName}/{memberName}/statechanged";
    private static final String ITEM_ADDED_EVENT_TOPIC = "smarthome/items/{itemName}/added";
    private static final String ITEM_REMOVED_EVENT_TOPIC = "smarthome/items/{itemName}/removed";
    private static final String ITEM_UPDATED_EVENT_TOPIC = "smarthome/items/{itemName}/updated";

    public ItemEventFactory() {
        super(Sets.newHashSet((Object[])new String[]{ItemCommandEvent.TYPE, ItemStateEvent.TYPE, ItemStateChangedEvent.TYPE, ItemAddedEvent.TYPE, ItemUpdatedEvent.TYPE, ItemRemovedEvent.TYPE, GroupItemStateChangedEvent.TYPE}));
    }

    @Override
    protected Event createEventByType(String eventType, String topic, String payload, String source) throws Exception {
        Event event = null;
        if (eventType.equals(ItemCommandEvent.TYPE)) {
            event = this.createCommandEvent(topic, payload, source);
        } else if (eventType.equals(ItemStateEvent.TYPE)) {
            event = this.createStateEvent(topic, payload, source);
        } else if (eventType.equals(ItemStateChangedEvent.TYPE)) {
            event = this.createStateChangedEvent(topic, payload);
        } else if (eventType.equals(ItemAddedEvent.TYPE)) {
            event = this.createAddedEvent(topic, payload);
        } else if (eventType.equals(ItemUpdatedEvent.TYPE)) {
            event = this.createUpdatedEvent(topic, payload);
        } else if (eventType.equals(ItemRemovedEvent.TYPE)) {
            event = this.createRemovedEvent(topic, payload);
        } else if (eventType.equals(GroupItemStateChangedEvent.TYPE)) {
            event = this.createGroupStateChangedEvent(topic, payload);
        }
        return event;
    }

    private Event createGroupStateChangedEvent(String topic, String payload) {
        String itemName = this.getItemName(topic);
        String memberName = this.getMemberName(topic);
        ItemStateChangedEventPayloadBean bean = ItemEventFactory.deserializePayload(payload, ItemStateChangedEventPayloadBean.class);
        State state = this.getState(bean.getType(), bean.getValue());
        State oldState = this.getState(bean.getOldType(), bean.getOldValue());
        return new GroupItemStateChangedEvent(topic, payload, itemName, memberName, state, oldState);
    }

    private Event createCommandEvent(String topic, String payload, String source) {
        String itemName = this.getItemName(topic);
        ItemEventPayloadBean bean = ItemEventFactory.deserializePayload(payload, ItemEventPayloadBean.class);
        Command command = null;
        try {
            command = (Command)this.parse(bean.getType(), bean.getValue());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Parsing of item command event failed.", e);
        }
        return new ItemCommandEvent(topic, payload, itemName, command, source);
    }

    private Event createStateEvent(String topic, String payload, String source) {
        String itemName = this.getItemName(topic);
        ItemEventPayloadBean bean = ItemEventFactory.deserializePayload(payload, ItemEventPayloadBean.class);
        State state = this.getState(bean.getType(), bean.getValue());
        return new ItemStateEvent(topic, payload, itemName, state, source);
    }

    private Event createStateChangedEvent(String topic, String payload) {
        String itemName = this.getItemName(topic);
        ItemStateChangedEventPayloadBean bean = ItemEventFactory.deserializePayload(payload, ItemStateChangedEventPayloadBean.class);
        State state = this.getState(bean.getType(), bean.getValue());
        State oldState = this.getState(bean.getOldType(), bean.getOldValue());
        return new ItemStateChangedEvent(topic, payload, itemName, state, oldState);
    }

    private State getState(String type, String value) {
        State state = null;
        try {
            state = (State)this.parse(type, value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Parsing of item state event failed.", e);
        }
        return state;
    }

    private String getItemName(String topic) {
        String[] topicElements = this.getTopicElements(topic);
        if (topicElements.length < 4) {
            throw new IllegalArgumentException("Event creation failed, invalid topic: " + topic);
        }
        return topicElements[2];
    }

    private String getMemberName(String topic) {
        String[] topicElements = this.getTopicElements(topic);
        if (topicElements.length < 5) {
            throw new IllegalArgumentException("Event creation failed, invalid topic: " + topic);
        }
        return topicElements[3];
    }

    private Object parse(String typeName, String valueToParse) throws Exception {
        if (typeName.equals(UnDefType.class.getSimpleName())) {
            return UnDefType.valueOf(valueToParse);
        }
        if (typeName.equals(RefreshType.class.getSimpleName())) {
            return RefreshType.valueOf(valueToParse);
        }
        Class<?> stateClass = Class.forName(CORE_LIBRARY_PACKAGE + typeName);
        Method valueOfMethod = stateClass.getMethod("valueOf", String.class);
        return valueOfMethod.invoke(stateClass, valueToParse);
    }

    private Event createAddedEvent(String topic, String payload) {
        ItemDTO itemDTO = ItemEventFactory.deserializePayload(payload, ItemDTO.class);
        return new ItemAddedEvent(topic, payload, itemDTO);
    }

    private Event createRemovedEvent(String topic, String payload) {
        ItemDTO itemDTO = ItemEventFactory.deserializePayload(payload, ItemDTO.class);
        return new ItemRemovedEvent(topic, payload, itemDTO);
    }

    private Event createUpdatedEvent(String topic, String payload) {
        ItemDTO[] itemDTOs = ItemEventFactory.deserializePayload(payload, ItemDTO[].class);
        if (itemDTOs.length != 2) {
            throw new IllegalArgumentException("ItemUpdateEvent creation failed, invalid payload: " + payload);
        }
        return new ItemUpdatedEvent(topic, payload, itemDTOs[0], itemDTOs[1]);
    }

    public static ItemCommandEvent createCommandEvent(String itemName, Command command, String source) {
        ItemEventFactory.assertValidArguments(itemName, command, "command");
        String topic = ItemEventFactory.buildTopic(ITEM_COMAND_EVENT_TOPIC, itemName);
        ItemEventPayloadBean bean = new ItemEventPayloadBean(command.getClass().getSimpleName(), command.toString());
        String payload = ItemEventFactory.serializePayload(bean);
        return new ItemCommandEvent(topic, payload, itemName, command, source);
    }

    public static ItemCommandEvent createCommandEvent(String itemName, Command command) {
        return ItemEventFactory.createCommandEvent(itemName, command, null);
    }

    public static ItemStateEvent createStateEvent(String itemName, State state, String source) {
        ItemEventFactory.assertValidArguments(itemName, state, "state");
        String topic = ItemEventFactory.buildTopic(ITEM_STATE_EVENT_TOPIC, itemName);
        ItemEventPayloadBean bean = new ItemEventPayloadBean(state.getClass().getSimpleName(), state.toString());
        String payload = ItemEventFactory.serializePayload(bean);
        return new ItemStateEvent(topic, payload, itemName, state, source);
    }

    public static ItemStateEvent createStateEvent(String itemName, State state) {
        return ItemEventFactory.createStateEvent(itemName, state, null);
    }

    public static ItemStateChangedEvent createStateChangedEvent(String itemName, State newState, State oldState) {
        ItemEventFactory.assertValidArguments(itemName, newState, "state");
        String topic = ItemEventFactory.buildTopic(ITEM_STATE_CHANGED_EVENT_TOPIC, itemName);
        ItemStateChangedEventPayloadBean bean = new ItemStateChangedEventPayloadBean(newState.getClass().getSimpleName(), newState.toString(), oldState.getClass().getSimpleName(), oldState.toString());
        String payload = ItemEventFactory.serializePayload(bean);
        return new ItemStateChangedEvent(topic, payload, itemName, newState, oldState);
    }

    public static GroupItemStateChangedEvent createGroupStateChangedEvent(String itemName, String memberName, State newState, State oldState) {
        ItemEventFactory.assertValidArguments(itemName, memberName, newState, "state");
        String topic = ItemEventFactory.buildGroupTopic(GROUPITEM_STATE_CHANGED_EVENT_TOPIC, itemName, memberName);
        ItemStateChangedEventPayloadBean bean = new ItemStateChangedEventPayloadBean(newState.getClass().getSimpleName(), newState.toString(), oldState.getClass().getSimpleName(), oldState.toString());
        String payload = ItemEventFactory.serializePayload(bean);
        return new GroupItemStateChangedEvent(topic, payload, itemName, memberName, newState, oldState);
    }

    public static ItemAddedEvent createAddedEvent(Item item) {
        ItemEventFactory.assertValidArgument(item, "item");
        String topic = ItemEventFactory.buildTopic(ITEM_ADDED_EVENT_TOPIC, item.getName());
        ItemDTO itemDTO = ItemEventFactory.map(item);
        String payload = ItemEventFactory.serializePayload(itemDTO);
        return new ItemAddedEvent(topic, payload, itemDTO);
    }

    public static ItemRemovedEvent createRemovedEvent(Item item) {
        ItemEventFactory.assertValidArgument(item, "item");
        String topic = ItemEventFactory.buildTopic(ITEM_REMOVED_EVENT_TOPIC, item.getName());
        ItemDTO itemDTO = ItemEventFactory.map(item);
        String payload = ItemEventFactory.serializePayload(itemDTO);
        return new ItemRemovedEvent(topic, payload, itemDTO);
    }

    public static ItemUpdatedEvent createUpdateEvent(Item item, Item oldItem) {
        ItemEventFactory.assertValidArgument(item, "item");
        ItemEventFactory.assertValidArgument(oldItem, "oldItem");
        String topic = ItemEventFactory.buildTopic(ITEM_UPDATED_EVENT_TOPIC, item.getName());
        ItemDTO itemDTO = ItemEventFactory.map(item);
        ItemDTO oldItemDTO = ItemEventFactory.map(oldItem);
        LinkedList<ItemDTO> itemDTOs = new LinkedList<ItemDTO>();
        itemDTOs.add(itemDTO);
        itemDTOs.add(oldItemDTO);
        String payload = ItemEventFactory.serializePayload(itemDTOs);
        return new ItemUpdatedEvent(topic, payload, itemDTO, oldItemDTO);
    }

    private static String buildTopic(String topic, String itemName) {
        return topic.replace("{itemName}", itemName);
    }

    private static String buildGroupTopic(String topic, String itemName, String memberName) {
        return ItemEventFactory.buildTopic(topic, itemName).replace("{memberName}", memberName);
    }

    private static ItemDTO map(Item item) {
        return ItemDTOMapper.map(item);
    }

    private static void assertValidArguments(String itemName, Type type, String typeArgumentName) {
        Preconditions.checkArgument((itemName != null && !itemName.isEmpty() ? 1 : 0) != 0, (Object)"The argument 'itemName' must not be null or empty.");
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)("The argument '" + typeArgumentName + "' must not be null or empty."));
    }

    private static void assertValidArguments(String itemName, String memberName, Type type, String typeArgumentName) {
        Preconditions.checkArgument((itemName != null && !itemName.isEmpty() ? 1 : 0) != 0, (Object)"The argument 'itemName' must not be null or empty.");
        Preconditions.checkArgument((memberName != null && !memberName.isEmpty() ? 1 : 0) != 0, (Object)"The argument 'memberName' must not be null or empty.");
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)("The argument '" + typeArgumentName + "' must not be null or empty."));
    }

    private static void assertValidArgument(Item item, String argumentName) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)("The argument '" + argumentName + "' must no be null."));
    }

    private static class ItemEventPayloadBean {
        private String type;
        private String value;

        protected ItemEventPayloadBean() {
        }

        public ItemEventPayloadBean(String type, String value) {
            this.type = type;
            this.value = value;
        }

        public String getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }
    }

    private static class ItemStateChangedEventPayloadBean {
        private String type;
        private String value;
        private String oldType;
        private String oldValue;

        protected ItemStateChangedEventPayloadBean() {
        }

        public ItemStateChangedEventPayloadBean(String type, String value, String oldType, String oldValue) {
            this.type = type;
            this.value = value;
            this.oldType = oldType;
            this.oldValue = oldValue;
        }

        public String getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public String getOldType() {
            return this.oldType;
        }

        public String getOldValue() {
            return this.oldValue;
        }
    }
}

