/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.service;

import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWatchQueueReader
implements Runnable {
    protected final Logger logger = LoggerFactory.getLogger(AbstractWatchQueueReader.class);
    protected WatchService watchService;
    protected Path dir;

    static <T> WatchEvent<T> cast(WatchEvent<?> event) {
        return event;
    }

    public AbstractWatchQueueReader(WatchService watchService, Path dir) {
        this.watchService = watchService;
        this.dir = dir;
    }

    @Override
    public void run() {
        try {
            while (true) {
                WatchKey key = null;
                try {
                    key = this.watchService.take();
                }
                catch (InterruptedException exc) {
                    this.logger.warn(MessageFormat.format("Catched InterruptedException : {0}", exc.getLocalizedMessage()));
                    return;
                }
                for (WatchEvent<?> event : key.pollEvents()) {
                    WatchEvent.Kind<?> kind = event.kind();
                    if (kind == StandardWatchEventKinds.OVERFLOW) {
                        this.logger.warn(MessageFormat.format("Found event with overflow kind : {0}", event));
                        continue;
                    }
                    WatchEvent ev = AbstractWatchQueueReader.cast(event);
                    Path path = (Path)ev.context();
                    this.processWatchEvent(event, kind, path);
                }
                key.reset();
            }
        }
        catch (ClosedWatchServiceException ecx) {
            this.logger.debug("ClosedWatchServiceException catched! {}. \n{} Stopping ", (Object)ecx.getLocalizedMessage(), (Object)Thread.currentThread().getName());
            return;
        }
    }

    protected abstract void processWatchEvent(WatchEvent<?> var1, WatchEvent.Kind<?> var2, Path var3);
}

