/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.designer.core.config;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.smarthome.designer.core.CoreActivator;
import org.eclipse.smarthome.designer.core.config.IProjectCreator;
import org.eclipse.smarthome.model.script.engine.action.ActionService;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class PluginProjectCreator
implements IProjectCreator {
    @Override
    public IProject createProject(String projectName) {
        try {
            IProject _xblockexpression = null;
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot _root = workspace.getRoot();
            final IProject project = _root.getProject(projectName);
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IProjectDescription _xifexpression = null;
            boolean _exists = project.exists();
            if (_exists) {
                _xifexpression = project.getDescription();
            } else {
                IProjectDescription _newProjectDescription = workspace.newProjectDescription(projectName);
                Procedures.Procedure1<IProjectDescription> _function = new Procedures.Procedure1<IProjectDescription>(){

                    public void apply(IProjectDescription it) {
                        try {
                            it.setLocation(null);
                            project.create(it, null);
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                };
                _xifexpression = (IProjectDescription)ObjectExtensions.operator_doubleArrow((Object)_newProjectDescription, (Procedures.Procedure1)_function);
            }
            IProjectDescription projectDescription = _xifexpression;
            projectDescription.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature", "org.eclipse.pde.PluginNature", "org.eclipse.xtext.ui.shared.xtextNature"});
            ArrayList builders = CollectionLiterals.newArrayList((Object[])new ICommand[0]);
            ICommand _newCommand = projectDescription.newCommand();
            Procedures.Procedure1<ICommand> _function_1 = new Procedures.Procedure1<ICommand>(){

                public void apply(ICommand it) {
                    it.setBuilderName("org.eclipse.jdt.core.javabuilder");
                }
            };
            ICommand _doubleArrow = (ICommand)ObjectExtensions.operator_doubleArrow((Object)_newCommand, (Procedures.Procedure1)_function_1);
            builders.add(_doubleArrow);
            ICommand _newCommand_1 = projectDescription.newCommand();
            Procedures.Procedure1<ICommand> _function_2 = new Procedures.Procedure1<ICommand>(){

                public void apply(ICommand it) {
                    it.setBuilderName("org.eclipse.pde.ManifestBuilder");
                }
            };
            ICommand _doubleArrow_1 = (ICommand)ObjectExtensions.operator_doubleArrow((Object)_newCommand_1, (Procedures.Procedure1)_function_2);
            builders.add(_doubleArrow_1);
            ICommand _newCommand_2 = projectDescription.newCommand();
            Procedures.Procedure1<ICommand> _function_3 = new Procedures.Procedure1<ICommand>(){

                public void apply(ICommand it) {
                    it.setBuilderName("org.eclipse.pde.SchemaBuilder");
                }
            };
            ICommand _doubleArrow_2 = (ICommand)ObjectExtensions.operator_doubleArrow((Object)_newCommand_2, (Procedures.Procedure1)_function_3);
            builders.add(_doubleArrow_2);
            ICommand _newCommand_3 = projectDescription.newCommand();
            Procedures.Procedure1<ICommand> _function_4 = new Procedures.Procedure1<ICommand>(){

                public void apply(ICommand it) {
                    it.setBuilderName("org.eclipse.xtext.ui.shared.xtextBuilder");
                }
            };
            ICommand _doubleArrow_3 = (ICommand)ObjectExtensions.operator_doubleArrow((Object)_newCommand_3, (Procedures.Procedure1)_function_4);
            builders.add(_doubleArrow_3);
            projectDescription.setBuildSpec((ICommand[])Conversions.unwrapArray((Object)builders, ICommand.class));
            project.open(null);
            project.setDescription(projectDescription, null);
            ArrayList classpathEntries = CollectionLiterals.newArrayList((Object[])new IClasspathEntry[0]);
            Path _path = new Path("org.eclipse.jdt.launching.JRE_CONTAINER");
            IClasspathEntry _newContainerEntry = JavaCore.newContainerEntry((IPath)_path);
            classpathEntries.add(_newContainerEntry);
            Path _path_1 = new Path("org.eclipse.pde.core.requiredPlugins");
            IClasspathEntry _newContainerEntry_1 = JavaCore.newContainerEntry((IPath)_path_1);
            classpathEntries.add(_newContainerEntry_1);
            javaProject.setRawClasspath((IClasspathEntry[])Conversions.unwrapArray((Object)classpathEntries, IClasspathEntry.class), null);
            Path _path_2 = new Path("/" + projectName + "/bin");
            javaProject.setOutputLocation((IPath)_path_2, null);
            this.createManifest(project);
            this.createBuildProps(project);
            this.setJavaVM();
            _xblockexpression = project;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void setJavaVM() {
        try {
            String javaHome = System.getProperty("java.home");
            boolean _equals = Objects.equal((Object)javaHome, null);
            if (_equals) {
                throw new RuntimeException("JAVA_HOME environment variable has to be specified!");
            }
            IEclipsePreferences jdtLaunchingPreferences = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.launching");
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
            _builder.newLine();
            _builder.append((Object)"<vmSettings defaultVM=\"57,org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType13,1393576529277\">");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"<vmType id=\"org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType\">");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"<vm id=\"1393576529277\" javadocURL=\"http://download.oracle.com/javase/7/docs/api/\" name=\"JAVA_HOME_JRE\" path=\"");
            _builder.append((Object)javaHome, "\t\t");
            _builder.append((Object)"\">");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"</vm>");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"</vmType>");
            _builder.newLine();
            _builder.append((Object)"</vmSettings>");
            _builder.newLine();
            String xmlValue = _builder.toString();
            jdtLaunchingPreferences.put("org.eclipse.jdt.launching.PREF_VM_XML", xmlValue);
            jdtLaunchingPreferences.flush();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void createManifest(IProject project) throws CoreException {
        boolean _not_1;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"Manifest-Version: 1.0");
        _builder.newLine();
        _builder.append((Object)"Bundle-ManifestVersion: 2");
        _builder.newLine();
        _builder.append((Object)"Bundle-Name: Eclipse SmartHome Designer Project");
        _builder.newLine();
        _builder.append((Object)"Bundle-SymbolicName: ");
        String _name = project.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)";singleton:=true");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"Bundle-Version: 1.0.0.qualifier");
        _builder.newLine();
        _builder.append((Object)"Bundle-Vendor: Eclipse.org/SmartHome");
        _builder.newLine();
        _builder.append((Object)"Require-Bundle: org.eclipse.xtext.xbase.lib");
        _builder.newLine();
        _builder.append((Object)"Import-Package: org.eclipse.smarthome.model.script.actions,");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"org.joda.time,");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"org.osgi.service.cm,");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"org.eclipse.smarthome.core.library.types,");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"org.eclipse.smarthome.core.library.items,");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"org.eclipse.smarthome.core.items,");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"org.eclipse.smarthome.core.persistence");
        Set<String> _importedPackages = this.getImportedPackages();
        boolean _isEmpty = _importedPackages.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append((Object)",");
        }
        _builder.newLineIfNotEmpty();
        Set<String> _importedPackages_1 = this.getImportedPackages();
        boolean _hasElements = false;
        for (String importPackage : _importedPackages_1) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "");
            }
            _builder.append((Object)(" " + importPackage), "");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"Bundle-RequiredExecutionEnvironment: JavaSE-1.7");
        _builder.newLine();
        _builder.append((Object)"Bundle-ActivationPolicy: lazy");
        _builder.newLine();
        String manifestContent = _builder.toString();
        IFolder metaInfFolder = project.getFolder("META-INF");
        boolean _exists = metaInfFolder.exists();
        boolean bl2 = _not_1 = !_exists;
        if (_not_1) {
            metaInfFolder.create(false, true, null);
        }
        this.createFile("MANIFEST.MF", (IContainer)metaInfFolder, manifestContent);
    }

    private Set<String> getImportedPackages() {
        Iterable actionServices;
        boolean _notEquals;
        Object[] _services = CoreActivator.actionServiceTracker.getServices();
        Iterable _filter = null;
        if ((Iterable)Conversions.doWrapArray((Object)_services) != null) {
            _filter = Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_services)), ActionService.class);
        }
        boolean bl = _notEquals = !Objects.equal(actionServices = _filter, null);
        if (_notEquals) {
            Functions.Function1<ActionService, String> _function = new Functions.Function1<ActionService, String>(){

                public String apply(ActionService it) {
                    Class _actionClass = it.getActionClass();
                    Package _package = _actionClass.getPackage();
                    return _package.getName();
                }
            };
            Iterable _map = IterableExtensions.map((Iterable)actionServices, (Functions.Function1)_function);
            return IterableExtensions.toSet((Iterable)_map);
        }
        return Collections.emptySet();
    }

    private void createBuildProps(IProject project) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"bin.includes = META-INF/,\\");
        _builder.newLine();
        _builder.append((Object)"               ");
        _builder.append((Object)".");
        _builder.newLine();
        String buildPropertiesContent = _builder.toString();
        this.createFile("build.properties", (IContainer)project, buildPropertiesContent);
    }

    public IFile createFile(String name, IContainer container, String content) {
        try {
            Path _path = new Path(name);
            IFile file = container.getFile((IPath)_path);
            String _charset = file.getCharset();
            byte[] _bytes = content.getBytes(_charset);
            ByteArrayInputStream stream = new ByteArrayInputStream(_bytes);
            boolean _exists = file.exists();
            if (_exists) {
                file.setContents((InputStream)stream, true, true, null);
            } else {
                file.create((InputStream)stream, true, null);
            }
            ((InputStream)stream).close();
            return file;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void assertExist(IContainer c) {
        try {
            boolean _not;
            boolean _exists = c.exists();
            boolean bl = _not = !_exists;
            if (_not) {
                boolean _not_1;
                IContainer _parent = c.getParent();
                boolean _exists_1 = _parent.exists();
                boolean bl2 = _not_1 = !_exists_1;
                if (_not_1) {
                    IContainer _parent_1 = c.getParent();
                    this.assertExist(_parent_1);
                }
                if (c instanceof IFolder) {
                    ((IFolder)c).create(false, true, null);
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

