/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.core.internal;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.smarthome.model.core.EventType;
import org.eclipse.smarthome.model.core.ModelRepository;
import org.eclipse.smarthome.model.core.ModelRepositoryChangeListener;
import org.eclipse.xtext.resource.SynchronizedXtextResourceSet;
import org.eclipse.xtext.resource.XtextResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelRepositoryImpl
implements ModelRepository {
    private final Logger logger = LoggerFactory.getLogger(ModelRepositoryImpl.class);
    private final ResourceSet resourceSet;
    private final List<ModelRepositoryChangeListener> listeners = new CopyOnWriteArrayList<ModelRepositoryChangeListener>();

    public ModelRepositoryImpl() {
        SynchronizedXtextResourceSet xtextResourceSet = new SynchronizedXtextResourceSet();
        xtextResourceSet.addLoadOption((Object)XtextResource.OPTION_RESOLVE_ALL, (Object)Boolean.TRUE);
        this.resourceSet = xtextResourceSet;
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().remove("*");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EObject getModel(String name) {
        ResourceSet resourceSet = this.resourceSet;
        synchronized (resourceSet) {
            block5: {
                Resource resource = this.getResource(name);
                if (resource == null) break block5;
                if (resource.getContents().size() > 0) {
                    return (EObject)resource.getContents().get(0);
                }
                this.logger.warn("Configuration model '{}' is either empty or cannot be parsed correctly!", (Object)name);
                this.resourceSet.getResources().remove((Object)resource);
                return null;
            }
            this.logger.trace("Configuration model '{}' can not be found", (Object)name);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean addOrRefreshModel(String name, InputStream inputStream) {
        Resource resource = this.getResource(name);
        if (resource == null) {
            ResourceSet resourceSet = this.resourceSet;
            synchronized (resourceSet) {
                resource = this.getResource(name);
                if (resource != null) return false;
                resource = this.resourceSet.createResource(URI.createURI((String)name));
                if (resource == null) return false;
                this.logger.info("Loading model '{}'", (Object)name);
                try {
                    HashMap<String, String> options = new HashMap<String, String>();
                    options.put(XtextResource.OPTION_ENCODING, "UTF-8");
                    if (inputStream == null) {
                        this.logger.warn("Resource '{}' not found. You have to pass an inputStream to create the resource.", (Object)name);
                        return false;
                    }
                    resource.load(inputStream, options);
                    this.notifyListeners(name, EventType.ADDED);
                    return true;
                }
                catch (IOException e) {
                    this.logger.warn("Configuration model '" + name + "' cannot be parsed correctly!", (Throwable)e);
                    this.resourceSet.getResources().remove((Object)resource);
                }
                return false;
            }
        }
        ResourceSet resourceSet = this.resourceSet;
        synchronized (resourceSet) {
            resource.unload();
            try {
                this.logger.info("Refreshing model '{}'", (Object)name);
                if (inputStream != null) {
                    resource.load(inputStream, Collections.EMPTY_MAP);
                } else {
                    resource.load(Collections.EMPTY_MAP);
                }
                this.notifyListeners(name, EventType.MODIFIED);
                return true;
            }
            catch (IOException e) {
                this.logger.warn("Configuration model '" + name + "' cannot be parsed correctly!", (Throwable)e);
                this.resourceSet.getResources().remove((Object)resource);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeModel(String name) {
        Resource resource = this.getResource(name);
        if (resource != null) {
            ResourceSet resourceSet = this.resourceSet;
            synchronized (resourceSet) {
                this.notifyListeners(name, EventType.REMOVED);
                this.resourceSet.getResources().remove((Object)resource);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<String> getAllModelNamesOfType(final String modelType) {
        ResourceSet resourceSet = this.resourceSet;
        synchronized (resourceSet) {
            ArrayList resourceListCopy = new ArrayList(this.resourceSet.getResources());
            Iterable matchingResources = Iterables.filter(resourceListCopy, (Predicate)new Predicate<Resource>(){

                public boolean apply(Resource input) {
                    if (input != null && input.getURI().lastSegment().contains(".") && input.isLoaded()) {
                        return modelType.equalsIgnoreCase(input.getURI().fileExtension());
                    }
                    return false;
                }
            });
            return Lists.newArrayList((Iterable)Iterables.transform((Iterable)matchingResources, (Function)new Function<Resource, String>(){

                public String apply(Resource from) {
                    return from.getURI().path();
                }
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reloadAllModelsOfType(String modelType) {
        ResourceSet resourceSet = this.resourceSet;
        synchronized (resourceSet) {
            ArrayList resourceListCopy = new ArrayList(this.resourceSet.getResources());
            for (Resource resource : resourceListCopy) {
                if (resource == null || !resource.getURI().lastSegment().contains(".") || !resource.isLoaded() || !modelType.equalsIgnoreCase(resource.getURI().fileExtension())) continue;
                XtextResource xtextResource = (XtextResource)resource;
                xtextResource.update(1, 0, "");
            }
        }
    }

    @Override
    public void addModelRepositoryChangeListener(ModelRepositoryChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeModelRepositoryChangeListener(ModelRepositoryChangeListener listener) {
        this.listeners.remove(listener);
    }

    private Resource getResource(String name) {
        return this.resourceSet.getResource(URI.createURI((String)name), false);
    }

    private void notifyListeners(String name, EventType type) {
        for (ModelRepositoryChangeListener listener : this.listeners) {
            listener.modelChanged(name, type);
        }
    }
}

