/*
 * generated by Xtext
 */
package org.eclipse.smarthome.model.rule.ui.contentassist

import com.google.inject.Inject
import org.eclipse.emf.ecore.EObject
import org.eclipse.smarthome.core.items.Item
import org.eclipse.smarthome.core.types.Command
import org.eclipse.smarthome.core.types.State
import org.eclipse.smarthome.model.rule.ui.internal.RuleModelUIActivator
import org.eclipse.smarthome.model.script.scoping.StateAndCommandProvider
import org.eclipse.xtext.RuleCall
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor

/**
 * see http://www.eclipse.org/Xtext/documentation.html#contentAssist on how to customize content assistant
 */
class RulesProposalProvider extends AbstractRulesProposalProvider {

	
	@Inject
	StateAndCommandProvider stateAndCommandProvider
	
	override void complete_ItemName(EObject model, RuleCall ruleCall,
			ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		super.complete_ItemName(model, ruleCall, context, acceptor);
		val itemRegistry = RuleModelUIActivator.itemRegistryTracker.getService();
		
		for(Item item : itemRegistry.getItems()) {
			if(item.getName().startsWith(context.getPrefix())) {
				acceptor.accept(createCompletionProposal(item.getName(), context));
			}
		}
	}
	
	override void complete_ValidState(EObject model, RuleCall ruleCall,
			ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		super.complete_ValidState(model, ruleCall, context, acceptor);
		for(State state : stateAndCommandProvider.getAllStates()) {
			if(state.toString().startsWith(context.getPrefix())) {
				acceptor.accept(createCompletionProposal(state.toString(), context));
			}
		}
	}

	override void complete_ValidCommand(EObject model, RuleCall ruleCall,
			ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		super.complete_ValidState(model, ruleCall, context, acceptor);
		for(Command command : stateAndCommandProvider.getAllCommands()) {
			if(command.toString().startsWith(context.getPrefix())) {
				acceptor.accept(createCompletionProposal(command.toString(), context));
			}
		}
	}
}
