/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.script.jvmmodel;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.types.Type;
import org.eclipse.smarthome.model.script.engine.IItemRegistryProvider;
import org.eclipse.smarthome.model.script.scoping.StateAndCommandProvider;
import org.eclipse.smarthome.model.script.script.Script;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.jvmmodel.AbstractModelInferrer;
import org.eclipse.xtext.xbase.jvmmodel.IJvmDeclaredTypeAcceptor;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypesBuilder;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptJvmModelInferrer
extends AbstractModelInferrer {
    private static final Logger logger = LoggerFactory.getLogger(ScriptJvmModelInferrer.class);
    @Inject
    @Extension
    private JvmTypesBuilder _jvmTypesBuilder;
    @Inject
    private IItemRegistryProvider itemRegistryProvider;
    @Inject
    private StateAndCommandProvider stateAndCommandProvider;

    protected void _infer(final Script script, IJvmDeclaredTypeAcceptor acceptor, boolean isPreIndexingPhase) {
        Resource _eResource = script.eResource();
        URI _uRI = _eResource.getURI();
        String _lastSegment = _uRI.lastSegment();
        String[] _split = _lastSegment.split("\\.");
        String _head = (String)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)_split)));
        String _firstUpper = StringExtensions.toFirstUpper((String)_head);
        String className = String.valueOf(_firstUpper) + "Script";
        JvmGenericType _class = this._jvmTypesBuilder.toClass((EObject)script, className);
        IJvmDeclaredTypeAcceptor.IPostIndexingInitializing _accept = acceptor.accept((JvmDeclaredType)_class);
        Procedures.Procedure1<JvmGenericType> _function = new Procedures.Procedure1<JvmGenericType>(){

            public void apply(final JvmGenericType it) {
                final HashSet fieldNames = CollectionLiterals.newHashSet((Object[])new String[0]);
                Iterable<Type> types = ScriptJvmModelInferrer.this.stateAndCommandProvider.getAllTypes();
                Procedures.Procedure1<Type> _function = new Procedures.Procedure1<Type>(){

                    public void apply(Type type) {
                        String name = type.toString();
                        boolean _add = fieldNames.add(name);
                        if (_add) {
                            EList _members = it.getMembers();
                            Class<?> _class = type.getClass();
                            JvmTypeReference _newTypeRef = ScriptJvmModelInferrer.this._jvmTypesBuilder.newTypeRef((EObject)script, _class, new JvmTypeReference[0]);
                            Procedures.Procedure1<JvmField> _function = new Procedures.Procedure1<JvmField>(){

                                public void apply(JvmField it) {
                                    it.setStatic(true);
                                }
                            };
                            JvmField _field = ScriptJvmModelInferrer.this._jvmTypesBuilder.toField((EObject)script, name, _newTypeRef, (Procedures.Procedure1)_function);
                            ScriptJvmModelInferrer.this._jvmTypesBuilder.operator_add(_members, (Object)_field);
                        } else {
                            Class<?> _class_1 = type.getClass();
                            String _name = _class_1.getName();
                            logger.warn("Duplicate field: '{}'. Ignoring '{}'.", (Object)name, (Object)_name);
                        }
                    }
                };
                IterableExtensions.forEach(types, (Procedures.Procedure1)_function);
                ItemRegistry itemRegistry = (ItemRegistry)ScriptJvmModelInferrer.this.itemRegistryProvider.get();
                Collection _items = null;
                if (itemRegistry != null) {
                    _items = itemRegistry.getItems();
                }
                if (_items != null) {
                    Procedures.Procedure1<Item> _function_1 = new Procedures.Procedure1<Item>(){

                        public void apply(Item item) {
                            String name = item.getName();
                            boolean _add = fieldNames.add(name);
                            if (_add) {
                                EList _members = it.getMembers();
                                String _name = item.getName();
                                Class<?> _class = item.getClass();
                                JvmTypeReference _newTypeRef = ScriptJvmModelInferrer.this._jvmTypesBuilder.newTypeRef((EObject)script, _class, new JvmTypeReference[0]);
                                Procedures.Procedure1<JvmField> _function = new Procedures.Procedure1<JvmField>(){

                                    public void apply(JvmField it) {
                                        it.setStatic(true);
                                    }
                                };
                                JvmField _field = ScriptJvmModelInferrer.this._jvmTypesBuilder.toField((EObject)script, _name, _newTypeRef, (Procedures.Procedure1)_function);
                                ScriptJvmModelInferrer.this._jvmTypesBuilder.operator_add(_members, (Object)_field);
                            } else {
                                String _name_1 = item.getName();
                                Class<?> _class_1 = item.getClass();
                                String _name_2 = _class_1.getName();
                                logger.warn("Duplicate field: '{}'. Ignoring '{}'.", (Object)_name_1, (Object)_name_2);
                            }
                        }
                    };
                    IterableExtensions.forEach((Iterable)_items, (Procedures.Procedure1)_function_1);
                }
                EList _members = it.getMembers();
                Procedures.Procedure1<JvmOperation> _function_2 = new Procedures.Procedure1<JvmOperation>(){

                    public void apply(JvmOperation it) {
                        it.setStatic(true);
                        ScriptJvmModelInferrer.this._jvmTypesBuilder.setBody((JvmExecutable)it, (XExpression)script);
                    }
                };
                JvmOperation _method = ScriptJvmModelInferrer.this._jvmTypesBuilder.toMethod((EObject)script, "_script", null, (Procedures.Procedure1)_function_2);
                ScriptJvmModelInferrer.this._jvmTypesBuilder.operator_add(_members, (Object)_method);
            }
        };
        _accept.initializeLater((Procedures.Procedure1)_function);
    }

    public void infer(EObject script, IJvmDeclaredTypeAcceptor acceptor, boolean isPreIndexingPhase) {
        if (script instanceof Script) {
            this._infer((Script)script, acceptor, isPreIndexingPhase);
            return;
        }
        if (script != null) {
            this._infer(script, acceptor, isPreIndexingPhase);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(script, acceptor, isPreIndexingPhase).toString());
    }
}

