/**
 * generated by Xtext
 */
package org.eclipse.smarthome.model.thing.validation;

import com.google.common.base.Objects;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.model.thing.thing.ModelThing;
import org.eclipse.smarthome.model.thing.thing.ThingPackage;
import org.eclipse.smarthome.model.thing.validation.AbstractThingValidator;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * Custom validation rules.
 * 
 * see http://www.eclipse.org/Xtext/documentation.html#validation
 */
@SuppressWarnings("all")
public class ThingValidator extends AbstractThingValidator {
  public final static String INVALID_NAME = "invalidName";
  
  @Check
  public ThingUID check_thing_has_valid_id(final ModelThing thing) {
    ThingUID _xifexpression = null;
    boolean _isNested = this.isNested(thing);
    if (_isNested) {
      boolean _eIsSet = thing.eIsSet(ThingPackage.Literals.MODEL_THING__THING_TYPE_ID);
      boolean _not = (!_eIsSet);
      if (_not) {
        boolean _eIsSet_1 = thing.eIsSet(ThingPackage.Literals.MODEL_PROPERTY_CONTAINER__ID);
        if (_eIsSet_1) {
          this.error("Provide a thing type ID and a thing ID in this format:\n <thingTypeId> <thingId>", ThingPackage.Literals.MODEL_PROPERTY_CONTAINER__ID);
        } else {
          boolean _eIsSet_2 = thing.eIsSet(ThingPackage.Literals.MODEL_BRIDGE__BRIDGE);
          if (_eIsSet_2) {
            this.error("Provide a thing type ID and a thing ID in this format:\n <thingTypeId> <thingId>", ThingPackage.Literals.MODEL_BRIDGE__BRIDGE);
          }
        }
      } else {
        boolean _eIsSet_3 = thing.eIsSet(ThingPackage.Literals.MODEL_THING__THING_ID);
        boolean _not_1 = (!_eIsSet_3);
        if (_not_1) {
          this.error("Provide a thing type ID and a thing ID in this format:\n <thingTypeId> <thingId>", ThingPackage.Literals.MODEL_THING__THING_TYPE_ID);
        }
      }
    } else {
      ThingUID _xifexpression_1 = null;
      boolean _and = false;
      boolean _eIsSet_4 = thing.eIsSet(ThingPackage.Literals.MODEL_THING__THING_TYPE_ID);
      if (!_eIsSet_4) {
        _and = false;
      } else {
        boolean _eIsSet_5 = thing.eIsSet(ThingPackage.Literals.MODEL_THING__THING_ID);
        _and = _eIsSet_5;
      }
      if (_and) {
        List<INode> _findNodesForFeature = NodeModelUtils.findNodesForFeature(thing, ThingPackage.Literals.MODEL_THING__THING_TYPE_ID);
        final INode thingTypeIdFeature = IterableExtensions.<INode>head(_findNodesForFeature);
        List<INode> _findNodesForFeature_1 = NodeModelUtils.findNodesForFeature(thing, ThingPackage.Literals.MODEL_THING__THING_ID);
        final INode thingIdFeature = IterableExtensions.<INode>head(_findNodesForFeature_1);
        final int startOffset = thingTypeIdFeature.getOffset();
        final int endOffset = thingIdFeature.getEndOffset();
        ValidationMessageAcceptor _messageAcceptor = this.getMessageAcceptor();
        _messageAcceptor.acceptError("Provide a thing UID in this format:\n <bindingId>:<thingTypeId>:<thingId>", thing, startOffset, (endOffset - startOffset), null, null);
      } else {
        ThingUID _xifexpression_2 = null;
        String _id = thing.getId();
        boolean _notEquals = (!Objects.equal(_id, null));
        if (_notEquals) {
          ThingUID _xtrycatchfinallyexpression = null;
          try {
            String _id_1 = thing.getId();
            _xtrycatchfinallyexpression = new ThingUID(_id_1);
          } catch (final Throwable _t) {
            if (_t instanceof IllegalArgumentException) {
              final IllegalArgumentException e = (IllegalArgumentException)_t;
              String _message = e.getMessage();
              this.error(_message, ThingPackage.Literals.MODEL_PROPERTY_CONTAINER__ID);
            } else {
              throw Exceptions.sneakyThrow(_t);
            }
          }
          _xifexpression_2 = _xtrycatchfinallyexpression;
        }
        _xifexpression_1 = _xifexpression_2;
      }
      _xifexpression = _xifexpression_1;
    }
    return _xifexpression;
  }
  
  private boolean isNested(final ModelThing thing) {
    EStructuralFeature _eContainingFeature = thing.eContainingFeature();
    return Objects.equal(_eContainingFeature, ThingPackage.Literals.MODEL_BRIDGE__THINGS);
  }
}
