/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.classic.internal.render;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.model.sitemap.Widget;
import org.eclipse.smarthome.ui.classic.internal.WebAppActivator;
import org.eclipse.smarthome.ui.classic.internal.WebAppConfig;
import org.eclipse.smarthome.ui.classic.render.RenderException;
import org.eclipse.smarthome.ui.classic.render.WidgetRenderer;
import org.eclipse.smarthome.ui.items.ItemUIRegistry;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWidgetRenderer
implements WidgetRenderer {
    private final Logger logger = LoggerFactory.getLogger(AbstractWidgetRenderer.class);
    protected WebAppConfig config;
    protected ItemUIRegistry itemUIRegistry;
    protected static final String SNIPPET_EXT = ".html";
    protected static final String SNIPPET_LOCATION = "snippets/";
    protected static final Map<String, String> snippetCache = new HashMap<String, String>();

    public void setItemUIRegistry(ItemUIRegistry itemUIRegistry) {
        this.itemUIRegistry = itemUIRegistry;
    }

    public void unsetItemUIRegistry(ItemUIRegistry itemUIRegistry) {
        this.itemUIRegistry = null;
    }

    public ItemUIRegistry getItemUIRegistry() {
        return this.itemUIRegistry;
    }

    protected void activate(ComponentContext context) {
    }

    protected void deactivate(ComponentContext context) {
    }

    protected synchronized String getSnippet(String elementType) throws RenderException {
        String snippet = snippetCache.get(elementType = elementType.toLowerCase());
        if (snippet == null) {
            String snippetLocation = SNIPPET_LOCATION + elementType + SNIPPET_EXT;
            URL entry = WebAppActivator.getContext().getBundle().getEntry(snippetLocation);
            if (entry != null) {
                try {
                    snippet = IOUtils.toString((InputStream)entry.openStream());
                    if (!this.config.isHtmlCacheDisabled()) {
                        snippetCache.put(elementType, snippet);
                    }
                }
                catch (IOException e) {
                    this.logger.warn("Cannot load snippet for element type '{}'", (Object)elementType, (Object)e);
                }
            } else {
                throw new RenderException("Cannot find a snippet for element type '" + elementType + "'");
            }
        }
        return snippet;
    }

    public String getLabel(Widget w) {
        String label = this.itemUIRegistry.getLabel(w);
        int index = label.indexOf(91);
        if (index != -1) {
            label = "<span style=\"%labelstyle%\" class=\"iLabel\">" + label.substring(0, index) + "</span>" + label.substring(index);
            label = label.replaceAll("\\[", "<span class=\"iValue\" style=\"%valuestyle%\">").replaceAll("\\]", "</span>");
        } else {
            label = "<span style=\"%labelstyle%\" class=\"iLabel\">" + label + "</span>";
        }
        return label;
    }

    protected String escapeURLPath(String path) {
        try {
            return new URI(null, null, path, null).toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            this.logger.warn("Cannot escape path '{}' in URL. Returning unmodified path.", (Object)path);
            return path;
        }
    }

    protected String processColor(Widget w, String snippet) {
        String style = "";
        String color = this.itemUIRegistry.getLabelColor(w);
        if (color != null) {
            style = "color:" + color;
        }
        snippet = StringUtils.replace((String)snippet, (String)"%labelstyle%", (String)style);
        style = "";
        color = this.itemUIRegistry.getValueColor(w);
        if (color != null) {
            style = "color:" + color;
        }
        snippet = StringUtils.replace((String)snippet, (String)"%valuestyle%", (String)style);
        return snippet;
    }

    protected String getFormat() {
        return this.config.getIconType();
    }

    protected String getState(Widget w) {
        State state = this.itemUIRegistry.getState(w);
        if (state != null) {
            return this.escapeURLPath(state.toString());
        }
        return "NULL";
    }

    protected String getStateAsNumber(Widget w) {
        String itemName = w.getItem();
        if (itemName != null) {
            try {
                Item item = this.itemUIRegistry.getItem(itemName);
                if (item.getAcceptedDataTypes().contains(PercentType.class)) {
                    return this.escapeURLPath(item.getStateAs(PercentType.class).toString());
                }
                return this.escapeURLPath(item.getStateAs(DecimalType.class).toString());
            }
            catch (ItemNotFoundException itemNotFoundException) {
                this.logger.error("Cannot retrieve item '{}' for widget {}", new Object[]{itemName, w.eClass().getInstanceTypeName()});
            }
        }
        return "NULL";
    }

    protected String getCategory(Widget w) {
        String icon = this.escapeURLPath(this.itemUIRegistry.getCategory(w));
        return icon;
    }

    @Override
    public void setConfig(WebAppConfig config) {
        this.config = config;
    }
}

