/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.classic.internal.servlet;

import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.items.StateChangeListener;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.model.sitemap.Frame;
import org.eclipse.smarthome.model.sitemap.LinkableWidget;
import org.eclipse.smarthome.model.sitemap.Sitemap;
import org.eclipse.smarthome.model.sitemap.SitemapProvider;
import org.eclipse.smarthome.model.sitemap.Widget;
import org.eclipse.smarthome.ui.classic.internal.WebAppConfig;
import org.eclipse.smarthome.ui.classic.internal.render.PageRenderer;
import org.eclipse.smarthome.ui.classic.internal.servlet.BaseServlet;
import org.eclipse.smarthome.ui.classic.render.RenderException;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAppServlet
extends BaseServlet {
    private final Logger logger = LoggerFactory.getLogger(WebAppServlet.class);
    private static final long TIMEOUT_IN_MS = 30000L;
    public static final String SERVLET_NAME = "app";
    private PageRenderer renderer;
    protected Set<SitemapProvider> sitemapProviders = new CopyOnWriteArraySet<SitemapProvider>();
    private WebAppConfig config = new WebAppConfig();

    public void addSitemapProvider(SitemapProvider sitemapProvider) {
        this.sitemapProviders.add(sitemapProvider);
    }

    public void removeSitemapProvider(SitemapProvider sitemapProvider) {
        this.sitemapProviders.remove(sitemapProvider);
    }

    public void setPageRenderer(PageRenderer renderer) {
        renderer.setConfig(this.config);
        this.renderer = renderer;
    }

    protected void activate(Map<String, Object> configProps) {
        this.config.applyConfig(configProps);
        try {
            Hashtable props = new Hashtable();
            this.httpService.registerServlet("/classicui/app", (Servlet)this, props, this.createHttpContext());
            this.httpService.registerResources("/classicui", "web", null);
            this.logger.info("Started Classic UI at /classicui/app");
        }
        catch (NamespaceException e) {
            this.logger.error("Error during servlet startup", (Throwable)e);
        }
        catch (ServletException e) {
            this.logger.error("Error during servlet startup", (Throwable)e);
        }
    }

    protected void modified(Map<String, Object> configProps) {
        this.config.applyConfig(configProps);
    }

    protected void deactivate() {
        this.httpService.unregister("/classicui/app");
        this.httpService.unregister("/classicui");
        this.logger.info("Stopped Classic UI");
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        this.logger.debug("Servlet request received!");
        String sitemapName = req.getParameter("sitemap");
        String widgetId = req.getParameter("w");
        boolean async = "true".equalsIgnoreCase(req.getParameter("__async"));
        boolean poll = "true".equalsIgnoreCase(req.getParameter("poll"));
        if (sitemapName == null) {
            sitemapName = this.config.getDefaultSitemap();
        }
        StringBuilder result = new StringBuilder();
        Sitemap sitemap = null;
        for (SitemapProvider sitemapProvider : this.sitemapProviders) {
            sitemap = sitemapProvider.getSitemap(sitemapName);
            if (sitemap != null) break;
        }
        try {
            Widget w;
            if (sitemap == null) {
                throw new RenderException("Sitemap '" + sitemapName + "' could not be found");
            }
            this.logger.debug("reading sitemap {}", (Object)sitemap.getName());
            if (widgetId == null || widgetId.isEmpty() || widgetId.equals("Home")) {
                String label = sitemap.getLabel() != null ? sitemap.getLabel() : sitemapName;
                EList children = sitemap.getChildren();
                if (poll && !this.waitForChanges((EList<Widget>)children)) {
                    res.getWriter().append(this.getTimeoutResponse()).close();
                    return;
                }
                result.append((CharSequence)this.renderer.processPage("Home", sitemapName, label, (EList<Widget>)sitemap.getChildren(), async));
            } else if (!widgetId.equals("Colorpicker") && (w = this.renderer.getItemUIRegistry().getWidget(sitemap, widgetId)) != null) {
                String label = this.renderer.getItemUIRegistry().getLabel(w);
                if (label == null) {
                    label = "undefined";
                }
                if (!(w instanceof LinkableWidget)) {
                    throw new RenderException("Widget '" + w + "' can not have any content");
                }
                EList children = this.renderer.getItemUIRegistry().getChildren((LinkableWidget)w);
                if (poll && !this.waitForChanges((EList<Widget>)children)) {
                    res.getWriter().append(this.getTimeoutResponse()).close();
                    return;
                }
                result.append((CharSequence)this.renderer.processPage(this.renderer.getItemUIRegistry().getWidgetId(w), sitemapName, label, (EList<Widget>)children, async));
            }
        }
        catch (RenderException e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        if (async) {
            res.setContentType("application/xml;charset=UTF-8");
        } else {
            res.setContentType("text/html;charset=UTF-8");
        }
        res.getWriter().append(result);
        res.getWriter().close();
    }

    private String getTimeoutResponse() {
        return "<root><part><destination mode=\"replace\" zone=\"timeout\" create=\"false\"/><data/></part></root>";
    }

    private boolean waitForChanges(EList<Widget> widgets) {
        long startTime = new Date().getTime();
        boolean timeout = false;
        BlockingStateChangeListener listener = new BlockingStateChangeListener();
        Set<GenericItem> items = this.getAllItems(widgets);
        for (GenericItem item : items) {
            item.addStateChangeListener((StateChangeListener)listener);
        }
        while (!listener.hasChangeOccurred() && !timeout) {
            timeout = new Date().getTime() - startTime > 30000L;
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {
                timeout = true;
                break;
            }
        }
        for (GenericItem item : items) {
            item.removeStateChangeListener((StateChangeListener)listener);
        }
        return !timeout;
    }

    private Set<GenericItem> getAllItems(EList<Widget> widgets) {
        HashSet<GenericItem> items = new HashSet<GenericItem>();
        if (this.itemRegistry != null) {
            for (Widget widget : widgets) {
                String itemName = widget.getItem();
                if (itemName != null) {
                    try {
                        Item item = this.itemRegistry.getItem(itemName);
                        if (!(item instanceof GenericItem)) continue;
                        GenericItem gItem = (GenericItem)item;
                        items.add(gItem);
                    }
                    catch (ItemNotFoundException itemNotFoundException) {}
                    continue;
                }
                if (!(widget instanceof Frame)) continue;
                items.addAll(this.getAllItems((EList<Widget>)((Frame)widget).getChildren()));
            }
        }
        return items;
    }

    private static class BlockingStateChangeListener
    implements StateChangeListener {
        private boolean changed = false;

        private BlockingStateChangeListener() {
        }

        public void stateChanged(Item item, State oldState, State newState) {
            this.changed = true;
        }

        public boolean hasChangeOccurred() {
            return this.changed;
        }

        public void stateUpdated(Item item, State state) {
        }
    }
}

