/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.internal.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Hashtable;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.eclipse.smarthome.model.core.ModelRepository;
import org.eclipse.smarthome.model.sitemap.Image;
import org.eclipse.smarthome.model.sitemap.Sitemap;
import org.eclipse.smarthome.model.sitemap.Video;
import org.eclipse.smarthome.model.sitemap.Widget;
import org.eclipse.smarthome.ui.items.ItemUIRegistry;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyServlet
extends HttpServlet {
    public static final String PROXY_ALIAS = "proxy";
    private final Logger logger = LoggerFactory.getLogger(ProxyServlet.class);
    private static final long serialVersionUID = -4716754591953017793L;
    protected HttpService httpService;
    protected ItemUIRegistry itemUIRegistry;
    protected ModelRepository modelRepository;

    protected void setItemUIRegistry(ItemUIRegistry itemUIRegistry) {
        this.itemUIRegistry = itemUIRegistry;
    }

    protected void unsetItemUIRegistry(ItemUIRegistry itemUIRegistry) {
        this.itemUIRegistry = null;
    }

    protected void setModelRepository(ModelRepository modelRepository) {
        this.modelRepository = modelRepository;
    }

    protected void unsetModelRepository(ModelRepository modelRepository) {
        this.modelRepository = null;
    }

    protected void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    protected void unsetHttpService(HttpService httpService) {
        this.httpService = null;
    }

    protected void activate() {
        try {
            this.logger.debug("Starting up proxy servlet at /proxy");
            Hashtable props = new Hashtable();
            this.httpService.registerServlet("/proxy", (Servlet)this, props, this.createHttpContext());
        }
        catch (NamespaceException e) {
            this.logger.error("Error during servlet startup: {}", (Object)e.getMessage());
        }
        catch (ServletException e) {
            this.logger.error("Error during servlet startup: {}", (Object)e.getMessage());
        }
    }

    protected void deactivate() {
        this.httpService.unregister("/proxy");
    }

    protected HttpContext createHttpContext() {
        HttpContext defaultHttpContext = this.httpService.createDefaultHttpContext();
        return defaultHttpContext;
    }

    public String getServletInfo() {
        return "Image and Video Widget Proxy";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String sitemapName = request.getParameter("sitemap");
        String widgetId = request.getParameter("widgetId");
        if (sitemapName == null) {
            throw new ServletException("Parameter 'sitemap' must be provided!");
        }
        if (widgetId == null) {
            throw new ServletException("Parameter 'widget' must be provided!");
        }
        String uriString = null;
        Sitemap sitemap = (Sitemap)this.modelRepository.getModel(sitemapName);
        if (sitemap == null) throw new ServletException("Sitemap '" + sitemapName + "' could not be found!");
        Widget widget = this.itemUIRegistry.getWidget(sitemap, widgetId);
        if (widget instanceof Image) {
            Image image = (Image)widget;
            uriString = image.getUrl();
        } else if (widget instanceof Video) {
            Video video = (Video)widget;
            uriString = video.getUrl();
        } else {
            if (widget != null) throw new ServletException("Widget type '" + widget.getClass().getName() + "' is not supported!");
            throw new ServletException("Widget '" + widgetId + "' could not be found!");
        }
        HttpClient httpClient = new HttpClient();
        try {
            URI uri = URI.create(uriString);
            if (uri.getUserInfo() != null) {
                String[] userInfo = uri.getUserInfo().split(":");
                httpClient.getParams().setAuthenticationPreemptive(true);
                UsernamePasswordCredentials creds = new UsernamePasswordCredentials(userInfo[0], userInfo[1]);
                httpClient.getState().setCredentials(new AuthScope(uri.getHost(), uri.getPort(), AuthScope.ANY_REALM), (Credentials)creds);
            }
        }
        catch (IllegalArgumentException e) {
            throw new ServletException("URI '" + uriString + "' is not valid: " + e.getMessage());
        }
        GetMethod method = new GetMethod(uriString);
        httpClient.executeMethod((HttpMethod)method);
        Header[] headerArray = method.getResponseHeaders();
        int n = headerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray[n2];
            response.setHeader(header.getName(), header.getValue());
            ++n2;
        }
        IOUtils.copy((InputStream)method.getResponseBodyAsStream(), (OutputStream)response.getOutputStream());
        method.releaseConnection();
    }
}

