/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.Condition;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.Visibility;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.common.registry.Identifiable;

@NonNullByDefault
public class Rule
implements Identifiable<String> {
    protected List<Trigger> triggers;
    protected List<Condition> conditions;
    protected List<Action> actions;
    protected Configuration configuration;
    protected List<ConfigDescriptionParameter> configDescriptions;
    protected @Nullable String templateUID;
    protected String uid;
    protected @Nullable String name;
    protected Set<String> tags;
    protected Visibility visibility;
    protected @Nullable String description;

    public Rule(@Nullable String uid) {
        this(uid, null, null, null, null, null, null, null);
    }

    public Rule(@Nullable String uid, @Nullable List<Trigger> triggers, @Nullable List<Condition> conditions, @Nullable List<Action> actions, @Nullable List<ConfigDescriptionParameter> configDescriptions, @Nullable Configuration configuration, @Nullable String templateUID, @Nullable Visibility visibility) {
        this.uid = uid == null ? UUID.randomUUID().toString() : uid;
        this.triggers = triggers == null ? new ArrayList() : triggers;
        this.conditions = conditions == null ? new ArrayList() : conditions;
        this.actions = actions == null ? new ArrayList() : actions;
        this.configDescriptions = configDescriptions == null ? new ArrayList() : configDescriptions;
        this.configuration = configuration == null ? new Configuration() : configuration;
        this.setTemplateUID(templateUID);
        this.visibility = visibility == null ? Visibility.VISIBLE : visibility;
        this.tags = new HashSet<String>();
    }

    public String getUID() {
        return this.uid;
    }

    public @Nullable String getTemplateUID() {
        return this.templateUID;
    }

    public void setTemplateUID(@Nullable String templateUID) {
        this.templateUID = templateUID;
    }

    public @Nullable String getName() {
        return this.name;
    }

    public void setName(@Nullable String ruleName) {
        this.name = ruleName;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void setTags(Set<String> ruleTags) {
        this.tags = ruleTags != null ? ruleTags : new HashSet();
    }

    public @Nullable String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String ruleDescription) {
        this.description = ruleDescription;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility == null ? Visibility.VISIBLE : visibility;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration ruleConfiguration) {
        this.configuration = ruleConfiguration == null ? new Configuration() : ruleConfiguration;
    }

    public List<ConfigDescriptionParameter> getConfigurationDescriptions() {
        return this.configDescriptions;
    }

    public void setConfigurationDescriptions(List<ConfigDescriptionParameter> configDescriptions) {
        this.configDescriptions = configDescriptions == null ? new ArrayList() : configDescriptions;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<Condition> conditions) {
        this.conditions = conditions == null ? new ArrayList() : conditions;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public void setActions(List<Action> actions) {
        this.actions = actions == null ? new ArrayList() : actions;
    }

    public List<Trigger> getTriggers() {
        return this.triggers;
    }

    public void setTriggers(List<Trigger> triggers) {
        this.triggers = triggers == null ? new ArrayList() : triggers;
    }

    public @Nullable Module getModule(String moduleId) {
        for (Module module : this.getModules(Module.class)) {
            if (!module.getId().equals(moduleId)) continue;
            return module;
        }
        return null;
    }

    public <T extends Module> List<T> getModules(Class<T> moduleClazz) {
        List<Module> result;
        if (Module.class == moduleClazz) {
            ArrayList<Module> modules = new ArrayList<Module>();
            modules.addAll(this.triggers);
            modules.addAll(this.conditions);
            modules.addAll(this.actions);
            result = Collections.unmodifiableList(modules);
        } else {
            result = Trigger.class == moduleClazz ? this.triggers : (Condition.class == moduleClazz ? this.conditions : (Action.class == moduleClazz ? this.actions : Collections.emptyList()));
        }
        return result;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.uid.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rule)) {
            return false;
        }
        Rule other = (Rule)obj;
        return this.uid.equals(other.uid);
    }
}

