/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.dto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.dto.ActionDTO;
import org.eclipse.smarthome.automation.dto.ModuleDTOMapper;
import org.eclipse.smarthome.config.core.Configuration;

public class ActionDTOMapper
extends ModuleDTOMapper {
    public static ActionDTO map(Action action) {
        ActionDTO actionDto = new ActionDTO();
        ActionDTOMapper.fillProperties(action, actionDto);
        actionDto.inputs = action.getInputs();
        return actionDto;
    }

    public static Action mapDto(ActionDTO actionDto) {
        Action action = new Action(actionDto.id, actionDto.type, new Configuration(actionDto.configuration), actionDto.inputs);
        action.setLabel(actionDto.label);
        action.setDescription(actionDto.description);
        return action;
    }

    public static List<ActionDTO> map(Collection<Action> actions) {
        if (actions == null) {
            return null;
        }
        ArrayList<ActionDTO> dtos = new ArrayList<ActionDTO>(actions.size());
        for (Action action : actions) {
            dtos.add(ActionDTOMapper.map(action));
        }
        return dtos;
    }

    public static List<Action> mapDto(Collection<ActionDTO> dtos) {
        if (dtos == null) {
            return null;
        }
        ArrayList<Action> actions = new ArrayList<Action>(dtos.size());
        for (ActionDTO dto : dtos) {
            actions.add(ActionDTOMapper.mapDto(dto));
        }
        return actions;
    }
}

