/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.core.handler;

import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.handler.BaseTriggerModuleHandler;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventFilter;
import org.eclipse.smarthome.core.events.EventSubscriber;
import org.eclipse.smarthome.core.items.events.GroupItemStateChangedEvent;
import org.eclipse.smarthome.core.items.events.ItemStateChangedEvent;
import org.eclipse.smarthome.core.items.events.ItemStateEvent;
import org.eclipse.smarthome.core.types.State;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemStateTriggerHandler
extends BaseTriggerModuleHandler
implements EventSubscriber,
EventFilter {
    private final Logger logger = LoggerFactory.getLogger(ItemStateTriggerHandler.class);
    private String itemName;
    private String state;
    private String previousState;
    private Set<String> types;
    private BundleContext bundleContext;
    public static final String UPDATE_MODULE_TYPE_ID = "core.ItemStateUpdateTrigger";
    public static final String CHANGE_MODULE_TYPE_ID = "core.ItemStateChangeTrigger";
    private static final String CFG_ITEMNAME = "itemName";
    private static final String CFG_STATE = "state";
    private static final String CFG_PREVIOUS_STATE = "previousState";
    private ServiceRegistration eventSubscriberRegistration;

    public ItemStateTriggerHandler(Trigger module, BundleContext bundleContext) {
        super(module);
        this.itemName = (String)module.getConfiguration().get(CFG_ITEMNAME);
        this.state = (String)module.getConfiguration().get(CFG_STATE);
        this.previousState = (String)module.getConfiguration().get(CFG_PREVIOUS_STATE);
        if (UPDATE_MODULE_TYPE_ID.equals(module.getTypeUID())) {
            this.types = Collections.singleton(ItemStateEvent.TYPE);
        } else {
            HashSet<String> set = new HashSet<String>();
            set.add(ItemStateChangedEvent.TYPE);
            set.add(GroupItemStateChangedEvent.TYPE);
            this.types = Collections.unmodifiableSet(set);
        }
        this.bundleContext = bundleContext;
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("event.topics", "smarthome/items/" + this.itemName + "/*");
        this.eventSubscriberRegistration = this.bundleContext.registerService(EventSubscriber.class.getName(), (Object)this, properties);
    }

    public Set<String> getSubscribedEventTypes() {
        return this.types;
    }

    public EventFilter getEventFilter() {
        return this;
    }

    public void receive(Event event) {
        if (this.ruleEngineCallback != null) {
            this.logger.trace("Received Event: Source: {} Topic: {} Type: {}  Payload: {}", new Object[]{event.getSource(), event.getTopic(), event.getType(), event.getPayload()});
            HashMap<String, Object> values = new HashMap<String, Object>();
            if (event instanceof ItemStateEvent && UPDATE_MODULE_TYPE_ID.equals(((Trigger)this.module).getTypeUID())) {
                State state = ((ItemStateEvent)event).getItemState();
                if (this.state == null || this.state.equals(state.toFullString())) {
                    values.put(CFG_STATE, state);
                }
            } else if (event instanceof ItemStateChangedEvent && CHANGE_MODULE_TYPE_ID.equals(((Trigger)this.module).getTypeUID())) {
                State state = ((ItemStateChangedEvent)event).getItemState();
                State oldState = ((ItemStateChangedEvent)event).getOldItemState();
                if (this.stateMatches(this.state, state) && this.stateMatches(this.previousState, oldState)) {
                    values.put("oldState", oldState);
                    values.put("newState", state);
                }
            }
            if (!values.isEmpty()) {
                values.put("event", event);
                this.ruleEngineCallback.triggered((Trigger)this.module, values);
            }
        }
    }

    private boolean stateMatches(String requiredState, State state) {
        if (requiredState == null) {
            return true;
        }
        String reqState = requiredState.trim();
        return reqState.isEmpty() || reqState.equals(state.toFullString());
    }

    public void dispose() {
        super.dispose();
        if (this.eventSubscriberRegistration != null) {
            this.eventSubscriberRegistration.unregister();
            this.eventSubscriberRegistration = null;
        }
    }

    public boolean apply(Event event) {
        this.logger.trace("->FILTER: {}:{}", (Object)event.getTopic(), (Object)this.itemName);
        return event.getTopic().contains("/" + this.itemName + "/");
    }
}

