/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.core.handler;

import java.util.List;
import java.util.Map;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.RuleRegistry;
import org.eclipse.smarthome.automation.handler.ActionHandler;
import org.eclipse.smarthome.automation.handler.BaseModuleHandler;
import org.eclipse.smarthome.config.core.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunRuleActionHandler
extends BaseModuleHandler<Action>
implements ActionHandler {
    public static final String UID = "core.RunRuleAction";
    private static final String RULE_UIDS_KEY = "ruleUIDs";
    private static final String CONSIDER_CONDITIONS_KEY = "considerConditions";
    private final Logger logger = LoggerFactory.getLogger(RunRuleActionHandler.class);
    private final List<String> ruleUIDs;
    private boolean considerConditions = true;
    private RuleRegistry ruleRegistry;

    public RunRuleActionHandler(Action module, RuleRegistry ruleRegistry) {
        super((Module)module);
        Configuration config = module.getConfiguration();
        if (config == null) {
            throw new IllegalArgumentException("'Configuration' can not be null.");
        }
        this.ruleUIDs = (List)config.get(RULE_UIDS_KEY);
        if (this.ruleUIDs == null) {
            throw new IllegalArgumentException("'ruleUIDs' property must not be null.");
        }
        if (config.get(CONSIDER_CONDITIONS_KEY) != null && config.get(CONSIDER_CONDITIONS_KEY) instanceof Boolean) {
            this.considerConditions = (Boolean)config.get(CONSIDER_CONDITIONS_KEY);
        }
        this.ruleRegistry = ruleRegistry;
    }

    public Map<String, Object> execute(Map<String, Object> context) {
        for (String uid : this.ruleUIDs) {
            if (this.ruleRegistry != null) {
                this.ruleRegistry.runNow(uid, this.considerConditions, context);
                continue;
            }
            this.logger.warn("Action is not applied to {} because RuleRegistry is not available.", (Object)uid);
        }
        return null;
    }
}

