/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.parser.gson.internal;

import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.smarthome.automation.Rule;
import org.eclipse.smarthome.automation.parser.ParsingException;
import org.eclipse.smarthome.automation.parser.ParsingNestedException;
import org.eclipse.smarthome.automation.parser.gson.internal.AbstractGSONParser;

public class RuleGSONParser
extends AbstractGSONParser<Rule> {
    public Set<Rule> parse(InputStreamReader reader) throws ParsingException {
        JsonReader jr = new JsonReader((Reader)reader);
        try {
            HashSet<Rule> rules = new HashSet<Rule>();
            if (jr.hasNext()) {
                JsonToken token = jr.peek();
                if (JsonToken.BEGIN_ARRAY.equals((Object)token)) {
                    rules.addAll((Collection)gson.fromJson(jr, new TypeToken<List<Rule>>(){}.getType()));
                } else {
                    Rule rule = (Rule)gson.fromJson(jr, Rule.class);
                    rules.add(rule);
                }
                HashSet<Rule> hashSet = rules;
                return hashSet;
            }
        }
        catch (Exception e) {
            throw new ParsingException(new ParsingNestedException(3, null, (Throwable)e));
        }
        finally {
            try {
                jr.close();
            }
            catch (IOException iOException) {}
        }
        return Collections.emptySet();
    }
}

