/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.astro.internal.job;

import org.eclipse.smarthome.binding.astro.handler.AstroThingHandler;
import org.eclipse.smarthome.binding.astro.internal.AstroHandlerFactory;
import org.eclipse.smarthome.binding.astro.internal.job.AbstractJob;
import org.eclipse.smarthome.binding.astro.internal.job.Job;
import org.eclipse.smarthome.binding.astro.internal.model.Planet;
import org.eclipse.smarthome.binding.astro.internal.model.Sun;
import org.eclipse.smarthome.binding.astro.internal.model.SunPhaseName;
import org.eclipse.smarthome.core.thing.Channel;

public final class SunPhaseJob
extends AbstractJob {
    private final SunPhaseName sunPhaseName;

    public SunPhaseJob(String thingUID, SunPhaseName sunPhaseName) {
        super(thingUID);
        SunPhaseJob.checkArgument(sunPhaseName != null, "The sunPhaseName must not be null");
        this.sunPhaseName = sunPhaseName;
    }

    @Override
    public void run() {
        AstroThingHandler astroHandler = AstroHandlerFactory.getHandler(this.getThingUID());
        if (Job.checkNull(astroHandler, "AstroThingHandler is null")) {
            return;
        }
        Channel phaseNameChannel = astroHandler.getThing().getChannel("phase#name");
        if (Job.checkNull(phaseNameChannel, "Phase Name Channel is null")) {
            return;
        }
        Planet planet = astroHandler.getPlanet();
        if (planet != null && planet instanceof Sun) {
            Sun typedSun = (Sun)planet;
            typedSun.getPhase().setName(this.sunPhaseName);
            astroHandler.publishChannelIfLinked(phaseNameChannel.getUID());
        }
    }

    public String toString() {
        return "Sun phase job " + this.getThingUID() + "/" + (Object)((Object)this.sunPhaseName);
    }
}

