/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.hue.handler;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.hue.HueBindingConstants;
import org.eclipse.smarthome.binding.hue.handler.LightStateConverter;
import org.eclipse.smarthome.binding.hue.handler.LightStatusListener;
import org.eclipse.smarthome.binding.hue.internal.Config;
import org.eclipse.smarthome.binding.hue.internal.FullConfig;
import org.eclipse.smarthome.binding.hue.internal.FullLight;
import org.eclipse.smarthome.binding.hue.internal.HueBridge;
import org.eclipse.smarthome.binding.hue.internal.State;
import org.eclipse.smarthome.binding.hue.internal.StateUpdate;
import org.eclipse.smarthome.binding.hue.internal.exceptions.ApiException;
import org.eclipse.smarthome.binding.hue.internal.exceptions.DeviceOffException;
import org.eclipse.smarthome.binding.hue.internal.exceptions.LinkButtonException;
import org.eclipse.smarthome.binding.hue.internal.exceptions.UnauthorizedException;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.config.core.status.ConfigStatusMessage;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.binding.ConfigStatusBridgeHandler;
import org.eclipse.smarthome.core.types.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class HueBridgeHandler
extends ConfigStatusBridgeHandler {
    private static final String LIGHT_STATE_ADDED = "added";
    private static final String LIGHT_STATE_CHANGED = "changed";
    public static final Set<ThingTypeUID> SUPPORTED_THING_TYPES = Collections.singleton(HueBindingConstants.THING_TYPE_BRIDGE);
    private static final int DEFAULT_POLLING_INTERVAL = 10;
    private static final String DEVICE_TYPE = "EclipseSmartHome";
    private final Logger logger = LoggerFactory.getLogger(HueBridgeHandler.class);
    private final Map<String, FullLight> lastLightStates = new ConcurrentHashMap<String, FullLight>();
    private boolean lastBridgeConnectionState = false;
    private boolean propertiesInitializedSuccessfully = false;
    private final List<LightStatusListener> lightStatusListeners = new CopyOnWriteArrayList<LightStatusListener>();
    private @Nullable ScheduledFuture<?> pollingJob;
    @NonNullByDefault(value={})
    private HueBridge hueBridge = null;
    private final Runnable pollingRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                try {
                    FullConfig fullConfig = HueBridgeHandler.this.hueBridge.getFullConfig();
                    if (!HueBridgeHandler.this.lastBridgeConnectionState) {
                        HueBridgeHandler.this.lastBridgeConnectionState = HueBridgeHandler.this.tryResumeBridgeConnection();
                    }
                    if (HueBridgeHandler.this.lastBridgeConnectionState) {
                        HashMap lastLightStateCopy = new HashMap(HueBridgeHandler.this.lastLightStates);
                        for (FullLight fullLight : fullConfig.getLights()) {
                            String lightId = fullLight.getId();
                            if (lastLightStateCopy.containsKey(lightId)) {
                                FullLight lastFullLight = (FullLight)lastLightStateCopy.remove(lightId);
                                State lastFullLightState = lastFullLight.getState();
                                HueBridgeHandler.this.lastLightStates.put(lightId, fullLight);
                                if (HueBridgeHandler.this.isEqual(lastFullLightState, fullLight.getState())) continue;
                                HueBridgeHandler.this.logger.debug("Status update for Hue light {} detected.", (Object)lightId);
                                HueBridgeHandler.this.notifyLightStatusListeners(fullLight, HueBridgeHandler.LIGHT_STATE_CHANGED);
                                continue;
                            }
                            HueBridgeHandler.this.lastLightStates.put(lightId, fullLight);
                            HueBridgeHandler.this.logger.debug("Hue light {} added.", (Object)lightId);
                            HueBridgeHandler.this.notifyLightStatusListeners(fullLight, HueBridgeHandler.LIGHT_STATE_ADDED);
                        }
                        for (Map.Entry entry : lastLightStateCopy.entrySet()) {
                            HueBridgeHandler.this.lastLightStates.remove(entry.getKey());
                            HueBridgeHandler.this.logger.debug("Hue light {} removed.", entry.getKey());
                            for (LightStatusListener lightStatusListener : HueBridgeHandler.this.lightStatusListeners) {
                                try {
                                    lightStatusListener.onLightRemoved(HueBridgeHandler.this.hueBridge, (FullLight)entry.getValue());
                                }
                                catch (Exception e) {
                                    HueBridgeHandler.this.logger.error("An exception occurred while calling the BridgeHeartbeatListener", (Throwable)e);
                                }
                            }
                        }
                    }
                }
                catch (IllegalStateException | UnauthorizedException e) {
                    if (this.isReachable(HueBridgeHandler.this.hueBridge.getIPAddress())) {
                        HueBridgeHandler.this.lastBridgeConnectionState = false;
                        HueBridgeHandler.this.onNotAuthenticated();
                    } else if (HueBridgeHandler.this.lastBridgeConnectionState || HueBridgeHandler.this.thing.getStatus() == ThingStatus.INITIALIZING) {
                        HueBridgeHandler.this.lastBridgeConnectionState = false;
                        HueBridgeHandler.this.onConnectionLost();
                    }
                }
                catch (Exception e) {
                    if (HueBridgeHandler.this.hueBridge != null && HueBridgeHandler.this.lastBridgeConnectionState) {
                        HueBridgeHandler.this.logger.debug("Connection to Hue Bridge {} lost.", (Object)HueBridgeHandler.this.hueBridge.getIPAddress());
                        HueBridgeHandler.this.lastBridgeConnectionState = false;
                        HueBridgeHandler.this.onConnectionLost();
                    }
                }
            }
            catch (Throwable t) {
                HueBridgeHandler.this.logger.error("An unexpected error occurred: {}", (Object)t.getMessage(), (Object)t);
            }
        }

        private boolean isReachable(String ipAddress) {
            try {
                HueBridgeHandler.this.hueBridge.authenticate("invalid");
            }
            catch (IOException e) {
                return false;
            }
            catch (ApiException e) {
                return !e.getMessage().contains("SocketTimeout") && !e.getMessage().contains("ConnectException") && !e.getMessage().contains("SocketException") && !e.getMessage().contains("NoRouteToHostException");
            }
            return true;
        }
    };

    public HueBridgeHandler(Bridge bridge) {
        super(bridge);
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
    }

    public void updateLightState(FullLight light, StateUpdate stateUpdate) {
        if (this.hueBridge != null) {
            try {
                this.hueBridge.setLightState(light, stateUpdate);
            }
            catch (DeviceOffException e) {
                this.updateLightState(light, LightStateConverter.toOnOffLightState(OnOffType.ON));
                this.updateLightState(light, stateUpdate);
            }
            catch (IOException e) {
                this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, e.getMessage());
            }
            catch (ApiException e) {
                this.logger.warn("Error while accessing light: {}", (Object)e.getMessage(), (Object)e);
            }
            catch (IllegalStateException e) {
                this.logger.trace("Error while accessing light: {}", (Object)e.getMessage());
            }
        } else {
            this.logger.warn("No bridge connected or selected. Cannot set light state.");
        }
    }

    public void dispose() {
        this.logger.debug("Handler disposed.");
        if (this.pollingJob != null && !this.pollingJob.isCancelled()) {
            this.pollingJob.cancel(true);
            this.pollingJob = null;
        }
        if (this.hueBridge != null) {
            this.hueBridge = null;
        }
    }

    public void initialize() {
        this.logger.debug("Initializing hue bridge handler.");
        if (this.getConfig().get("ipAddress") != null) {
            if (this.hueBridge == null) {
                this.hueBridge = new HueBridge((String)this.getConfig().get("ipAddress"));
                this.hueBridge.setTimeout(5000);
            }
            this.onUpdate();
        } else {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.OFFLINE.CONFIGURATION_ERROR, "@text/offline.conf-error-no-ip-address");
        }
    }

    private synchronized void onUpdate() {
        if (this.hueBridge != null && (this.pollingJob == null || this.pollingJob.isCancelled())) {
            int pollingInterval = 10;
            try {
                Object pollingIntervalConfig = this.getConfig().get("pollingInterval");
                if (pollingIntervalConfig != null) {
                    pollingInterval = ((BigDecimal)pollingIntervalConfig).intValue();
                } else {
                    this.logger.info("Polling interval not configured for this hue bridge. Using default value: {}s", (Object)pollingInterval);
                }
            }
            catch (NumberFormatException ex) {
                this.logger.info("Wrong configuration value for polling interval. Using default value: {}s", (Object)pollingInterval);
            }
            this.pollingJob = this.scheduler.scheduleWithFixedDelay(this.pollingRunnable, 1L, pollingInterval, TimeUnit.SECONDS);
        }
    }

    public void onConnectionLost() {
        this.logger.debug("Bridge connection lost. Updating thing status to OFFLINE.");
        this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.NONE, "@text/offline.bridge-connection-lost");
    }

    private void onConnectionResumed() throws IOException, ApiException {
        FullConfig fullConfig;
        Config config;
        this.logger.debug("Bridge connection resumed. Updating thing status to ONLINE.");
        if (!this.propertiesInitializedSuccessfully && (config = (fullConfig = this.hueBridge.getFullConfig()).getConfig()) != null) {
            Map properties = this.editProperties();
            properties.put("serialNumber", config.getMACAddress().replaceAll(":", "").toLowerCase());
            properties.put("firmwareVersion", config.getSoftwareVersion());
            this.updateProperties(properties);
            this.updateThing(this.thing);
            this.propertiesInitializedSuccessfully = true;
        }
        this.updateStatus(ThingStatus.ONLINE);
    }

    private boolean tryResumeBridgeConnection() throws IOException, ApiException {
        this.logger.debug("Connection to Hue Bridge {} established.", (Object)this.hueBridge.getIPAddress());
        if (this.getConfig().get("userName") == null) {
            this.logger.warn("User name for Hue bridge authentication not available in configuration. Setting ThingStatus to offline.");
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, "@text/offline.conf-error-no-username");
            return false;
        }
        this.onConnectionResumed();
        return true;
    }

    public boolean onNotAuthenticated() {
        String userName = (String)this.getConfig().get("userName");
        if (this.hueBridge == null) {
            return false;
        }
        if (userName == null) {
            this.createUser();
        } else {
            try {
                this.hueBridge.authenticate(userName);
                return true;
            }
            catch (Exception e) {
                this.handleAuthenticationFailure(e, userName);
            }
        }
        return false;
    }

    private void createUser() {
        try {
            String newUser = this.createUserOnPhysicalBridge();
            this.updateBridgeThingConfiguration(newUser);
        }
        catch (LinkButtonException ex) {
            this.handleLinkButtonNotPressed(ex);
        }
        catch (Exception ex) {
            this.handleExceptionWhileCreatingUser(ex);
        }
    }

    private String createUserOnPhysicalBridge() throws IOException, ApiException {
        this.logger.info("Creating new user on Hue bridge {} - please press the pairing button on the bridge.", this.getConfig().get("ipAddress"));
        String userName = this.hueBridge.link(DEVICE_TYPE);
        this.logger.info("User '{}' has been successfully added to Hue bridge.", (Object)userName);
        return userName;
    }

    private void updateBridgeThingConfiguration(String userName) {
        Configuration config = this.editConfiguration();
        config.put("userName", (Object)userName);
        try {
            this.updateConfiguration(config);
            this.logger.debug("Updated configuration parameter {} to '{}'", (Object)"userName", (Object)userName);
        }
        catch (IllegalStateException e) {
            this.logger.trace("Configuration update failed.", (Throwable)e);
            this.logger.warn("Unable to update configuration of Hue bridge.");
            this.logger.warn("Please configure the following user name manually: {}", (Object)userName);
        }
    }

    private void handleAuthenticationFailure(Exception ex, String userName) {
        this.logger.warn("User {} is not authenticated on Hue bridge {}", (Object)userName, this.getConfig().get("ipAddress"));
        this.logger.warn("Please configure a valid user or remove user from configuration to generate a new one.");
        this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.OFFLINE.CONFIGURATION_ERROR, "@text/offline.conf-error-invalid-username");
    }

    private void handleLinkButtonNotPressed(LinkButtonException ex) {
        this.logger.debug("Failed creating new user on Hue bridge: {}", (Object)ex.getMessage());
        this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.OFFLINE.CONFIGURATION_ERROR, "@text/offline.conf-error-press-pairing-button");
    }

    private void handleExceptionWhileCreatingUser(Exception ex) {
        this.logger.warn("Failed creating new user on Hue bridge", (Throwable)ex);
        this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.OFFLINE.CONFIGURATION_ERROR, "@text/offline.conf-error-creation-username");
    }

    public boolean registerLightStatusListener(LightStatusListener lightStatusListener) {
        boolean result = this.lightStatusListeners.add(lightStatusListener);
        if (result) {
            this.onUpdate();
            for (FullLight light : this.lastLightStates.values()) {
                lightStatusListener.onLightAdded(this.hueBridge, light);
            }
        }
        return result;
    }

    public boolean unregisterLightStatusListener(LightStatusListener lightStatusListener) {
        boolean result = this.lightStatusListeners.remove(lightStatusListener);
        if (result) {
            this.onUpdate();
        }
        return result;
    }

    public @Nullable FullLight getLightById(String lightId) {
        return this.lastLightStates.get(lightId);
    }

    public List<FullLight> getFullLights() {
        List<FullLight> ret = this.withReAuthentication("search for new lights", () -> this.hueBridge.getFullConfig().getLights());
        return ret != null ? ret : Collections.emptyList();
    }

    public void startSearch() {
        this.withReAuthentication("start search mode", () -> {
            this.hueBridge.startSearch();
            return null;
        });
    }

    public void startSearch(List<String> serialNumbers) {
        this.withReAuthentication("start search mode", () -> {
            this.hueBridge.startSearch(serialNumbers);
            return null;
        });
    }

    private <T> T withReAuthentication(String taskDescription, Callable<T> runnable) {
        if (this.hueBridge != null) {
            try {
                try {
                    return runnable.call();
                }
                catch (IllegalStateException | UnauthorizedException e) {
                    this.lastBridgeConnectionState = false;
                    if (this.onNotAuthenticated()) {
                        return runnable.call();
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("Bridge cannot {}.", (Object)taskDescription, (Object)e);
            }
        }
        return null;
    }

    private void notifyLightStatusListeners(FullLight fullLight, String type) {
        if (this.lightStatusListeners.isEmpty()) {
            this.logger.debug("No light status listeners to notify of light change for light {}", (Object)fullLight.getId());
            return;
        }
        block10: for (LightStatusListener lightStatusListener : this.lightStatusListeners) {
            try {
                switch (type) {
                    case "added": {
                        lightStatusListener.onLightAdded(this.hueBridge, fullLight);
                        this.logger.debug("Sending lightAdded for light {}", (Object)fullLight.getId());
                        continue block10;
                    }
                    case "changed": {
                        this.logger.debug("Sending lightStateChanged for light {}", (Object)fullLight.getId());
                        lightStatusListener.onLightStateChanged(this.hueBridge, fullLight);
                        continue block10;
                    }
                    default: {
                        throw new IllegalArgumentException("Could not notify lightStatusListeners for unknown event type " + type);
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("An exception occurred while calling the BridgeHeartbeatListener", (Throwable)e);
            }
        }
    }

    private boolean isEqual(State state1, State state2) {
        boolean commonStateIsEqual;
        boolean bl = commonStateIsEqual = state1.getAlertMode().equals((Object)state2.getAlertMode()) && state1.isOn() == state2.isOn() && state1.getBrightness() == state2.getBrightness() && state1.getColorTemperature() == state2.getColorTemperature() && state1.getHue() == state2.getHue() && state1.getSaturation() == state2.getSaturation() && state1.isReachable() == state2.isReachable();
        if (!commonStateIsEqual) {
            return false;
        }
        boolean colorModeIsEqual = true;
        boolean effectIsEqual = true;
        try {
            colorModeIsEqual = state1.getColorMode().equals((Object)state2.getColorMode());
        }
        catch (NullPointerException npe) {
            this.logger.trace("Light does not support color mode.");
        }
        try {
            effectIsEqual = state1.getEffect().equals((Object)state2.getEffect());
        }
        catch (NullPointerException npe) {
            this.logger.trace("Light does not support effect.");
        }
        return colorModeIsEqual && effectIsEqual;
    }

    public Collection<ConfigStatusMessage> getConfigStatus() {
        String bridgeIpAddress = (String)this.getThing().getConfiguration().get("ipAddress");
        List<ConfigStatusMessage> configStatusMessages = bridgeIpAddress == null || bridgeIpAddress.isEmpty() ? Collections.singletonList(ConfigStatusMessage.Builder.error((String)"ipAddress").withMessageKeySuffix("missing-ip-address-configuration").withArguments(new Object[]{"ipAddress"}).build()) : Collections.emptyList();
        return configStatusMessages;
    }
}

