/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.hue.internal;

import java.util.ArrayList;
import org.eclipse.smarthome.binding.hue.internal.Command;
import org.eclipse.smarthome.binding.hue.internal.Util;

public class ConfigUpdate {
    private ArrayList<Command> commands = new ArrayList();

    String toJson() {
        StringBuilder json = new StringBuilder("{");
        int i = 0;
        while (i < this.commands.size()) {
            json.append(this.commands.get(i).toJson());
            if (i < this.commands.size() - 1) {
                json.append(",");
            }
            ++i;
        }
        json.append("}");
        return json.toString();
    }

    public ConfigUpdate setProxyPort(Integer port) {
        if (port != null && port < 0) {
            throw new IllegalArgumentException("Invalid value for port");
        }
        this.commands.add(new Command("proxyport", port == null ? 0 : port));
        return this;
    }

    public ConfigUpdate setName(String name) {
        if (Util.stringSize(name) < 4 || Util.stringSize(name) > 16) {
            throw new IllegalArgumentException("Bridge name must be between 4 and 16 characters long");
        }
        this.commands.add(new Command("name", name));
        return this;
    }

    public ConfigUpdate setProxyAddress(String ip) {
        if (ip != null && Util.stringSize(ip) > 40) {
            throw new IllegalArgumentException("Bridge proxy address can be at most 40 characters long");
        }
        this.commands.add(new Command("proxyaddress", ip == null ? "none" : ip));
        return this;
    }

    public ConfigUpdate setLinkButton(boolean pressed) {
        this.commands.add(new Command("linkbutton", pressed));
        return this;
    }

    public ConfigUpdate setIPAddress(String ip) {
        this.commands.add(new Command("ipaddress", ip));
        return this;
    }

    public ConfigUpdate setNetworkMask(String netmask) {
        this.commands.add(new Command("netmask", netmask));
        return this;
    }

    public ConfigUpdate setGateway(String ip) {
        this.commands.add(new Command("gateway", ip));
        return this;
    }

    public ConfigUpdate setDHCP(boolean enabled) {
        this.commands.add(new Command("dhcp", enabled));
        return this;
    }
}

