/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.hue.internal;

import java.util.List;
import org.eclipse.smarthome.binding.hue.internal.Light;
import org.eclipse.smarthome.binding.hue.internal.Util;

class SetAttributesRequest {
    private String name;
    private List<String> lights;

    public SetAttributesRequest(String name) {
        this(name, null);
    }

    public SetAttributesRequest(List<Light> lights) {
        this(null, lights);
    }

    public SetAttributesRequest(String name, List<Light> lights) {
        if (name != null && Util.stringSize(name) > 32) {
            throw new IllegalArgumentException("Name can be at most 32 characters long");
        }
        if (lights != null && (lights.size() == 0 || lights.size() > 16)) {
            throw new IllegalArgumentException("Group cannot be empty and cannot have more than 16 lights");
        }
        this.name = name;
        if (lights != null) {
            this.lights = Util.lightsToIds(lights);
        }
    }
}

