/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lirc.handler;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.smarthome.binding.lirc.internal.LIRCMessageListener;
import org.eclipse.smarthome.binding.lirc.internal.config.LIRCBridgeConfiguration;
import org.eclipse.smarthome.binding.lirc.internal.connector.LIRCConnector;
import org.eclipse.smarthome.binding.lirc.internal.connector.LIRCEventListener;
import org.eclipse.smarthome.binding.lirc.internal.messages.LIRCButtonEvent;
import org.eclipse.smarthome.binding.lirc.internal.messages.LIRCResponse;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.binding.BaseBridgeHandler;
import org.eclipse.smarthome.core.types.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LIRCBridgeHandler
extends BaseBridgeHandler {
    private final Logger logger = LoggerFactory.getLogger(LIRCBridgeHandler.class);
    private LIRCBridgeConfiguration configuration;
    private ScheduledFuture<?> connectorTask;
    private LIRCConnector connector;
    private EventListener eventListener = new EventListener();
    private Set<LIRCMessageListener> deviceStatusListeners = new CopyOnWriteArraySet<LIRCMessageListener>();

    public LIRCBridgeHandler(Bridge bridge) {
        super(bridge);
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
        this.logger.debug("Bridge commands not supported.");
    }

    public void initialize() {
        this.logger.debug("Initializing the LIRC Bridge handler");
        this.configuration = (LIRCBridgeConfiguration)this.getConfigAs(LIRCBridgeConfiguration.class);
        if (this.connectorTask == null || this.connectorTask.isCancelled()) {
            this.connectorTask = this.scheduler.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    LIRCBridgeHandler.this.logger.debug("Checking LIRC connection, thing status = {}", (Object)LIRCBridgeHandler.this.thing.getStatus());
                    if (LIRCBridgeHandler.this.thing.getStatus() != ThingStatus.ONLINE) {
                        LIRCBridgeHandler.this.connect();
                    }
                }
            }, 0L, 60L, TimeUnit.SECONDS);
        }
    }

    public void dispose() {
        this.logger.debug("Disposing bridge handler.");
        if (this.connectorTask != null && !this.connectorTask.isCancelled()) {
            this.logger.debug("Cancelling task.");
            this.connectorTask.cancel(true);
            this.connectorTask = null;
        }
        if (this.connector != null) {
            this.logger.debug("Stopping connector");
            this.connector.removeEventListener(this.eventListener);
            this.connector.disconnect();
        }
        for (LIRCMessageListener deviceStatusListener : this.deviceStatusListeners) {
            this.unregisterMessageListener(deviceStatusListener);
        }
        super.dispose();
        this.logger.debug("Bridge handler disposed.");
    }

    private void connect() {
        this.logger.debug("Connecting to LIRC");
        try {
            if (this.connector != null) {
                this.connector.disconnect();
            }
            if (this.configuration.getHost() != null && this.connector == null) {
                this.connector = new LIRCConnector();
            }
            if (this.connector != null) {
                this.connector.connect(this.configuration);
                this.connector.addEventListener(this.eventListener);
                this.updateStatus(ThingStatus.ONLINE);
                this.startDeviceDiscovery();
            }
        }
        catch (UnknownHostException unknownHostException) {
            this.logger.error("Connection to LIRC failed: unknown host");
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, "Unknown Host");
        }
        catch (IOException e) {
            this.logger.error("Connection to LIRC failed", (Throwable)e);
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, e.getMessage());
        }
    }

    public void startDeviceDiscovery() {
        if (this.connector != null) {
            this.connector.startRemoteDiscovery();
        }
    }

    public boolean registerMessageListener(LIRCMessageListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("The listener parameter may not be null.");
        }
        return this.deviceStatusListeners.add(listener);
    }

    public boolean unregisterMessageListener(LIRCMessageListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("The listener parameter may not be null.");
        }
        return this.deviceStatusListeners.remove(listener);
    }

    public void transmit(String remote, String button) {
        this.connector.transmit(remote, button);
    }

    private class EventListener
    implements LIRCEventListener {
        private EventListener() {
        }

        @Override
        public void messageReceived(LIRCResponse response) {
            for (LIRCMessageListener deviceStatusListener : LIRCBridgeHandler.this.deviceStatusListeners) {
                try {
                    deviceStatusListener.onMessageReceived(LIRCBridgeHandler.this.getThing().getUID(), response);
                }
                catch (Exception e) {
                    LIRCBridgeHandler.this.logger.error("An exception occurred while calling the DeviceStatusListener", (Throwable)e);
                }
            }
        }

        @Override
        public void buttonPressed(LIRCButtonEvent buttonEvent) {
            for (LIRCMessageListener deviceStatusListener : LIRCBridgeHandler.this.deviceStatusListeners) {
                try {
                    deviceStatusListener.onButtonPressed(LIRCBridgeHandler.this.getThing().getUID(), buttonEvent);
                }
                catch (Exception e) {
                    LIRCBridgeHandler.this.logger.error("An exception occurred while calling the DeviceStatusListener", (Throwable)e);
                }
            }
        }

        @Override
        public void errorOccured(String error) {
            LIRCBridgeHandler.this.logger.error("Error occured: {}", (Object)error);
            LIRCBridgeHandler.this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, error);
        }
    }
}

