/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lirc.internal.discovery;

import java.util.HashMap;
import org.eclipse.smarthome.binding.lirc.LIRCBindingConstants;
import org.eclipse.smarthome.binding.lirc.handler.LIRCBridgeHandler;
import org.eclipse.smarthome.binding.lirc.internal.LIRCMessageListener;
import org.eclipse.smarthome.binding.lirc.internal.messages.LIRCButtonEvent;
import org.eclipse.smarthome.binding.lirc.internal.messages.LIRCResponse;
import org.eclipse.smarthome.config.discovery.AbstractDiscoveryService;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryResultBuilder;
import org.eclipse.smarthome.config.discovery.DiscoveryServiceCallback;
import org.eclipse.smarthome.config.discovery.ExtendedDiscoveryService;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LIRCRemoteDiscoveryService
extends AbstractDiscoveryService
implements ExtendedDiscoveryService,
LIRCMessageListener {
    private final Logger logger = LoggerFactory.getLogger(LIRCRemoteDiscoveryService.class);
    private LIRCBridgeHandler bridgeHandler;
    private DiscoveryServiceCallback discoveryServiceCallback;

    public LIRCRemoteDiscoveryService(LIRCBridgeHandler lircBridgeHandler) {
        super(LIRCBindingConstants.SUPPORTED_DEVICE_TYPES, 5, true);
        this.bridgeHandler = lircBridgeHandler;
        this.bridgeHandler.registerMessageListener(this);
    }

    public void setDiscoveryServiceCallback(DiscoveryServiceCallback discoveryServiceCallback) {
        this.discoveryServiceCallback = discoveryServiceCallback;
    }

    protected void startScan() {
        this.logger.debug("Discovery service scan started");
        this.bridgeHandler.startDeviceDiscovery();
    }

    @Override
    public void onButtonPressed(ThingUID bridge, LIRCButtonEvent buttonEvent) {
        this.addRemote(bridge, buttonEvent.getRemote());
    }

    @Override
    public void onMessageReceived(ThingUID bridge, LIRCResponse message) {
        LIRCResponse response = message;
        String command = response.getCommand();
        if ("LIST".equals(command) && response.isSuccess()) {
            String[] stringArray = response.getData();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String remoteID = stringArray[n2];
                this.addRemote(bridge, remoteID);
                ++n2;
            }
        }
    }

    private void addRemote(ThingUID bridge, String remote) {
        ThingTypeUID uid = LIRCBindingConstants.THING_TYPE_REMOTE;
        ThingUID thingUID = new ThingUID(uid, bridge, remote);
        if (thingUID != null) {
            if (this.discoveryServiceCallback != null && this.discoveryServiceCallback.getExistingDiscoveryResult(thingUID) != null) {
                this.logger.debug("Remote {}: Already known.", (Object)remote);
                return;
            }
            this.logger.trace("Remote {}: Discovered new remote.", (Object)remote);
            HashMap<String, String> properties = new HashMap<String, String>(1);
            properties.put("remote", remote);
            DiscoveryResult discoveryResult = DiscoveryResultBuilder.create((ThingUID)thingUID).withLabel(remote).withBridge(bridge).withProperties(properties).build();
            this.thingDiscovered(discoveryResult);
        }
    }
}

