/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.sonos.internal;

import java.io.Serializable;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.smarthome.binding.sonos.internal.SonosResourceMetaData;

public class SonosEntry
implements Serializable {
    private static final long serialVersionUID = -4543607156929701588L;
    private final String id;
    private final String title;
    private final String parentId;
    private final String upnpClass;
    private final String res;
    private final String album;
    private final String albumArtUri;
    private final String creator;
    private final int originalTrackNumber;
    private final SonosResourceMetaData resourceMetaData;
    private String desc;

    public SonosEntry(String id, String title, String parentId, String album, String albumArtUri, String creator, String upnpClass, String res) {
        this(id, title, parentId, album, albumArtUri, creator, upnpClass, res, -1);
    }

    public SonosEntry(String id, String title, String parentId, String album, String albumArtUri, String creator, String upnpClass, String res, int originalTrackNumber) {
        this(id, title, parentId, album, albumArtUri, creator, upnpClass, res, originalTrackNumber, null);
    }

    public SonosEntry(String id, String title, String parentId, String album, String albumArtUri, String creator, String upnpClass, String res, int originalTrackNumber, SonosResourceMetaData resourceMetaData) {
        this.id = id;
        this.title = title;
        this.parentId = parentId;
        this.album = album;
        this.albumArtUri = albumArtUri;
        this.creator = creator;
        this.upnpClass = upnpClass;
        this.res = res;
        this.originalTrackNumber = originalTrackNumber;
        this.resourceMetaData = resourceMetaData;
        this.desc = null;
    }

    public String toString() {
        return this.title;
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getParentId() {
        return this.parentId;
    }

    public String getRes() {
        return this.res;
    }

    public String getUpnpClass() {
        return this.upnpClass;
    }

    public String getAlbum() {
        return this.album;
    }

    public String getAlbumArtUri() {
        return StringEscapeUtils.unescapeXml((String)this.albumArtUri);
    }

    public String getCreator() {
        return this.creator;
    }

    public int getOriginalTrackNumber() {
        return this.originalTrackNumber;
    }

    public SonosResourceMetaData getResourceMetaData() {
        return this.resourceMetaData;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}

