/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.sonos.internal;

import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.smarthome.binding.sonos.internal.SonosAlarm;
import org.eclipse.smarthome.binding.sonos.internal.SonosEntry;
import org.eclipse.smarthome.binding.sonos.internal.SonosMetaData;
import org.eclipse.smarthome.binding.sonos.internal.SonosMusicService;
import org.eclipse.smarthome.binding.sonos.internal.SonosResourceMetaData;
import org.eclipse.smarthome.binding.sonos.internal.SonosZoneGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SonosXMLParser {
    static final Logger logger = LoggerFactory.getLogger(SonosXMLParser.class);
    private static MessageFormat METADATA_FORMAT = new MessageFormat("<DIDL-Lite xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:upnp=\"urn:schemas-upnp-org:metadata-1-0/upnp/\" xmlns:r=\"urn:schemas-rinconnetworks-com:metadata-1-0/\" xmlns=\"urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/\"><item id=\"{0}\" parentID=\"{1}\" restricted=\"true\"><dc:title>{2}</dc:title><upnp:class>{3}</upnp:class><desc id=\"cdudn\" nameSpace=\"urn:schemas-rinconnetworks-com:metadata-1-0/\">{4}</desc></item></DIDL-Lite>");

    public static List<SonosAlarm> getAlarmsFromStringResult(String xml) {
        AlarmHandler handler = new AlarmHandler();
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(handler);
            reader.parse(new InputSource(new StringReader(xml)));
        }
        catch (IOException iOException) {
            logger.error("Could not parse Alarms from string '{}'", (Object)xml);
        }
        catch (SAXException sAXException) {
            logger.error("Could not parse Alarms from string '{}'", (Object)xml);
        }
        return handler.getAlarms();
    }

    public static List<SonosEntry> getEntriesFromString(String xml) {
        EntryHandler handler = new EntryHandler();
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(handler);
            reader.parse(new InputSource(new StringReader(xml)));
        }
        catch (IOException iOException) {
            logger.error("Could not parse Entries from string '{}'", (Object)xml);
        }
        catch (SAXException sAXException) {
            logger.error("Could not parse Entries from string '{}'", (Object)xml);
        }
        return handler.getArtists();
    }

    public static SonosResourceMetaData getResourceMetaData(String xml) throws SAXException {
        XMLReader reader = XMLReaderFactory.createXMLReader();
        ResourceMetaDataHandler handler = new ResourceMetaDataHandler();
        reader.setContentHandler(handler);
        try {
            reader.parse(new InputSource(new StringReader(xml)));
        }
        catch (IOException iOException) {
            logger.error("Could not parse Resource MetaData from String '{}'", (Object)xml);
        }
        catch (SAXException sAXException) {
            logger.error("Could not parse Resource MetaData from string '{}'", (Object)xml);
        }
        return handler.getMetaData();
    }

    public static List<SonosZoneGroup> getZoneGroupFromXML(String xml) {
        ZoneGroupHandler handler = new ZoneGroupHandler();
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(handler);
            reader.parse(new InputSource(new StringReader(xml)));
        }
        catch (IOException iOException) {
            logger.error("Could not parse ZoneGroup from string '{}'", (Object)xml);
        }
        catch (SAXException sAXException) {
            logger.error("Could not parse ZoneGroup from string '{}'", (Object)xml);
        }
        return handler.getGroups();
    }

    public static List<String> getRadioTimeFromXML(String xml) {
        OpmlHandler handler = new OpmlHandler();
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(handler);
            reader.parse(new InputSource(new StringReader(xml)));
        }
        catch (IOException iOException) {
            logger.error("Could not parse RadioTime from string '{}'", (Object)xml);
        }
        catch (SAXException sAXException) {
            logger.error("Could not parse RadioTime from string '{}'", (Object)xml);
        }
        return handler.getTextFields();
    }

    public static Map<String, String> getRenderingControlFromXML(String xml) {
        RenderingControlEventHandler handler = new RenderingControlEventHandler();
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(handler);
            reader.parse(new InputSource(new StringReader(xml)));
        }
        catch (IOException iOException) {
            logger.error("Could not parse Rendering Control from string '{}'", (Object)xml);
        }
        catch (SAXException sAXException) {
            logger.error("Could not parse Rendering Control from string '{}'", (Object)xml);
        }
        return handler.getChanges();
    }

    public static Map<String, String> getAVTransportFromXML(String xml) {
        AVTransportEventHandler handler = new AVTransportEventHandler();
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(handler);
            reader.parse(new InputSource(new StringReader(xml)));
        }
        catch (IOException iOException) {
            logger.error("Could not parse AV Transport from string '{}'", (Object)xml);
        }
        catch (SAXException sAXException) {
            logger.error("Could not parse AV Transport from string '{}'", (Object)xml);
        }
        return handler.getChanges();
    }

    public static SonosMetaData getMetaDataFromXML(String xml) {
        MetaDataHandler handler = new MetaDataHandler();
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(handler);
            reader.parse(new InputSource(new StringReader(xml)));
        }
        catch (IOException iOException) {
            logger.error("Could not parse MetaData from string '{}'", (Object)xml);
        }
        catch (SAXException sAXException) {
            logger.error("Could not parse MetaData from string '{}'", (Object)xml);
        }
        return handler.getMetaData();
    }

    public static List<SonosMusicService> getMusicServicesFromXML(String xml) {
        MusicServiceHandler handler = new MusicServiceHandler();
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(handler);
            reader.parse(new InputSource(new StringReader(xml)));
        }
        catch (IOException iOException) {
            logger.error("Could not parse music services from string '{}'", (Object)xml);
        }
        catch (SAXException sAXException) {
            logger.error("Could not parse music services from string '{}'", (Object)xml);
        }
        return handler.getServices();
    }

    public static String getRoomName(String descriptorXML) {
        RoomNameHandler roomNameHandler = new RoomNameHandler();
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(roomNameHandler);
            URL url = new URL(descriptorXML);
            reader.parse(new InputSource(url.openStream()));
        }
        catch (IOException | SAXException exception) {
            logger.error("Could not parse Sonos room name from string '{}'", (Object)descriptorXML);
        }
        return roomNameHandler.getRoomName();
    }

    public static String parseModelDescription(URL descriptorURL) {
        ModelNameHandler modelNameHandler = new ModelNameHandler();
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(modelNameHandler);
            URL url = new URL(descriptorURL.toString());
            reader.parse(new InputSource(url.openStream()));
        }
        catch (IOException | SAXException exception) {
            logger.error("Could not parse Sonos model name from string '{}'", (Object)descriptorURL.toString());
        }
        return modelNameHandler.getModelName();
    }

    public static String extractModelName(String sonosModelName) {
        String ret = sonosModelName;
        Matcher matcher = Pattern.compile("\\s(.*)").matcher(ret);
        if (matcher.find()) {
            ret = matcher.group(1);
        }
        if (ret.contains(":")) {
            ret = ret.replace(":", "");
        }
        return ret;
    }

    public static String compileMetadataString(SonosEntry entry) {
        String id = entry.getId();
        String parentId = entry.getParentId();
        String title = entry.getTitle();
        String upnpClass = entry.getUpnpClass();
        String desc = entry.getDesc();
        if (desc == null) {
            desc = "RINCON_AssociatedZPUDN";
        }
        if (entry.getResourceMetaData() != null) {
            id = entry.getResourceMetaData().getId();
            parentId = entry.getResourceMetaData().getParentId();
            title = entry.getResourceMetaData().getTitle();
            desc = entry.getResourceMetaData().getDesc();
            upnpClass = entry.getResourceMetaData().getUpnpClass();
        }
        title = StringEscapeUtils.escapeXml((String)title);
        String metadata = METADATA_FORMAT.format(new Object[]{id, parentId, title, upnpClass, desc});
        return metadata;
    }

    private static class AVTransportEventHandler
    extends DefaultHandler {
        private final Map<String, String> changes = new HashMap<String, String>();

        private AVTransportEventHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            try {
                if (atts.getValue("val") != null) {
                    this.changes.put(localName, atts.getValue("val"));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.info("{} is not defined in EventType. ", (Object)localName);
            }
        }

        public Map<String, String> getChanges() {
            return this.changes;
        }
    }

    private static class AlarmHandler
    extends DefaultHandler {
        private String id;
        private String startTime;
        private String duration;
        private String recurrence;
        private String enabled;
        private String roomUUID;
        private String programURI;
        private String programMetaData;
        private String playMode;
        private String volume;
        private String includeLinkedZones;
        private List<SonosAlarm> alarms = new ArrayList<SonosAlarm>();

        AlarmHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("Alarm")) {
                this.id = attributes.getValue("ID");
                this.duration = attributes.getValue("Duration");
                this.recurrence = attributes.getValue("Recurrence");
                this.startTime = attributes.getValue("StartTime");
                this.enabled = attributes.getValue("Enabled");
                this.roomUUID = attributes.getValue("RoomUUID");
                this.programURI = attributes.getValue("ProgramURI");
                this.programMetaData = attributes.getValue("ProgramMetaData");
                this.playMode = attributes.getValue("PlayMode");
                this.volume = attributes.getValue("Volume");
                this.includeLinkedZones = attributes.getValue("IncludeLinkedZones");
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("Alarm")) {
                int finalID = 0;
                int finalVolume = 0;
                boolean finalEnabled = false;
                boolean finalIncludeLinkedZones = false;
                try {
                    finalID = Integer.parseInt(this.id);
                    finalVolume = Integer.parseInt(this.volume);
                    finalEnabled = !this.enabled.equals("0");
                    finalIncludeLinkedZones = !this.includeLinkedZones.equals("0");
                }
                catch (Exception exception) {
                    logger.debug("Error parsing Integer");
                }
                this.alarms.add(new SonosAlarm(finalID, this.startTime, this.duration, this.recurrence, finalEnabled, this.roomUUID, this.programURI, this.programMetaData, this.playMode, finalVolume, finalIncludeLinkedZones));
            }
        }

        public List<SonosAlarm> getAlarms() {
            return this.alarms;
        }
    }

    private static enum CurrentElement {
        item,
        res,
        streamContent,
        albumArtURI,
        title,
        upnpClass,
        creator,
        album,
        albumArtist,
        desc;

    }

    private static enum Element {
        TITLE,
        CLASS,
        ALBUM,
        ALBUM_ART_URI,
        CREATOR,
        RES,
        TRACK_NUMBER,
        RESMD,
        DESC;

    }

    private static class EntryHandler
    extends DefaultHandler {
        private static List<String> ignore = null;
        private String id;
        private String parentId;
        private StringBuilder upnpClass = new StringBuilder();
        private StringBuilder res = new StringBuilder();
        private StringBuilder title = new StringBuilder();
        private StringBuilder album = new StringBuilder();
        private StringBuilder albumArtUri = new StringBuilder();
        private StringBuilder creator = new StringBuilder();
        private StringBuilder trackNumber = new StringBuilder();
        private StringBuilder desc = new StringBuilder();
        private Element element = null;
        private List<SonosEntry> artists = new ArrayList<SonosEntry>();

        EntryHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("container") || qName.equals("item")) {
                this.id = attributes.getValue("id");
                this.parentId = attributes.getValue("parentID");
            } else if (qName.equals("res")) {
                this.element = Element.RES;
            } else if (qName.equals("dc:title")) {
                this.element = Element.TITLE;
            } else if (qName.equals("upnp:class")) {
                this.element = Element.CLASS;
            } else if (qName.equals("dc:creator")) {
                this.element = Element.CREATOR;
            } else if (qName.equals("upnp:album")) {
                this.element = Element.ALBUM;
            } else if (qName.equals("upnp:albumArtURI")) {
                this.element = Element.ALBUM_ART_URI;
            } else if (qName.equals("upnp:originalTrackNumber")) {
                this.element = Element.TRACK_NUMBER;
            } else if (qName.equals("r:resMD")) {
                this.element = Element.RESMD;
            } else {
                if (ignore == null) {
                    ignore = new ArrayList<String>();
                    ignore.add("DIDL-Lite");
                    ignore.add("type");
                    ignore.add("ordinal");
                    ignore.add("description");
                }
                if (!ignore.contains(localName)) {
                    logger.debug("Did not recognise element named {}", (Object)localName);
                }
                this.element = null;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.element == null) {
                return;
            }
            switch (this.element) {
                case TITLE: {
                    this.title.append(ch, start, length);
                    break;
                }
                case CLASS: {
                    this.upnpClass.append(ch, start, length);
                    break;
                }
                case RES: {
                    this.res.append(ch, start, length);
                    break;
                }
                case ALBUM: {
                    this.album.append(ch, start, length);
                    break;
                }
                case ALBUM_ART_URI: {
                    this.albumArtUri.append(ch, start, length);
                    break;
                }
                case CREATOR: {
                    this.creator.append(ch, start, length);
                    break;
                }
                case TRACK_NUMBER: {
                    this.trackNumber.append(ch, start, length);
                    break;
                }
                case RESMD: {
                    this.desc.append(ch, start, length);
                    break;
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("container") || qName.equals("item")) {
                this.element = null;
                int trackNumberVal = 0;
                try {
                    trackNumberVal = Integer.parseInt(this.trackNumber.toString());
                }
                catch (Exception exception) {}
                SonosResourceMetaData md = null;
                if (!this.desc.toString().isEmpty()) {
                    try {
                        md = SonosXMLParser.getResourceMetaData(this.desc.toString());
                    }
                    catch (SAXException ignore) {
                        logger.debug("Failed to parse embeded", (Throwable)ignore);
                    }
                }
                this.artists.add(new SonosEntry(this.id, this.title.toString(), this.parentId, this.album.toString(), this.albumArtUri.toString(), this.creator.toString(), this.upnpClass.toString(), this.res.toString(), trackNumberVal, md));
                this.title = new StringBuilder();
                this.upnpClass = new StringBuilder();
                this.res = new StringBuilder();
                this.album = new StringBuilder();
                this.albumArtUri = new StringBuilder();
                this.creator = new StringBuilder();
                this.trackNumber = new StringBuilder();
                this.desc = new StringBuilder();
            }
        }

        public List<SonosEntry> getArtists() {
            return this.artists;
        }
    }

    private static class MetaDataHandler
    extends DefaultHandler {
        private CurrentElement currentElement = null;
        private String id = "-1";
        private String parentId = "-1";
        private StringBuilder resource = new StringBuilder();
        private StringBuilder streamContent = new StringBuilder();
        private StringBuilder albumArtUri = new StringBuilder();
        private StringBuilder title = new StringBuilder();
        private StringBuilder upnpClass = new StringBuilder();
        private StringBuilder creator = new StringBuilder();
        private StringBuilder album = new StringBuilder();
        private StringBuilder albumArtist = new StringBuilder();

        private MetaDataHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if ("item".equals(localName)) {
                this.currentElement = CurrentElement.item;
                this.id = atts.getValue("id");
                this.parentId = atts.getValue("parentID");
            } else {
                this.currentElement = "res".equals(localName) ? CurrentElement.res : ("streamContent".equals(localName) ? CurrentElement.streamContent : ("albumArtURI".equals(localName) ? CurrentElement.albumArtURI : ("title".equals(localName) ? CurrentElement.title : ("class".equals(localName) ? CurrentElement.upnpClass : ("creator".equals(localName) ? CurrentElement.creator : ("album".equals(localName) ? CurrentElement.album : ("albumArtist".equals(localName) ? CurrentElement.albumArtist : null)))))));
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.currentElement != null) {
                switch (this.currentElement) {
                    case item: {
                        break;
                    }
                    case res: {
                        this.resource.append(ch, start, length);
                        break;
                    }
                    case streamContent: {
                        this.streamContent.append(ch, start, length);
                        break;
                    }
                    case albumArtURI: {
                        this.albumArtUri.append(ch, start, length);
                        break;
                    }
                    case title: {
                        this.title.append(ch, start, length);
                        break;
                    }
                    case upnpClass: {
                        this.upnpClass.append(ch, start, length);
                        break;
                    }
                    case creator: {
                        this.creator.append(ch, start, length);
                        break;
                    }
                    case album: {
                        this.album.append(ch, start, length);
                        break;
                    }
                    case albumArtist: {
                        this.albumArtist.append(ch, start, length);
                        break;
                    }
                }
            }
        }

        public SonosMetaData getMetaData() {
            return new SonosMetaData(this.id, this.parentId, this.resource.toString(), this.streamContent.toString(), this.albumArtUri.toString(), this.title.toString(), this.upnpClass.toString(), this.creator.toString(), this.album.toString(), this.albumArtist.toString());
        }
    }

    private static class ModelNameHandler
    extends DefaultHandler {
        private String modelName;
        private boolean modelNameTag;

        private ModelNameHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if ("modelName".equalsIgnoreCase(localName)) {
                this.modelNameTag = true;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.modelNameTag) {
                this.modelName = new String(ch, start, length);
                this.modelNameTag = false;
            }
        }

        public String getModelName() {
            return this.modelName;
        }
    }

    private static class MusicServiceHandler
    extends DefaultHandler {
        private final List<SonosMusicService> services = new ArrayList<SonosMusicService>();

        private MusicServiceHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if ("Service".equals(qName) && atts.getValue("Id") != null && atts.getValue("Name") != null) {
                this.services.add(new SonosMusicService(atts.getValue("Id"), atts.getValue("Name")));
            }
        }

        public List<SonosMusicService> getServices() {
            return this.services;
        }
    }

    private static class OpmlHandler
    extends DefaultHandler {
        private final List<String> textFields = new ArrayList<String>();
        private String textField;
        private String type;

        private OpmlHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("outline")) {
                this.type = attributes.getValue("type");
                this.textField = this.type.equals("text") ? attributes.getValue("text") : null;
            } else {
                qName.equals("logo");
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("outline") && this.textField != null) {
                this.textFields.add(this.textField);
            }
        }

        public List<String> getTextFields() {
            return this.textFields;
        }
    }

    private static class RenderingControlEventHandler
    extends DefaultHandler {
        private final Map<String, String> changes = new HashMap<String, String>();
        private boolean getPresetName = false;
        private String presetName;

        private RenderingControlEventHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if ("Volume".equals(qName)) {
                this.changes.put(String.valueOf(qName) + atts.getValue("channel"), atts.getValue("val"));
            } else if ("Mute".equals(qName)) {
                this.changes.put(String.valueOf(qName) + atts.getValue("channel"), atts.getValue("val"));
            } else if ("Bass".equals(qName)) {
                this.changes.put(qName, atts.getValue("val"));
            } else if ("Treble".equals(qName)) {
                this.changes.put(qName, atts.getValue("val"));
            } else if ("Loudness".equals(qName)) {
                this.changes.put(String.valueOf(qName) + atts.getValue("channel"), atts.getValue("val"));
            } else if ("OutputFixed".equals(qName)) {
                this.changes.put(qName, atts.getValue("val"));
            } else if ("PresetNameList".equals(qName)) {
                this.getPresetName = true;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.getPresetName) {
                this.presetName = new String(ch, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.getPresetName) {
                this.getPresetName = false;
                this.changes.put(qName, this.presetName);
            }
        }

        public Map<String, String> getChanges() {
            return this.changes;
        }
    }

    private static class ResourceMetaDataHandler
    extends DefaultHandler {
        private String id;
        private String parentId;
        private StringBuilder title = new StringBuilder();
        private StringBuilder upnpClass = new StringBuilder();
        private StringBuilder desc = new StringBuilder();
        private Element element = null;
        private SonosResourceMetaData metaData = null;

        ResourceMetaDataHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("container") || qName.equals("item")) {
                this.id = attributes.getValue("id");
                this.parentId = attributes.getValue("parentID");
            } else {
                this.element = qName.equals("desc") ? Element.DESC : (qName.equals("upnp:class") ? Element.CLASS : (qName.equals("dc:title") ? Element.TITLE : null));
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.element == null) {
                return;
            }
            switch (this.element) {
                case TITLE: {
                    this.title.append(ch, start, length);
                    break;
                }
                case CLASS: {
                    this.upnpClass.append(ch, start, length);
                    break;
                }
                case DESC: {
                    this.desc.append(ch, start, length);
                    break;
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("DIDL-Lite")) {
                this.metaData = new SonosResourceMetaData(this.id, this.parentId, this.title.toString(), this.upnpClass.toString(), this.desc.toString());
                this.element = null;
                this.desc = new StringBuilder();
                this.upnpClass = new StringBuilder();
                this.title = new StringBuilder();
            }
        }

        public SonosResourceMetaData getMetaData() {
            return this.metaData;
        }
    }

    private static class RoomNameHandler
    extends DefaultHandler {
        private String roomName;
        private boolean roomNameTag;

        private RoomNameHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if ("roomName".equalsIgnoreCase(localName)) {
                this.roomNameTag = true;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.roomNameTag) {
                this.roomName = new String(ch, start, length);
                this.roomNameTag = false;
            }
        }

        public String getRoomName() {
            return this.roomName;
        }
    }

    private static class ZoneGroupHandler
    extends DefaultHandler {
        private final List<SonosZoneGroup> groups = new ArrayList<SonosZoneGroup>();
        private final List<String> currentGroupPlayers = new ArrayList<String>();
        private final List<String> currentGroupPlayerZones = new ArrayList<String>();
        private String coordinator;
        private String groupId;

        private ZoneGroupHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("ZoneGroup")) {
                this.groupId = attributes.getValue("ID");
                this.coordinator = attributes.getValue("Coordinator");
            } else if (qName.equals("ZoneGroupMember")) {
                String htInfoSet;
                this.currentGroupPlayers.add(attributes.getValue("UUID"));
                String zoneName = attributes.getValue("ZoneName");
                if (zoneName != null) {
                    this.currentGroupPlayerZones.add(zoneName);
                }
                if ((htInfoSet = attributes.getValue("HTSatChanMapSet")) != null) {
                    this.currentGroupPlayers.addAll(this.getAllHomeTheaterMembers(htInfoSet));
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("ZoneGroup")) {
                this.groups.add(new SonosZoneGroup(this.groupId, this.coordinator, this.currentGroupPlayers, this.currentGroupPlayerZones));
                this.currentGroupPlayers.clear();
                this.currentGroupPlayerZones.clear();
            }
        }

        public List<SonosZoneGroup> getGroups() {
            return this.groups;
        }

        private Set<String> getAllHomeTheaterMembers(String homeTheaterDescription) {
            HashSet<String> homeTheaterMembers = new HashSet<String>();
            Matcher matcher = Pattern.compile("(RINCON_\\w+)").matcher(homeTheaterDescription);
            while (matcher.find()) {
                String member = matcher.group();
                homeTheaterMembers.add(member);
            }
            return homeTheaterMembers;
        }
    }
}

