/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.sonos.internal.discovery;

import java.util.HashMap;
import java.util.Set;
import org.eclipse.smarthome.binding.sonos.internal.SonosBindingConstants;
import org.eclipse.smarthome.binding.sonos.internal.SonosXMLParser;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryResultBuilder;
import org.eclipse.smarthome.config.discovery.upnp.UpnpDiscoveryParticipant;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.jupnp.model.meta.RemoteDevice;
import org.jupnp.model.meta.RemoteDeviceIdentity;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class ZonePlayerDiscoveryParticipant
implements UpnpDiscoveryParticipant {
    private final Logger logger = LoggerFactory.getLogger(ZonePlayerDiscoveryParticipant.class);

    public Set<ThingTypeUID> getSupportedThingTypeUIDs() {
        return SonosBindingConstants.SUPPORTED_THING_TYPES_UIDS;
    }

    public DiscoveryResult createResult(RemoteDevice device) {
        String roomName;
        ThingUID uid = this.getThingUID(device);
        if (uid != null && (roomName = this.getSonosRoomName(device)) != null) {
            HashMap<String, String> properties = new HashMap<String, String>(3);
            String label = "Sonos device";
            try {
                label = device.getDetails().getModelDetails().getModelName();
            }
            catch (Exception exception) {}
            label = String.valueOf(label) + " (" + roomName + ")";
            properties.put("udn", ((RemoteDeviceIdentity)device.getIdentity()).getUdn().getIdentifierString());
            properties.put("identification", roomName);
            DiscoveryResult result = DiscoveryResultBuilder.create((ThingUID)uid).withProperties(properties).withLabel(label).withRepresentationProperty("udn").build();
            this.logger.debug("Created a DiscoveryResult for device '{}' with UDN '{}'", (Object)device.getDetails().getFriendlyName(), (Object)((RemoteDeviceIdentity)device.getIdentity()).getUdn().getIdentifierString());
            return result;
        }
        return null;
    }

    public ThingUID getThingUID(RemoteDevice device) {
        if (device.getDetails().getManufacturerDetails().getManufacturer() != null && device.getDetails().getManufacturerDetails().getManufacturer().toUpperCase().contains("SONOS")) {
            String modelName = this.getModelName(device);
            if (modelName.equals("ZP80")) {
                modelName = "CONNECT";
            } else if (modelName.equals("ZP100")) {
                modelName = "CONNECTAMP";
            }
            ThingTypeUID thingUID = new ThingTypeUID("sonos", modelName);
            if (!SonosBindingConstants.SUPPORTED_KNOWN_THING_TYPES_UIDS.contains(thingUID)) {
                thingUID = SonosBindingConstants.ZONEPLAYER_THING_TYPE_UID;
            }
            this.logger.debug("Discovered a Sonos '{}' thing with UDN '{}'", (Object)thingUID, (Object)((RemoteDeviceIdentity)device.getIdentity()).getUdn().getIdentifierString());
            return new ThingUID(thingUID, ((RemoteDeviceIdentity)device.getIdentity()).getUdn().getIdentifierString());
        }
        return null;
    }

    private String getModelName(RemoteDevice device) {
        return SonosXMLParser.extractModelName(device.getDetails().getModelDetails().getModelName());
    }

    private String getSonosRoomName(RemoteDevice device) {
        return SonosXMLParser.getRoomName(((RemoteDeviceIdentity)device.getIdentity()).getDescriptorURL().toString());
    }
}

