/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.core;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.reflect.FieldUtils;
import org.eclipse.smarthome.config.core.ConfigUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private final Map<String, Object> properties;
    private final transient Logger logger = LoggerFactory.getLogger(Configuration.class);

    public Configuration() {
        this(null);
    }

    public Configuration(Map<String, Object> properties) {
        this.properties = properties == null ? new HashMap() : ConfigUtil.normalizeTypes(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T as(Class<T> configurationClass) {
        Configuration configuration = this;
        synchronized (configuration) {
            T configuration2 = null;
            try {
                configuration2 = configurationClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException ex) {
                this.logger.error("Could not create configuration instance: {}", (Object)ex.getMessage(), (Object)ex);
                return null;
            }
            List<Field> fields = this.getAllFields(configurationClass);
            for (Field field : fields) {
                if (Modifier.isFinal(field.getModifiers())) continue;
                String fieldName = field.getName();
                String typeName = field.getType().getSimpleName();
                Object value = this.properties.get(fieldName);
                if (value == null && field.getType().isPrimitive()) {
                    this.logger.debug("Skipping field '{}', because it's primitive data type and value is not set", (Object)fieldName);
                    continue;
                }
                try {
                    if (value != null && value instanceof BigDecimal && !typeName.equals("BigDecimal")) {
                        BigDecimal bdValue = (BigDecimal)value;
                        if (typeName.equalsIgnoreCase("Float")) {
                            value = Float.valueOf(bdValue.floatValue());
                        } else if (typeName.equalsIgnoreCase("Double")) {
                            value = bdValue.doubleValue();
                        } else if (typeName.equalsIgnoreCase("Long")) {
                            value = bdValue.longValue();
                        } else if (typeName.equalsIgnoreCase("Integer") || typeName.equalsIgnoreCase("int")) {
                            value = bdValue.intValue();
                        }
                    }
                    if (value == null) continue;
                    this.logger.trace("Setting value ({}) {} to field '{}' in configuration class {}", new Object[]{typeName, value, fieldName, configurationClass.getName()});
                    FieldUtils.writeField(configuration2, (String)fieldName, (Object)value, (boolean)true);
                }
                catch (Exception ex) {
                    this.logger.warn("Could not set field value for field '{}': {}", new Object[]{fieldName, ex.getMessage(), ex});
                }
            }
            return configuration2;
        }
    }

    private List<Field> getAllFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Class<?> currentClass = clazz;
        while (currentClass != null) {
            fields.addAll(Arrays.asList(currentClass.getDeclaredFields()));
            currentClass = currentClass.getSuperclass();
        }
        return fields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(String key) {
        Configuration configuration = this;
        synchronized (configuration) {
            return this.properties.containsKey(key);
        }
    }

    @Deprecated
    public Object get(Object key) {
        return this.get((String)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String key) {
        Configuration configuration = this;
        synchronized (configuration) {
            return this.properties.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(String key, Object value) {
        Configuration configuration = this;
        synchronized (configuration) {
            return this.properties.put(key, ConfigUtil.normalizeType(value));
        }
    }

    @Deprecated
    public Object remove(Object key) {
        return this.remove((String)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(String key) {
        Configuration configuration = this;
        synchronized (configuration) {
            return this.properties.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> keySet() {
        Configuration configuration = this;
        synchronized (configuration) {
            return Collections.unmodifiableSet(new HashSet<String>(this.properties.keySet()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Object> values() {
        Configuration configuration = this;
        synchronized (configuration) {
            return Collections.unmodifiableCollection(new ArrayList<Object>(this.properties.values()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getProperties() {
        Configuration configuration = this;
        synchronized (configuration) {
            return Collections.unmodifiableMap(new HashMap<String, Object>(this.properties));
        }
    }

    public void setProperties(Map<String, Object> properties) {
        for (Map.Entry<String, Object> entrySet : properties.entrySet()) {
            this.put(entrySet.getKey(), entrySet.getValue());
        }
        Iterator<String> it = this.properties.keySet().iterator();
        while (it.hasNext()) {
            String entry = it.next();
            if (properties.containsKey(entry)) continue;
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Configuration configuration = this;
        synchronized (configuration) {
            return this.properties.hashCode();
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Configuration)) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Configuration[");
        boolean first = true;
        for (Map.Entry<String, Object> prop : this.properties.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            Object value = prop.getValue();
            sb.append(String.format("{key=%s; type=%s; value=%s}", prop.getKey(), value != null ? value.getClass().getSimpleName() : "?", value));
        }
        sb.append("]");
        return sb.toString();
    }
}

