/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.core.dto;

import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameterBuilder;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameterGroup;
import org.eclipse.smarthome.config.core.FilterCriteria;
import org.eclipse.smarthome.config.core.ParameterOption;
import org.eclipse.smarthome.config.core.dto.ConfigDescriptionDTO;
import org.eclipse.smarthome.config.core.dto.ConfigDescriptionParameterDTO;
import org.eclipse.smarthome.config.core.dto.ConfigDescriptionParameterGroupDTO;
import org.eclipse.smarthome.config.core.dto.FilterCriteriaDTO;
import org.eclipse.smarthome.config.core.dto.ParameterOptionDTO;

public class ConfigDescriptionDTOMapper {
    public static ConfigDescriptionDTO map(ConfigDescription configDescription) {
        List<ConfigDescriptionParameterGroupDTO> parameterGroups = ConfigDescriptionDTOMapper.mapParameterGroups(configDescription.getParameterGroups());
        List<ConfigDescriptionParameterDTO> parameters = ConfigDescriptionDTOMapper.mapParameters(configDescription.getParameters());
        return new ConfigDescriptionDTO(ConfigDescriptionDTOMapper.toDecodedString(configDescription.getUID()), parameters, parameterGroups);
    }

    private static String toDecodedString(URI uri) {
        return String.valueOf(uri.getScheme()) + ":" + uri.getSchemeSpecificPart();
    }

    public static List<ConfigDescriptionParameter> map(List<ConfigDescriptionParameterDTO> parameters) {
        if (parameters == null) {
            return null;
        }
        ArrayList<ConfigDescriptionParameter> result = new ArrayList<ConfigDescriptionParameter>(parameters.size());
        for (ConfigDescriptionParameterDTO parameter : parameters) {
            result.add(ConfigDescriptionParameterBuilder.create(parameter.name, parameter.type).withContext(parameter.context).withDefault(parameter.defaultValue).withDescription(parameter.description).withLabel(parameter.label).withRequired(parameter.required).withMinimum(parameter.min).withMaximum(parameter.max).withStepSize(parameter.stepsize).withPattern(parameter.pattern).withReadOnly(parameter.readOnly).withMultiple(parameter.multiple).withMultipleLimit(parameter.multipleLimit).withGroupName(parameter.groupName).withAdvanced(parameter.advanced).withVerify(parameter.verify).withLimitToOptions(parameter.limitToOptions).withUnit(parameter.unitLabel).withUnitLabel(parameter.unitLabel).withOptions(ConfigDescriptionDTOMapper.mapOptionsDTO(parameter.options)).withFilterCriteria(ConfigDescriptionDTOMapper.mapFilterCriteriaDTO(parameter.filterCriteria)).build());
        }
        return result;
    }

    private static List<FilterCriteria> mapFilterCriteriaDTO(List<FilterCriteriaDTO> filterCriteria) {
        if (filterCriteria == null) {
            return null;
        }
        LinkedList<FilterCriteria> result = new LinkedList<FilterCriteria>();
        for (FilterCriteriaDTO criteria : filterCriteria) {
            result.add(new FilterCriteria(criteria.name, criteria.value));
        }
        return result;
    }

    private static List<ParameterOption> mapOptionsDTO(List<ParameterOptionDTO> options) {
        if (options == null) {
            return null;
        }
        LinkedList<ParameterOption> result = new LinkedList<ParameterOption>();
        for (ParameterOptionDTO option : options) {
            result.add(new ParameterOption(option.value, option.label));
        }
        return result;
    }

    public static List<ConfigDescriptionParameterDTO> mapParameters(List<ConfigDescriptionParameter> parameters) {
        ArrayList<ConfigDescriptionParameterDTO> configDescriptionParameterBeans = new ArrayList<ConfigDescriptionParameterDTO>(parameters.size());
        for (ConfigDescriptionParameter configDescriptionParameter : parameters) {
            ConfigDescriptionParameterDTO configDescriptionParameterBean = new ConfigDescriptionParameterDTO(configDescriptionParameter.getName(), configDescriptionParameter.getType(), configDescriptionParameter.getMinimum(), configDescriptionParameter.getMaximum(), configDescriptionParameter.getStepSize(), configDescriptionParameter.getPattern(), configDescriptionParameter.isRequired(), configDescriptionParameter.isReadOnly(), configDescriptionParameter.isMultiple(), configDescriptionParameter.getContext(), configDescriptionParameter.getDefault(), configDescriptionParameter.getLabel(), configDescriptionParameter.getDescription(), ConfigDescriptionDTOMapper.mapOptions(configDescriptionParameter.getOptions()), ConfigDescriptionDTOMapper.mapFilterCriteria(configDescriptionParameter.getFilterCriteria()), configDescriptionParameter.getGroupName(), configDescriptionParameter.isAdvanced(), configDescriptionParameter.getLimitToOptions(), configDescriptionParameter.getMultipleLimit(), configDescriptionParameter.getUnit(), configDescriptionParameter.getUnitLabel(), configDescriptionParameter.isVerifyable());
            configDescriptionParameterBeans.add(configDescriptionParameterBean);
        }
        return configDescriptionParameterBeans;
    }

    public static List<ConfigDescriptionParameterGroupDTO> mapParameterGroups(List<ConfigDescriptionParameterGroup> parameterGroups) {
        ArrayList<ConfigDescriptionParameterGroupDTO> parameterGroupBeans = new ArrayList<ConfigDescriptionParameterGroupDTO>(parameterGroups.size());
        for (ConfigDescriptionParameterGroup parameterGroup : parameterGroups) {
            parameterGroupBeans.add(new ConfigDescriptionParameterGroupDTO(parameterGroup.getName(), parameterGroup.getContext(), parameterGroup.isAdvanced(), parameterGroup.getLabel(), parameterGroup.getDescription()));
        }
        return parameterGroupBeans;
    }

    private static List<FilterCriteriaDTO> mapFilterCriteria(List<FilterCriteria> filterCriteria) {
        if (filterCriteria == null) {
            return null;
        }
        LinkedList<FilterCriteriaDTO> result = new LinkedList<FilterCriteriaDTO>();
        for (FilterCriteria criteria : filterCriteria) {
            result.add(new FilterCriteriaDTO(criteria.getName(), criteria.getValue()));
        }
        return result;
    }

    private static List<ParameterOptionDTO> mapOptions(List<ParameterOption> options) {
        if (options == null) {
            return null;
        }
        LinkedList<ParameterOptionDTO> result = new LinkedList<ParameterOptionDTO>();
        for (ParameterOption option : options) {
            result.add(new ParameterOptionDTO(option.getValue(), option.getLabel()));
        }
        return result;
    }
}

