/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.core.i18n;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameterBuilder;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameterGroup;
import org.eclipse.smarthome.config.core.ParameterOption;
import org.eclipse.smarthome.config.core.i18n.ConfigDescriptionGroupI18nUtil;
import org.eclipse.smarthome.config.core.i18n.ConfigDescriptionI18nUtil;
import org.eclipse.smarthome.core.i18n.TranslationProvider;
import org.osgi.framework.Bundle;

public class ConfigI18nLocalizationService {
    private ConfigDescriptionI18nUtil configDescriptionParamI18nUtil;
    private ConfigDescriptionGroupI18nUtil configDescriptionGroupI18nUtil;

    protected void setTranslationProvider(TranslationProvider i18nProvider) {
        this.configDescriptionParamI18nUtil = new ConfigDescriptionI18nUtil(i18nProvider);
        this.configDescriptionGroupI18nUtil = new ConfigDescriptionGroupI18nUtil(i18nProvider);
    }

    protected void unsetTranslationProvider(TranslationProvider i18nProvider) {
        this.configDescriptionParamI18nUtil = null;
        this.configDescriptionGroupI18nUtil = null;
    }

    public ConfigDescription getLocalizedConfigDescription(Bundle bundle, ConfigDescription configDescription, Locale locale) {
        ArrayList<ConfigDescriptionParameter> localizedConfigDescriptionParameters = new ArrayList<ConfigDescriptionParameter>(configDescription.getParameters().size());
        for (ConfigDescriptionParameter configDescriptionParameter : configDescription.getParameters()) {
            ConfigDescriptionParameter localizedConfigDescriptionParameter = this.getLocalizedConfigDescriptionParameter(bundle, configDescription, configDescriptionParameter, locale);
            localizedConfigDescriptionParameters.add(localizedConfigDescriptionParameter);
        }
        ArrayList<ConfigDescriptionParameterGroup> localizedConfigDescriptionGroups = new ArrayList<ConfigDescriptionParameterGroup>(configDescription.getParameterGroups().size());
        for (ConfigDescriptionParameterGroup configDescriptionParameterGroup : configDescription.getParameterGroups()) {
            ConfigDescriptionParameterGroup localizedConfigDescriptionGroup = this.getLocalizedConfigDescriptionGroup(bundle, configDescription, configDescriptionParameterGroup, locale);
            localizedConfigDescriptionGroups.add(localizedConfigDescriptionGroup);
        }
        return new ConfigDescription(configDescription.getUID(), localizedConfigDescriptionParameters, localizedConfigDescriptionGroups);
    }

    public ConfigDescriptionParameter getLocalizedConfigDescriptionParameter(Bundle bundle, ConfigDescription configDescription, ConfigDescriptionParameter parameter, Locale locale) {
        URI configDescriptionURI = configDescription.getUID();
        String parameterName = parameter.getName();
        String label = this.configDescriptionParamI18nUtil.getParameterLabel(bundle, configDescriptionURI, parameterName, parameter.getLabel(), locale);
        String description = this.configDescriptionParamI18nUtil.getParameterDescription(bundle, configDescriptionURI, parameterName, parameter.getDescription(), locale);
        String pattern = this.configDescriptionParamI18nUtil.getParameterPattern(bundle, configDescriptionURI, parameterName, parameter.getPattern(), locale);
        String unitLabel = this.configDescriptionParamI18nUtil.getParameterUnitLabel(bundle, configDescriptionURI, parameterName, parameter.getUnit(), parameter.getUnitLabel(), locale);
        List<ParameterOption> options = this.getLocalizedOptions(parameter.getOptions(), bundle, configDescriptionURI, parameterName, locale);
        ConfigDescriptionParameter localizedParameter = ConfigDescriptionParameterBuilder.create(parameterName, parameter.getType()).withMinimum(parameter.getMinimum()).withMaximum(parameter.getMaximum()).withStepSize(parameter.getStepSize()).withPattern(pattern).withRequired(parameter.isRequired()).withReadOnly(parameter.isReadOnly()).withMultiple(parameter.isMultiple()).withContext(parameter.getContext()).withDefault(parameter.getDefault()).withLabel(label).withDescription(description).withOptions(options).withFilterCriteria(parameter.getFilterCriteria()).withGroupName(parameter.getGroupName()).withAdvanced(parameter.isAdvanced()).withVerify(parameter.isVerifyable()).withLimitToOptions(parameter.getLimitToOptions()).withMultipleLimit(parameter.getMultipleLimit()).withUnit(parameter.getUnit()).withUnitLabel(unitLabel).build();
        return localizedParameter;
    }

    public ConfigDescriptionParameterGroup getLocalizedConfigDescriptionGroup(Bundle bundle, ConfigDescription configDescription, ConfigDescriptionParameterGroup group, Locale locale) {
        URI configDescriptionURI = configDescription.getUID();
        String name = group.getName();
        String label = this.configDescriptionGroupI18nUtil.getGroupLabel(bundle, configDescriptionURI, name, group.getLabel(), locale);
        String description = this.configDescriptionGroupI18nUtil.getGroupDescription(bundle, configDescriptionURI, name, group.getDescription(), locale);
        ConfigDescriptionParameterGroup localizedGroup = new ConfigDescriptionParameterGroup(name, group.getContext(), group.isAdvanced(), label, description);
        return localizedGroup;
    }

    public List<ParameterOption> getLocalizedOptions(List<ParameterOption> originalOptions, Bundle bundle, URI configDescriptionURI, String parameterName, Locale locale) {
        if (originalOptions == null || originalOptions.isEmpty()) {
            return originalOptions;
        }
        ArrayList<ParameterOption> localizedOptions = new ArrayList<ParameterOption>();
        for (ParameterOption option : originalOptions) {
            String localizedLabel = this.configDescriptionParamI18nUtil.getParameterOptionLabel(bundle, configDescriptionURI, parameterName, option.getValue(), option.getLabel(), locale);
            ParameterOption localizedOption = new ParameterOption(option.getValue(), localizedLabel);
            localizedOptions.add(localizedOption);
        }
        return localizedOptions;
    }
}

