/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.core.internal.i18n;

import java.net.URI;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.smarthome.config.core.ConfigOptionProvider;
import org.eclipse.smarthome.config.core.ParameterOption;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true)
public class I18nConfigOptionsProvider
implements ConfigOptionProvider {
    private static final String NO_OFFSET_FORMAT = "(GMT) %s";
    private static final String NEGATIVE_OFFSET_FORMAT = "(GMT%d:%02d) %s";
    private static final String POSITIVE_OFFSET_FORMAT = "(GMT+%d:%02d) %s";

    @Override
    public Collection<ParameterOption> getParameterOptions(URI uri, String param, Locale locale) {
        if (uri.toString().equals("system:i18n")) {
            Locale translation = locale != null ? locale : Locale.getDefault();
            return this.processParamType(param, locale, translation);
        }
        return null;
    }

    private Collection<ParameterOption> processParamType(String param, Locale locale, Locale translation) {
        switch (param) {
            case "language": {
                return this.getAvailable(locale, l -> new ParameterOption(l.getLanguage(), l.getDisplayLanguage(translation)));
            }
            case "region": {
                return this.getAvailable(locale, l -> new ParameterOption(l.getCountry(), l.getDisplayCountry(translation)));
            }
            case "variant": {
                return this.getAvailable(locale, l -> new ParameterOption(l.getVariant(), l.getDisplayVariant(translation)));
            }
            case "timezone": {
                Comparator byOffset = (t1, t2) -> t1.getRawOffset() - t2.getRawOffset();
                Comparator byID = (t1, t2) -> t1.getID().compareTo(t2.getID());
                return ZoneId.getAvailableZoneIds().stream().map(TimeZone::getTimeZone).sorted(byOffset.thenComparing(byID)).map(tz -> new ParameterOption(tz.getID(), I18nConfigOptionsProvider.getTimeZoneRepresentation(tz))).collect(Collectors.toList());
            }
        }
        return null;
    }

    private static String getTimeZoneRepresentation(TimeZone tz) {
        long hours = TimeUnit.MILLISECONDS.toHours(tz.getRawOffset());
        long minutes = TimeUnit.MILLISECONDS.toMinutes(tz.getRawOffset()) - TimeUnit.HOURS.toMinutes(hours);
        minutes = Math.abs(minutes);
        String result = hours > 0L ? String.format(POSITIVE_OFFSET_FORMAT, hours, minutes, tz.getID()) : (hours < 0L ? String.format(NEGATIVE_OFFSET_FORMAT, hours, minutes, tz.getID()) : String.format(NO_OFFSET_FORMAT, tz.getID()));
        return result;
    }

    private Collection<ParameterOption> getAvailable(Locale locale, Function<Locale, ParameterOption> mapFunction) {
        return Arrays.stream(Locale.getAvailableLocales()).map(l -> (ParameterOption)mapFunction.apply((Locale)l)).distinct().sorted(Comparator.comparing(a -> a.getLabel())).collect(Collectors.toList());
    }
}

