/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.core.internal.normalization;

import java.math.BigDecimal;
import org.eclipse.smarthome.config.core.internal.normalization.AbstractNormalizer;

final class DecimalNormalizer
extends AbstractNormalizer {
    DecimalNormalizer() {
    }

    @Override
    public Object doNormalize(Object value) {
        try {
            if (value instanceof BigDecimal) {
                return this.stripTrailingZeros((BigDecimal)value);
            }
            if (value instanceof String) {
                return this.stripTrailingZeros(new BigDecimal((String)value));
            }
            if (value instanceof Byte) {
                return new BigDecimal(((Byte)value).byteValue()).setScale(1);
            }
            if (value instanceof Integer) {
                return new BigDecimal((Integer)value).setScale(1);
            }
            if (value instanceof Long) {
                return new BigDecimal((Long)value).setScale(1);
            }
            if (value instanceof Float) {
                return new BigDecimal(((Float)value).toString());
            }
            if (value instanceof Double) {
                return BigDecimal.valueOf((Double)value);
            }
        }
        catch (ArithmeticException | NumberFormatException e) {
            this.logger.trace("\"{}\" is not a valid decimal number.", (Object)e, value);
            return value;
        }
        this.logger.trace("Class \"{}\" cannot be converted to a decimal number.", (Object)value.getClass().getName());
        return value;
    }

    private BigDecimal stripTrailingZeros(BigDecimal value) {
        BigDecimal ret = new BigDecimal(value.stripTrailingZeros().toPlainString());
        if (ret.scale() == 0) {
            ret = ret.setScale(1);
        }
        return ret;
    }
}

