/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.core.internal.normalization;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.smarthome.config.core.internal.normalization.AbstractNormalizer;
import org.eclipse.smarthome.config.core.internal.normalization.Normalizer;

final class ListNormalizer
extends AbstractNormalizer {
    private Normalizer delegate;

    ListNormalizer(Normalizer delegate) {
        this.delegate = delegate;
    }

    @Override
    public Object doNormalize(Object value) {
        if (!ListNormalizer.isList(value)) {
            ArrayList<Object> ret = new ArrayList<Object>(1);
            ret.add(this.delegate.normalize(value));
            return ret;
        }
        if (ListNormalizer.isArray(value)) {
            ArrayList<Object> ret = new ArrayList<Object>(((Object[])value).length);
            Object[] objectArray = (Object[])value;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                ret.add(this.delegate.normalize(object));
                ++n2;
            }
            return ret;
        }
        if (value instanceof List) {
            ArrayList<Object> ret = new ArrayList<Object>(((List)value).size());
            for (Object object : (List)value) {
                ret.add(this.delegate.normalize(object));
            }
            return ret;
        }
        if (value instanceof Iterable) {
            ArrayList<Object> ret = new ArrayList<Object>();
            for (Object object : (Iterable)value) {
                ret.add(this.delegate.normalize(object));
            }
            return ret;
        }
        return value;
    }

    static boolean isList(Object value) {
        return ListNormalizer.isArray(value) || value instanceof Iterable;
    }

    private static boolean isArray(Object object) {
        return object != null && object.getClass().isArray();
    }
}

