/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.audio.internal;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.smarthome.config.core.ConfigConstants;
import org.eclipse.smarthome.config.core.ConfigOptionProvider;
import org.eclipse.smarthome.config.core.ParameterOption;
import org.eclipse.smarthome.core.audio.AudioException;
import org.eclipse.smarthome.core.audio.AudioManager;
import org.eclipse.smarthome.core.audio.AudioSink;
import org.eclipse.smarthome.core.audio.AudioSource;
import org.eclipse.smarthome.core.audio.AudioStream;
import org.eclipse.smarthome.core.audio.FileAudioStream;
import org.eclipse.smarthome.core.audio.URLAudioStream;
import org.eclipse.smarthome.core.audio.UnsupportedAudioFormatException;
import org.eclipse.smarthome.core.audio.UnsupportedAudioStreamException;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioManagerImpl
implements AudioManager,
ConfigOptionProvider {
    private static final String CONFIG_URI = "system:audio";
    private static final String CONFIG_DEFAULT_SINK = "defaultSink";
    private static final String CONFIG_DEFAULT_SOURCE = "defaultSource";
    private final Logger logger = LoggerFactory.getLogger(AudioManagerImpl.class);
    private Map<String, AudioSource> audioSources = new ConcurrentHashMap<String, AudioSource>();
    private Map<String, AudioSink> audioSinks = new ConcurrentHashMap<String, AudioSink>();
    private String defaultSource;
    private String defaultSink;

    protected void activate(Map<String, Object> config) {
        this.modified(config);
    }

    protected void deactivate() {
    }

    protected void modified(Map<String, Object> config) {
        if (config != null) {
            this.defaultSource = config.containsKey(CONFIG_DEFAULT_SOURCE) ? config.get(CONFIG_DEFAULT_SOURCE).toString() : null;
            this.defaultSink = config.containsKey(CONFIG_DEFAULT_SINK) ? config.get(CONFIG_DEFAULT_SINK).toString() : null;
        }
    }

    @Override
    public void play(AudioStream audioStream) {
        this.play(audioStream, null);
    }

    @Override
    public void play(AudioStream audioStream, String sinkId) {
        if (audioStream != null) {
            AudioSink sink = this.getSink(sinkId);
            if (sink != null) {
                try {
                    sink.process(audioStream);
                }
                catch (UnsupportedAudioFormatException | UnsupportedAudioStreamException e) {
                    this.logger.error("Error playing '{}': {}", (Object)audioStream.toString(), (Object)e.getMessage());
                }
            } else {
                this.logger.warn("Failed playing audio stream '{}' as no audio sink was found.", (Object)audioStream.toString());
            }
        }
    }

    @Override
    public void playFile(String fileName) throws AudioException {
        this.playFile(fileName, null);
    }

    @Override
    public void playFile(String fileName, String sink) throws AudioException {
        File file = new File(String.valueOf(ConfigConstants.getConfigFolder()) + File.separator + "sounds" + File.separator + fileName);
        FileAudioStream is = new FileAudioStream(file);
        this.play(is, sink);
    }

    @Override
    public void stream(String url) throws AudioException {
        this.stream(url, null);
    }

    @Override
    public void stream(String url, String sinkId) throws AudioException {
        URLAudioStream audioStream = url != null ? new URLAudioStream(url) : null;
        AudioSink sink = this.getSink(sinkId);
        if (sink != null) {
            try {
                sink.process(audioStream);
            }
            catch (UnsupportedAudioFormatException | UnsupportedAudioStreamException e) {
                this.logger.error("Error playing '{}': {}", (Object)url, (Object)e.getMessage());
            }
        }
    }

    @Override
    public PercentType getVolume(String sinkId) {
        AudioSink sink = this.getSink(sinkId);
        if (sink != null) {
            try {
                return sink.getVolume();
            }
            catch (IOException e) {
                this.logger.error("An exception occurred while getting the volume of sink {} : '{}'", (Object)sink.getId(), (Object)e.getMessage());
            }
        }
        return PercentType.ZERO;
    }

    @Override
    public void setVolume(PercentType volume, String sinkId) {
        AudioSink sink = this.getSink(sinkId);
        if (sink != null) {
            try {
                sink.setVolume(volume);
            }
            catch (IOException e) {
                this.logger.error("An exception occurred while setting the volume of sink {} : '{}'", (Object)sink.getId(), (Object)e.getMessage());
            }
        }
    }

    @Override
    public AudioSource getSource() {
        AudioSource source = null;
        if (this.defaultSource != null) {
            source = this.audioSources.get(this.defaultSource);
            if (source == null) {
                this.logger.warn("Default AudioSource service '{}' not available!", (Object)this.defaultSource);
            }
        } else if (!this.audioSources.isEmpty()) {
            source = this.audioSources.values().iterator().next();
        } else {
            this.logger.debug("No AudioSource service available!");
        }
        return source;
    }

    @Override
    public AudioSink getSink() {
        AudioSink sink = null;
        if (this.defaultSink != null) {
            sink = this.audioSinks.get(this.defaultSink);
            if (sink == null) {
                this.logger.warn("Default AudioSink service '{}' not available!", (Object)this.defaultSink);
            }
        } else if (!this.audioSinks.isEmpty()) {
            sink = this.audioSinks.values().iterator().next();
        } else {
            this.logger.debug("No AudioSink service available!");
        }
        return sink;
    }

    @Override
    public Set<String> getSourceIds() {
        return new HashSet<String>(this.audioSources.keySet());
    }

    @Override
    public Set<String> getSinkIds() {
        return new HashSet<String>(this.audioSinks.keySet());
    }

    @Override
    public Set<String> getSourceIds(String pattern) {
        String regex = pattern.replace("?", ".?").replace("*", ".*?");
        HashSet<String> matchedSources = new HashSet<String>();
        for (String aSource : this.audioSources.keySet()) {
            if (!aSource.matches(regex)) continue;
            matchedSources.add(aSource);
        }
        return matchedSources;
    }

    @Override
    public AudioSink getSink(String sinkId) {
        AudioSink sink = null;
        sink = sinkId == null ? this.getSink() : this.audioSinks.get(sinkId);
        return sink;
    }

    @Override
    public Set<String> getSinks(String pattern) {
        String regex = pattern.replace("?", ".?").replace("*", ".*?");
        HashSet<String> matchedSinks = new HashSet<String>();
        for (String aSink : this.audioSinks.keySet()) {
            if (!aSink.matches(regex)) continue;
            matchedSinks.add(aSink);
        }
        return matchedSinks;
    }

    public Collection<ParameterOption> getParameterOptions(URI uri, String param, Locale locale) {
        if (uri.toString().equals(CONFIG_URI)) {
            if (CONFIG_DEFAULT_SOURCE.equals(param)) {
                ArrayList<ParameterOption> options = new ArrayList<ParameterOption>();
                for (AudioSource source : this.audioSources.values()) {
                    ParameterOption option = new ParameterOption(source.getId(), source.getLabel(locale));
                    options.add(option);
                }
                return options;
            }
            if (CONFIG_DEFAULT_SINK.equals(param)) {
                ArrayList<ParameterOption> options = new ArrayList<ParameterOption>();
                for (AudioSink sink : this.audioSinks.values()) {
                    ParameterOption option = new ParameterOption(sink.getId(), sink.getLabel(locale));
                    options.add(option);
                }
                return options;
            }
        }
        return null;
    }

    protected void addAudioSource(AudioSource audioSource) {
        this.audioSources.put(audioSource.getId(), audioSource);
    }

    protected void removeAudioSource(AudioSource audioSource) {
        this.audioSources.remove(audioSource.getId());
    }

    protected void addAudioSink(AudioSink audioSink) {
        this.audioSinks.put(audioSink.getId(), audioSink);
    }

    protected void removeAudioSink(AudioSink audioSink) {
        this.audioSinks.remove(audioSink.getId());
    }
}

