/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.xml.internal;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import java.util.List;
import java.util.Map;
import org.eclipse.smarthome.config.xml.util.ConverterAttributeMapValidator;
import org.eclipse.smarthome.config.xml.util.GenericUnmarshaller;
import org.eclipse.smarthome.config.xml.util.NodeIterator;
import org.eclipse.smarthome.config.xml.util.NodeValue;
import org.eclipse.smarthome.core.thing.xml.internal.ChannelXmlResult;

public class ChannelConverter
extends GenericUnmarshaller<ChannelXmlResult> {
    private ConverterAttributeMapValidator attributeMapValidator = new ConverterAttributeMapValidator((String[][])new String[][]{{"id", "true"}, {"typeId", "false"}});

    public ChannelConverter() {
        super(ChannelXmlResult.class);
    }

    protected List<NodeValue> getProperties(NodeIterator nodeIterator) {
        return nodeIterator.nextList("properties", false);
    }

    protected ChannelXmlResult unmarshalType(HierarchicalStreamReader reader, UnmarshallingContext context, Map<String, String> attributes, NodeIterator nodeIterator) throws ConversionException {
        String id = attributes.get("id");
        String typeId = attributes.get("typeId");
        String label = (String)nodeIterator.nextValue("label", false);
        String description = (String)nodeIterator.nextValue("description", false);
        List<NodeValue> properties = this.getProperties(nodeIterator);
        ChannelXmlResult channelXmlResult = new ChannelXmlResult(id, typeId, label, description, properties);
        return channelXmlResult;
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Map attributes = this.attributeMapValidator.readValidatedAttributes(reader);
        List nodes = (List)context.convertAnother((Object)context, List.class);
        NodeIterator nodeIterator = new NodeIterator(nodes);
        ChannelXmlResult object = this.unmarshalType(reader, context, attributes, nodeIterator);
        nodeIterator.assertEndOfType();
        return object;
    }
}

