/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.xml.internal;

import com.thoughtworks.xstream.converters.ConversionException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.smarthome.core.thing.type.ChannelDefinition;
import org.eclipse.smarthome.core.thing.type.ChannelGroupType;
import org.eclipse.smarthome.core.thing.type.ChannelGroupTypeUID;
import org.eclipse.smarthome.core.thing.xml.internal.ChannelXmlResult;

public class ChannelGroupTypeXmlResult {
    private ChannelGroupTypeUID channelGroupTypeUID;
    private boolean advanced;
    private String label;
    private String description;
    private String category;
    private List<ChannelXmlResult> channelTypeReferences;

    public ChannelGroupTypeXmlResult(ChannelGroupTypeUID channelGroupTypeUID, boolean advanced, String label, String description, String category, List<ChannelXmlResult> channelTypeReferences) {
        this.channelGroupTypeUID = channelGroupTypeUID;
        this.advanced = advanced;
        this.label = label;
        this.description = description;
        this.category = category;
        this.channelTypeReferences = channelTypeReferences;
    }

    public ChannelGroupTypeUID getUID() {
        return this.channelGroupTypeUID;
    }

    protected List<ChannelDefinition> toChannelDefinitions(List<ChannelXmlResult> channelTypeReferences) throws ConversionException {
        ArrayList<ChannelDefinition> channelTypeDefinitions = null;
        if (channelTypeReferences != null && channelTypeReferences.size() > 0) {
            channelTypeDefinitions = new ArrayList<ChannelDefinition>(channelTypeReferences.size());
            for (ChannelXmlResult channelTypeReference : channelTypeReferences) {
                channelTypeDefinitions.add(channelTypeReference.toChannelDefinition(this.channelGroupTypeUID.getBindingId()));
            }
        }
        return channelTypeDefinitions;
    }

    public ChannelGroupType toChannelGroupType() throws ConversionException {
        ChannelGroupType channelGroupType = new ChannelGroupType(this.channelGroupTypeUID, this.advanced, this.label, this.description, this.category, this.toChannelDefinitions(this.channelTypeReferences));
        return channelGroupType;
    }

    public String toString() {
        return "ChannelGroupTypeXmlResult [channelGroupTypeUID=" + this.channelGroupTypeUID + ", advanced=" + this.advanced + ", label=" + this.label + ", description=" + this.description + ", category=" + this.category + ", channelTypeReferences=" + this.channelTypeReferences + "]";
    }
}

