/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.xml.internal;

import com.thoughtworks.xstream.converters.ConversionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.smarthome.config.xml.util.NodeValue;
import org.eclipse.smarthome.core.thing.type.ChannelDefinition;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;
import org.eclipse.smarthome.core.thing.xml.internal.XmlHelper;

public class ChannelXmlResult {
    private String id;
    private String typeId;
    String label;
    String description;
    List<NodeValue> properties;

    public ChannelXmlResult(String id, String typeId, String label, String description, List<NodeValue> properties) {
        this.id = id;
        this.typeId = typeId;
        this.label = label;
        this.description = description;
        this.properties = properties;
    }

    public String getId() {
        return this.id;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public List<NodeValue> getProperties() {
        if (this.properties == null) {
            return new ArrayList<NodeValue>(0);
        }
        return this.properties;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "ChannelTypeXmlResult [id=" + this.id + ", typeId=" + this.typeId + ", properties=" + this.properties + "]";
    }

    protected ChannelDefinition toChannelDefinition(String bindingId) throws ConversionException {
        String id = this.getId();
        String typeId = this.getTypeId();
        String typeUID = this.getTypeUID(bindingId, typeId);
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        for (NodeValue property : this.getProperties()) {
            propertiesMap.put((String)property.getAttributes().get("name"), (String)property.getValue());
        }
        ChannelDefinition channelDefinition = new ChannelDefinition(id, new ChannelTypeUID(typeUID), propertiesMap, this.getLabel(), this.getDescription());
        return channelDefinition;
    }

    private String getTypeUID(String bindingId, String typeId) {
        if (typeId.startsWith("system.")) {
            return XmlHelper.getSystemUID(typeId);
        }
        return String.format("%s:%s", bindingId, typeId);
    }
}

