/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.type.ChannelKind;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;

public class Channel {
    private String acceptedItemType;
    private ChannelKind kind;
    private ChannelUID uid;
    private ChannelTypeUID channelTypeUID;
    private String label;
    private String description;
    private @NonNull Configuration configuration;
    private @NonNull Map<@NonNull String, String> properties;
    private Set<String> defaultTags = new LinkedHashSet<String>();

    Channel() {
        this.configuration = new Configuration();
        this.properties = Collections.unmodifiableMap(new HashMap(0));
    }

    public Channel(ChannelUID uid, String acceptedItemType) {
        this.uid = uid;
        this.acceptedItemType = acceptedItemType;
        this.kind = ChannelKind.STATE;
        this.configuration = new Configuration();
        this.properties = Collections.unmodifiableMap(new HashMap(0));
    }

    public Channel(ChannelUID uid, String acceptedItemType, Configuration configuration) {
        this(uid, null, acceptedItemType, ChannelKind.STATE, configuration, new HashSet<String>(0), null, null, null);
    }

    public Channel(ChannelUID uid, String acceptedItemType, Set<String> defaultTags) {
        this(uid, null, acceptedItemType, ChannelKind.STATE, null, defaultTags == null ? new HashSet<String>(0) : defaultTags, null, null, null);
    }

    public Channel(ChannelUID uid, String acceptedItemType, Configuration configuration, Set<String> defaultTags, Map<@NonNull String, String> properties) {
        this(uid, null, acceptedItemType, ChannelKind.STATE, null, defaultTags == null ? new HashSet<String>(0) : defaultTags, properties, null, null);
    }

    public Channel(ChannelUID uid, ChannelTypeUID channelTypeUID, String acceptedItemType, ChannelKind kind, Configuration configuration, Set<String> defaultTags, Map<@NonNull String, String> properties, String label, String description) {
        if (kind == null) {
            throw new IllegalArgumentException("kind must not be null");
        }
        this.uid = uid;
        this.channelTypeUID = channelTypeUID;
        this.acceptedItemType = acceptedItemType;
        this.kind = kind;
        this.label = label;
        this.description = description;
        this.defaultTags = Collections.unmodifiableSet(new HashSet<String>(defaultTags));
        this.configuration = configuration == null ? new Configuration() : configuration;
        this.properties = properties == null ? Collections.unmodifiableMap(new HashMap(0)) : properties;
    }

    public String getAcceptedItemType() {
        return this.acceptedItemType;
    }

    public ChannelKind getKind() {
        if (this.kind == null) {
            return ChannelKind.STATE;
        }
        return this.kind;
    }

    public ChannelUID getUID() {
        return this.uid;
    }

    public @Nullable ChannelTypeUID getChannelTypeUID() {
        return this.channelTypeUID;
    }

    public @Nullable String getLabel() {
        return this.label;
    }

    public @Nullable String getDescription() {
        return this.description;
    }

    public @NonNull Configuration getConfiguration() {
        return this.configuration;
    }

    public @NonNull Map<@NonNull String, String> getProperties() {
        return this.properties;
    }

    public Set<String> getDefaultTags() {
        return this.defaultTags;
    }
}

