/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.smarthome.core.i18n.TranslationProvider;
import org.eclipse.smarthome.core.thing.UID;
import org.eclipse.smarthome.core.thing.i18n.ThingTypeI18nUtil;
import org.eclipse.smarthome.core.thing.type.ChannelGroupType;
import org.eclipse.smarthome.core.thing.type.ChannelGroupTypeUID;
import org.eclipse.smarthome.core.thing.type.ChannelKind;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.type.ChannelTypeProvider;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;
import org.eclipse.smarthome.core.types.EventDescription;
import org.eclipse.smarthome.core.types.EventOption;
import org.eclipse.smarthome.core.types.StateDescription;
import org.eclipse.smarthome.core.types.StateOption;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class DefaultSystemChannelTypeProvider
implements ChannelTypeProvider {
    public static final ChannelType SYSTEM_CHANNEL_SIGNAL_STRENGTH = new ChannelType(new ChannelTypeUID("system:signal-strength"), false, "Number", "Signal Strength", null, "QualityOfService", null, new StateDescription(BigDecimal.ZERO, new BigDecimal(4), BigDecimal.ONE, null, true, Arrays.asList(new StateOption("0", "no signal"), new StateOption("1", "weak"), new StateOption("2", "average"), new StateOption("3", "good"), new StateOption("4", "excellent"))), null);
    public static final ChannelType SYSTEM_CHANNEL_LOW_BATTERY = new ChannelType(new ChannelTypeUID("system:low-battery"), false, "Switch", "Low Battery", null, "Battery", null, new StateDescription(null, null, null, null, true, null), null);
    public static final ChannelType SYSTEM_CHANNEL_BATTERY_LEVEL = new ChannelType(new ChannelTypeUID("system:battery-level"), false, "Number", "Battery Level", null, "Battery", null, new StateDescription(BigDecimal.ZERO, new BigDecimal(100), BigDecimal.ONE, "%.0f %%", true, null), null);
    public static final ChannelType SYSTEM_TRIGGER = new ChannelType(new ChannelTypeUID("system:trigger"), false, null, ChannelKind.TRIGGER, "Trigger", null, null, null, null, null, null);
    public static final ChannelType SYSTEM_RAWBUTTON = new ChannelType(new ChannelTypeUID("system:rawbutton"), false, null, ChannelKind.TRIGGER, "Raw button", null, null, null, null, new EventDescription(Arrays.asList(new EventOption("PRESSED", null), new EventOption("RELEASED", null))), null);
    public static final ChannelType SYSTEM_BUTTON = new ChannelType(new ChannelTypeUID("system:button"), false, null, ChannelKind.TRIGGER, "Button", null, null, null, null, new EventDescription(Arrays.asList(new EventOption("SHORT_PRESSED", null), new EventOption("DOUBLE_PRESSED", null), new EventOption("LONG_PRESSED", null))), null);
    public static final ChannelType SYSTEM_RAWROCKER = new ChannelType(new ChannelTypeUID("system:rawrocker"), false, null, ChannelKind.TRIGGER, "Raw rocker button", null, null, null, null, new EventDescription(Arrays.asList(new EventOption("DIR1_PRESSED", null), new EventOption("DIR1_RELEASED", null), new EventOption("DIR2_PRESSED", null), new EventOption("DIR2_RELEASED", null))), null);
    private final Collection<ChannelGroupType> channelGroupTypes;
    private final Collection<ChannelType> channelTypes;
    private final Map<LocalizedChannelTypeKey, ChannelType> localizedChannelTypeCache = new ConcurrentHashMap<LocalizedChannelTypeKey, ChannelType>();
    private ThingTypeI18nUtil thingTypeI18nUtil;

    public DefaultSystemChannelTypeProvider() {
        this.channelGroupTypes = Collections.emptyList();
        this.channelTypes = Collections.unmodifiableCollection(Arrays.asList(SYSTEM_CHANNEL_SIGNAL_STRENGTH, SYSTEM_CHANNEL_LOW_BATTERY, SYSTEM_CHANNEL_BATTERY_LEVEL, SYSTEM_TRIGGER, SYSTEM_RAWBUTTON, SYSTEM_BUTTON, SYSTEM_RAWROCKER));
    }

    @Override
    public Collection<ChannelType> getChannelTypes(Locale locale) {
        ArrayList<ChannelType> allChannelTypes = new ArrayList<ChannelType>(10);
        Bundle bundle = FrameworkUtil.getBundle(DefaultSystemChannelTypeProvider.class);
        for (ChannelType channelType : this.channelTypes) {
            allChannelTypes.add(this.createLocalizedChannelType(bundle, channelType, locale));
        }
        return allChannelTypes;
    }

    @Override
    public ChannelType getChannelType(ChannelTypeUID channelTypeUID, Locale locale) {
        Bundle bundle = FrameworkUtil.getBundle(DefaultSystemChannelTypeProvider.class);
        if (channelTypeUID.equals(SYSTEM_CHANNEL_SIGNAL_STRENGTH.getUID())) {
            return this.createLocalizedChannelType(bundle, SYSTEM_CHANNEL_SIGNAL_STRENGTH, locale);
        }
        if (channelTypeUID.equals(SYSTEM_CHANNEL_LOW_BATTERY.getUID())) {
            return this.createLocalizedChannelType(bundle, SYSTEM_CHANNEL_LOW_BATTERY, locale);
        }
        if (channelTypeUID.equals(SYSTEM_CHANNEL_BATTERY_LEVEL.getUID())) {
            return this.createLocalizedChannelType(bundle, SYSTEM_CHANNEL_BATTERY_LEVEL, locale);
        }
        if (channelTypeUID.equals(SYSTEM_TRIGGER.getUID())) {
            return this.createLocalizedChannelType(bundle, SYSTEM_TRIGGER, locale);
        }
        if (channelTypeUID.equals(SYSTEM_RAWBUTTON.getUID())) {
            return this.createLocalizedChannelType(bundle, SYSTEM_RAWBUTTON, locale);
        }
        if (channelTypeUID.equals(SYSTEM_BUTTON.getUID())) {
            return this.createLocalizedChannelType(bundle, SYSTEM_BUTTON, locale);
        }
        if (channelTypeUID.equals(SYSTEM_RAWROCKER.getUID())) {
            return this.createLocalizedChannelType(bundle, SYSTEM_RAWROCKER, locale);
        }
        return null;
    }

    @Override
    public ChannelGroupType getChannelGroupType(ChannelGroupTypeUID channelGroupTypeUID, Locale locale) {
        return null;
    }

    @Override
    public Collection<ChannelGroupType> getChannelGroupTypes(Locale locale) {
        return this.channelGroupTypes;
    }

    @Reference
    public void setTranslationProvider(TranslationProvider i18nProvider) {
        this.thingTypeI18nUtil = new ThingTypeI18nUtil(i18nProvider);
    }

    public void unsetTranslationProvider(TranslationProvider i18nProvider) {
        this.thingTypeI18nUtil = null;
    }

    private ChannelType createLocalizedChannelType(Bundle bundle, ChannelType channelType, Locale locale) {
        LocalizedChannelTypeKey localizedChannelTypeKey = this.getLocalizedChannelTypeKey(channelType.getUID(), locale);
        ChannelType cachedEntry = this.localizedChannelTypeCache.get(localizedChannelTypeKey);
        if (cachedEntry != null) {
            return cachedEntry;
        }
        if (this.thingTypeI18nUtil != null) {
            ChannelTypeUID channelTypeUID = channelType.getUID();
            String label = this.thingTypeI18nUtil.getChannelLabel(bundle, channelTypeUID, channelType.getLabel(), locale);
            String description = this.thingTypeI18nUtil.getChannelDescription(bundle, channelTypeUID, channelType.getDescription(), locale);
            StateDescription state = this.createLocalizedChannelState(bundle, channelType, channelTypeUID, locale);
            ChannelType localizedChannelType = new ChannelType(channelTypeUID, channelType.isAdvanced(), channelType.getItemType(), channelType.getKind(), label, description, channelType.getCategory(), channelType.getTags(), state, channelType.getEvent(), channelType.getConfigDescriptionURI());
            this.localizedChannelTypeCache.put(localizedChannelTypeKey, localizedChannelType);
            return localizedChannelType;
        }
        return channelType;
    }

    private StateDescription createLocalizedChannelState(Bundle bundle, ChannelType channelType, ChannelTypeUID channelTypeUID, Locale locale) {
        StateDescription state = channelType.getState();
        if (state != null) {
            String pattern = this.thingTypeI18nUtil.getChannelStatePattern(bundle, channelTypeUID, state.getPattern(), locale);
            ArrayList<StateOption> localizedOptions = new ArrayList<StateOption>();
            List options = state.getOptions();
            for (StateOption stateOption : options) {
                String optionLabel = this.thingTypeI18nUtil.getChannelStateOption(bundle, channelTypeUID, stateOption.getValue(), stateOption.getLabel(), locale);
                localizedOptions.add(new StateOption(stateOption.getValue(), optionLabel));
            }
            return new StateDescription(state.getMinimum(), state.getMaximum(), state.getStep(), pattern, state.isReadOnly(), localizedOptions);
        }
        return null;
    }

    private LocalizedChannelTypeKey getLocalizedChannelTypeKey(UID uid, Locale locale) {
        String localeString = locale != null ? locale.toLanguageTag() : null;
        LocalizedChannelTypeKey localizedChannelTypeKey = new LocalizedChannelTypeKey(uid, locale != null ? localeString : null);
        return localizedChannelTypeKey;
    }

    private static class LocalizedChannelTypeKey {
        public final String locale;
        public final UID uid;

        public LocalizedChannelTypeKey(UID uid, String locale) {
            this.uid = uid;
            this.locale = locale;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LocalizedChannelTypeKey other = (LocalizedChannelTypeKey)obj;
            if (this.locale == null ? other.locale != null : !this.locale.equals(other.locale)) {
                return false;
            }
            return !(this.uid == null ? other.uid != null : !this.uid.equals(other.uid));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
            result = 31 * result + (this.uid == null ? 0 : this.uid.hashCode());
            return result;
        }
    }
}

