/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.binding;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.config.core.ConfigDescriptionRegistry;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerFactory;
import org.eclipse.smarthome.core.thing.binding.builder.BridgeBuilder;
import org.eclipse.smarthome.core.thing.binding.builder.ThingBuilder;
import org.eclipse.smarthome.core.thing.internal.ThingFactoryHelper;
import org.eclipse.smarthome.core.thing.type.BridgeType;
import org.eclipse.smarthome.core.thing.type.ThingType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class ThingFactory {
    private static final Logger logger = LoggerFactory.getLogger(ThingFactory.class);

    public static ThingUID generateRandomThingUID(ThingTypeUID thingTypeUID) {
        String uuid = UUID.randomUUID().toString();
        String thingId = uuid.substring(uuid.length() - 12, uuid.length());
        return new ThingUID(thingTypeUID, thingId);
    }

    public static Thing createThing(ThingType thingType, ThingUID thingUID, Configuration configuration, @Nullable ThingUID bridgeUID) {
        return ThingFactory.createThing(thingType, thingUID, configuration, bridgeUID, null);
    }

    public static Thing createThing(ThingType thingType, ThingUID thingUID, Configuration configuration, @Nullable ThingUID bridgeUID, @Nullable ConfigDescriptionRegistry configDescriptionRegistry) {
        ThingFactoryHelper.applyDefaultConfiguration(configuration, thingType, configDescriptionRegistry);
        List<Channel> channels = ThingFactoryHelper.createChannels(thingType, thingUID, configDescriptionRegistry);
        return ThingFactory.createThingBuilder(thingType, thingUID).withConfiguration(configuration).withChannels(channels).withProperties(thingType.getProperties()).withBridge(bridgeUID).build();
    }

    public static @Nullable Thing createThing(ThingUID thingUID, Configuration configuration, @Nullable Map<String, String> properties, @Nullable ThingUID bridgeUID, ThingTypeUID thingTypeUID, List<ThingHandlerFactory> thingHandlerFactories) {
        for (ThingHandlerFactory thingHandlerFactory : thingHandlerFactories) {
            if (!thingHandlerFactory.supportsThingType(thingTypeUID)) continue;
            Thing thing = thingHandlerFactory.createThing(thingTypeUID, configuration, thingUID, bridgeUID);
            if (thing == null) {
                logger.error("Thing factory ({}) returned null on create thing when it reports to support the thing type ({}).", thingHandlerFactory.getClass(), (Object)thingTypeUID);
            } else if (properties != null) {
                for (String key : properties.keySet()) {
                    thing.setProperty(key, properties.get(key));
                }
            }
            return thing;
        }
        return null;
    }

    public static Thing createThing(ThingType thingType, ThingUID thingUID, Configuration configuration) {
        return ThingFactory.createThing(thingType, thingUID, configuration, null);
    }

    private static ThingBuilder createThingBuilder(ThingType thingType, ThingUID thingUID) {
        if (thingType instanceof BridgeType) {
            return BridgeBuilder.create(thingType.getUID(), thingUID);
        }
        return ThingBuilder.create(thingType.getUID(), thingUID);
    }
}

